/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.RelativeResourceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a0\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\"\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0003\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0006\u001a,\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00012\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a0\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00182\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a,\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"separator", "", "getIdentifiedSourceSetMap", "", "resourceSourceSets", "", "Ljava/io/File;", "namespace", "projectPath", "getRelativeSourceSetPath", "resourceFile", "moduleSourceSets", "isRelativeSourceSetResource", "", "filepath", "mergeIdentifiedSourceSetFiles", "sourceSetFiles", "readFromSourceSetPathsFile", "artifactFile", "relativeResourcePathToAbsolutePath", "relativePath", "sourceSetPathMap", "fileSystem", "Ljava/nio/file/FileSystem;", "Lkotlin/Function1;", "writeIdentifiedSourceSetsFile", "", "output", "sdk-common"})
@JvmName(name="RelativeResourceUtils")
public final class RelativeResourceUtils {
    @NotNull
    private static final String separator = ":/";

    @NotNull
    public static final String getRelativeSourceSetPath(@NotNull File resourceFile, @NotNull Map<String, String> moduleSourceSets) {
        Intrinsics.checkNotNullParameter((Object)resourceFile, (String)"resourceFile");
        Intrinsics.checkNotNullParameter(moduleSourceSets, (String)"moduleSourceSets");
        String absoluteResFilePath = resourceFile.getAbsolutePath();
        for (Map.Entry<String, String> entry : moduleSourceSets.entrySet()) {
            String identifier = entry.getKey();
            String absoluteSourceSetPath = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)absoluteResFilePath, (String)"absoluteResFilePath");
            if (!StringsKt.startsWith$default((String)absoluteResFilePath, (String)absoluteSourceSetPath, (boolean)false, (int)2, null)) continue;
            File file = resourceFile.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resourceFile.absoluteFile");
            String invariantFilePath = FilesKt.getInvariantSeparatorsPath((File)file);
            File file2 = new File(absoluteSourceSetPath).getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"File(absoluteSourceSetPath).absoluteFile");
            int resIndex = FilesKt.getInvariantSeparatorsPath((File)file2).length();
            String string = invariantFilePath;
            int n = resIndex + 1;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String relativePathToSourceSet = string3;
            return identifier + separator + relativePathToSourceSet;
        }
        throw new IllegalArgumentException("Unable to locate resourceFile (" + absoluteResFilePath + ") in source-sets.");
    }

    @NotNull
    public static final String relativeResourcePathToAbsolutePath(@NotNull String relativePath, @NotNull Map<String, String> sourceSetPathMap, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(sourceSetPathMap, (String)"sourceSetPathMap");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        return (String)RelativeResourceUtils.relativeResourcePathToAbsolutePath(sourceSetPathMap, fileSystem).invoke((Object)relativePath);
    }

    public static /* synthetic */ String relativeResourcePathToAbsolutePath$default(String string, Map map, FileSystem fileSystem, int n, Object object) {
        if ((n & 4) != 0) {
            FileSystem fileSystem2 = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getDefault()");
            fileSystem = fileSystem2;
        }
        return RelativeResourceUtils.relativeResourcePathToAbsolutePath(string, map, fileSystem);
    }

    @NotNull
    public static final Function1<String, String> relativeResourcePathToAbsolutePath(@NotNull Map<String, String> sourceSetPathMap, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter(sourceSetPathMap, (String)"sourceSetPathMap");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        return (Function1)new Function1<String, String>(sourceSetPathMap, fileSystem){
            final /* synthetic */ Map<String, String> $sourceSetPathMap;
            final /* synthetic */ FileSystem $fileSystem;
            {
                this.$sourceSetPathMap = $sourceSetPathMap;
                this.$fileSystem = $fileSystem;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String relativePath) {
                String string;
                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                if (MapsKt.none(this.$sourceSetPathMap)) {
                    throw new IllegalStateException("Unable to get absolute path from " + relativePath + "\n                   because no relative root paths are present.");
                }
                int separatorIndex = StringsKt.indexOf$default((CharSequence)relativePath, (String)":/", (int)0, (boolean)false, (int)6, null);
                if (separatorIndex == -1) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Source set identifier and relative path must be separated by a \":/\".\n                   Relative path: ", (Object)relativePath));
                }
                String string2 = relativePath;
                int n = 0;
                String string3 = string2.substring(n, separatorIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String sourceSetPrefix = string3;
                String string4 = relativePath;
                int n2 = separatorIndex + StringsKt.getLastIndex((CharSequence)":/");
                int n3 = relativePath.length();
                String string5 = string4.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String resourcePathFromSourceSet = string5;
                if (!Intrinsics.areEqual((Object)"/", (Object)this.$fileSystem.getSeparator())) {
                    String string6 = this.$fileSystem.getSeparator();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"fileSystem.separator");
                    string = StringsKt.replace$default((String)resourcePathFromSourceSet, (String)"/", (String)string6, (boolean)false, (int)4, null);
                } else {
                    string = resourcePathFromSourceSet;
                }
                String systemRelativePath = string;
                String string7 = this.$sourceSetPathMap.get(sourceSetPrefix);
                if (string7 == null) {
                    throw new NoSuchElementException("Unable to get absolute path from " + relativePath + "\n                       because " + sourceSetPrefix + " is not key in sourceSetPathMap.");
                }
                String absolutePath = string7;
                return Intrinsics.stringPlus((String)absolutePath, (Object)systemRelativePath);
            }
        };
    }

    public static /* synthetic */ Function1 relativeResourcePathToAbsolutePath$default(Map map, FileSystem fileSystem, int n, Object object) {
        if ((n & 2) != 0) {
            FileSystem fileSystem2 = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getDefault()");
            fileSystem = fileSystem2;
        }
        return RelativeResourceUtils.relativeResourcePathToAbsolutePath(map, fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> readFromSourceSetPathsFile(@NotNull File artifactFile) {
        Map map;
        Object object;
        Intrinsics.checkNotNullParameter((Object)artifactFile, (String)"artifactFile");
        if (!artifactFile.exists() || !artifactFile.isFile()) {
            throw new IOException(artifactFile + " does not exist or is not a file.");
        }
        Object object2 = artifactFile;
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = object2;
        object = new InputStreamReader((InputStream)(object4 = (InputStream)new FileInputStream((File)object4)), (Charset)object3);
        object2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        object3 = null;
        try {
            void $this$associateTo$iv$iv;
            BufferedReader bufferedReader = (BufferedReader)object2;
            boolean bl = false;
            Sequence $this$associate$iv = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
            boolean $i$f$associate = false;
            object4 = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)it, (String)" ", null, (int)2, null), (Object)StringsKt.substringAfter$default((String)it, (String)" ", null, (int)2, null));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeIdentifiedSourceSetsFile(@NotNull List<? extends File> resourceSourceSets, @NotNull String namespace, @NotNull String projectPath, @NotNull File output) {
        Intrinsics.checkNotNullParameter(resourceSourceSets, (String)"resourceSourceSets");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Object object = output;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        Map<String, String> map = object3;
        map = new FileOutputStream((File)((Object)map));
        object3 = new OutputStreamWriter((OutputStream)((Object)map), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter bw = (BufferedWriter)object;
            boolean bl = false;
            Map<String, String> $this$forEach$iv = RelativeResourceUtils.getIdentifiedSourceSetMap(resourceSourceSets, namespace, projectPath);
            boolean $i$f$forEach = false;
            map = $this$forEach$iv;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl2 = false;
                bw.write(it.getKey() + ' ' + it.getValue() + '\n');
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> mergeIdentifiedSourceSetFiles(@NotNull List<? extends File> sourceSetFiles) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map map;
        Intrinsics.checkNotNullParameter(sourceSetFiles, (String)"sourceSetFiles");
        Map identifiedSourceMap = map = (Map)new LinkedHashMap();
        boolean bl = false;
        Iterable iterable = sourceSetFiles;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(RelativeResourceUtils.readFromSourceSetPathsFile((File)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl3 = false;
            identifiedSourceMap.putAll(it);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> getIdentifiedSourceSetMap(@NotNull List<? extends File> resourceSourceSets, @NotNull String namespace, @NotNull String projectPath) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Sequence $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(resourceSourceSets, (String)"resourceSourceSets");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        String projectName = StringsKt.substringAfterLast$default((String)projectPath, (String)":", null, (int)2, null);
        int i = 0;
        Sequence sequence = SequencesKt.distinctBy((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)resourceSourceSets)), (Function1)((Function1)getIdentifiedSourceSetMap.1.INSTANCE));
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File p0 = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)FilesKt.getInvariantSeparatorsPath((File)p0));
                p0 = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)FilesKt.getInvariantSeparatorsPath((File)p0))));
            }
        });
        boolean $i$f$associate = false;
        void var7_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            File sourceSet = (File)element$iv$iv;
            boolean bl = false;
            String sourceSetFolderName = sourceSet.getParentFile().getName();
            String appendProjectName = StringsKt.endsWith$default((String)namespace, (String)projectName, (boolean)false, (int)2, null) ? "" : Intrinsics.stringPlus((String)".", (Object)projectName);
            int n = i;
            i = n + 1;
            String appId = namespace + appendProjectName + '-' + sourceSetFolderName + '-' + n;
            Pair pair = TuplesKt.to((Object)appId, (Object)sourceSet.getAbsolutePath());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public static final boolean isRelativeSourceSetResource(@NotNull String filepath) {
        Intrinsics.checkNotNullParameter((Object)filepath, (String)"filepath");
        return StringsKt.contains$default((CharSequence)filepath, (CharSequence)separator, (boolean)false, (int)2, null);
    }
}

