/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.EnumBasedResourceQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceEnum;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DensityQualifier
extends EnumBasedResourceQualifier {
    public static final String NAME = "Density";
    private static final DensityQualifier NULL_QUALIFIER = new DensityQualifier(true);
    private final Density mValue;
    private static final Pattern sDensityLegacyPattern = Pattern.compile("^(\\d+)dpi$");

    public DensityQualifier() {
        this(Density.MEDIUM);
    }

    public DensityQualifier(Density value) {
        this.mValue = value;
    }

    private DensityQualifier(boolean ignored) {
        this.mValue = null;
    }

    public Density getValue() {
        return this.mValue;
    }

    @Override
    public ResourceEnum getEnumValue() {
        return this.mValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 4;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        Matcher m;
        Density density = Density.getEnum((String)value);
        if (density == null && (m = sDensityLegacyPattern.matcher(value)).matches()) {
            String v = m.group(1);
            try {
                density = Density.getEnum((int)Integer.parseInt(v));
            }
            catch (NumberFormatException e) {
                throw new AssertionError((Object)e);
            }
        }
        if (density != null) {
            config.setDensityQualifier(new DensityQualifier(density));
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this != NULL_QUALIFIER;
    }

    @Override
    public DensityQualifier getNullQualifier() {
        return NULL_QUALIFIER;
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        return qualifier instanceof DensityQualifier;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo2, ResourceQualifier reference) {
        if (compareTo2 == null) {
            return true;
        }
        Density other = ((DensityQualifier)compareTo2).mValue;
        Density required = ((DensityQualifier)reference).mValue;
        assert (required != null) : "NULL_QUALIFIER Density Qualifier shouldn't be part of the reference";
        Density value = this.mValue;
        if (value == other) {
            return false;
        }
        value = value == null ? Density.MEDIUM : value;
        Density density = other = other == null ? Density.MEDIUM : other;
        if (value == Density.ANYDPI) {
            return true;
        }
        if (other == Density.ANYDPI) {
            return false;
        }
        if (required == Density.ANYDPI || required == Density.NODPI) {
            required = Density.MEDIUM;
        }
        int requiredDensity = required.getDpiValue();
        int high = value.getDpiValue();
        int low = other.getDpiValue();
        boolean bImBigger = true;
        if (low > high) {
            int temp = high;
            high = low;
            low = temp;
            bImBigger = false;
        } else if (low == high && low == Density.MEDIUM.getDpiValue()) {
            return requiredDensity >= Density.MEDIUM.getDpiValue() ^ this == NULL_QUALIFIER;
        }
        if (requiredDensity > high) {
            return bImBigger;
        }
        if (low >= requiredDensity) {
            return !bImBigger;
        }
        if ((2 * low - requiredDensity) * high > requiredDensity * requiredDensity) {
            return !bImBigger;
        }
        return bImBigger;
    }
}

