/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.AssetFile;
import com.android.ide.common.resources.DataItem;
import com.google.common.io.Files;
import java.io.File;
import java.util.Locale;

class AssetItem
extends DataItem<AssetFile> {
    AssetItem(String name) {
        super(name);
    }

    static AssetItem create(File sourceFolder, File file) {
        StringBuilder sb = new StringBuilder();
        AssetItem.computePath(sb, file.getParentFile(), sourceFolder);
        String fileName = file.getName();
        sb.append(AssetItem.shouldBeUnGzipped(fileName) ? Files.getNameWithoutExtension((String)fileName) : fileName);
        return new AssetItem(sb.toString());
    }

    private static void computePath(StringBuilder sb, File current, File stop) {
        if (current.equals(stop)) {
            return;
        }
        AssetItem.computePath(sb, current.getParentFile(), stop);
        sb.append(current.getName()).append('/');
    }

    boolean shouldBeUnGzipped() {
        return AssetItem.shouldBeUnGzipped(this.getFile().getName());
    }

    private static boolean shouldBeUnGzipped(String fileName) {
        return Files.getFileExtension((String)fileName).toLowerCase(Locale.US).equals("gz");
    }
}

