/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.usage.ResourceUsageKt;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceFolderType;
import com.android.utils.XmlUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\t\u001a\u00020\u0004\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"getDeclaredAndReferencedResourcesFrom", "", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "resourceFile", "Ljava/io/File;", "resourceUsageModel", "Lcom/android/ide/common/resources/usage/ResourceUsageModel;", "getResourcesFromDirectory", "", "directory", "getResourcesFromExplodedAarToFile", "explodedAar", "sdk-common"})
public final class ResourceUsageKt {
    @NotNull
    public static final List<String> getResourcesFromExplodedAarToFile(@NotNull File explodedAar) {
        Intrinsics.checkParameterIsNotNull((Object)explodedAar, (String)"explodedAar");
        File resourceDir = FilesKt.resolve((File)explodedAar, (String)"res");
        return ResourceUsageKt.getResourcesFromDirectory(resourceDir);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getResourcesFromDirectory(@NotNull File directory) {
        void $this$mapTo$iv$iv;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
                if (directory.list() == null) break block6;
                Object[] objectArray = directory.listFiles();
                if (objectArray == null) {
                    Intrinsics.throwNpe();
                }
                if (!ArraysKt.none((Object[])objectArray)) break block7;
            }
            return CollectionsKt.emptyList();
        }
        ResourceUsageModel resourceUsageModel = new ResourceUsageModel();
        Iterable $this$forEach$iv = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)directory, null, (int)1, null)), (Function1)getResourcesFromDirectory.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            ResourceUsageKt.getDeclaredAndReferencedResourcesFrom(it, resourceUsageModel);
        }
        List<ResourceUsageModel.Resource> list = resourceUsageModel.getResources();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"resourceUsageModel.resources");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<ResourceUsageModel.Resource> getDeclaredAndReferencedResourcesFrom(@NotNull File resourceFile, @NotNull ResourceUsageModel resourceUsageModel) {
        Intrinsics.checkParameterIsNotNull((Object)resourceFile, (String)"resourceFile");
        Intrinsics.checkParameterIsNotNull((Object)resourceUsageModel, (String)"resourceUsageModel");
        File file = resourceFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"resourceFile.parentFile");
        ResourceFolderType resFolderType = ResourceFolderType.getTypeByName((String)file.getName());
        String string = resourceFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resourceFile.name");
        if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null) && resFolderType != ResourceFolderType.RAW) {
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
            String resourceString = FilesKt.readText((File)resourceFile, (Charset)charset);
            Document document = XmlUtils.parseDocument((String)resourceString, (boolean)false);
            resourceUsageModel.visitXmlDocument(resourceFile, resFolderType, document);
        } else {
            resourceUsageModel.visitBinaryResource(resFolderType, resourceFile);
        }
        List<ResourceUsageModel.Resource> list = resourceUsageModel.getResources();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"resourceUsageModel.resources");
        return list;
    }

    public static /* synthetic */ List getDeclaredAndReferencedResourcesFrom$default(File file, ResourceUsageModel resourceUsageModel, int n, Object object) {
        if ((n & 2) != 0) {
            resourceUsageModel = new ResourceUsageModel();
        }
        return ResourceUsageKt.getDeclaredAndReferencedResourcesFrom(file, resourceUsageModel);
    }
}

