/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeModel;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class IdeSourceProvider
implements SourceProvider,
Serializable {
    private static final long serialVersionUID = 3L;
    private final String myName;
    private final File myManifestFile;
    private final Collection<File> myJavaDirectories;
    private final Collection<File> myResourcesDirectories;
    private final Collection<File> myAidlDirectories;
    private final Collection<File> myRenderscriptDirectories;
    private final Collection<File> myCDirectories;
    private final Collection<File> myCppDirectories;
    private final Collection<File> myResDirectories;
    private final Collection<File> myAssetsDirectories;
    private final Collection<File> myJniLibsDirectories;
    private final Collection<File> myShadersDirectories;
    private final Collection<File> myMlModelsDirectories;
    private final int myHashCode;

    IdeSourceProvider() {
        this.myName = "";
        this.myManifestFile = null;
        this.myJavaDirectories = Collections.emptyList();
        this.myResourcesDirectories = Collections.emptyList();
        this.myAidlDirectories = Collections.emptyList();
        this.myRenderscriptDirectories = Collections.emptyList();
        this.myCDirectories = Collections.emptyList();
        this.myCppDirectories = Collections.emptyList();
        this.myResDirectories = Collections.emptyList();
        this.myAssetsDirectories = Collections.emptyList();
        this.myJniLibsDirectories = Collections.emptyList();
        this.myShadersDirectories = Collections.emptyList();
        this.myMlModelsDirectories = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeSourceProvider(SourceProvider provider) {
        this.myName = provider.getName();
        this.myManifestFile = provider.getManifestFile();
        this.myJavaDirectories = ImmutableList.copyOf((Collection)provider.getJavaDirectories());
        this.myResourcesDirectories = ImmutableList.copyOf((Collection)provider.getResourcesDirectories());
        this.myAidlDirectories = ImmutableList.copyOf((Collection)provider.getAidlDirectories());
        this.myRenderscriptDirectories = ImmutableList.copyOf((Collection)provider.getRenderscriptDirectories());
        this.myCDirectories = ImmutableList.copyOf((Collection)provider.getCDirectories());
        this.myCppDirectories = ImmutableList.copyOf((Collection)provider.getCppDirectories());
        this.myResDirectories = ImmutableList.copyOf((Collection)provider.getResDirectories());
        this.myAssetsDirectories = ImmutableList.copyOf((Collection)provider.getAssetsDirectories());
        this.myJniLibsDirectories = ImmutableList.copyOf((Collection)provider.getJniLibsDirectories());
        this.myShadersDirectories = IdeModel.copyNewProperty(() -> ImmutableList.copyOf((Collection)provider.getShadersDirectories()), Collections.emptyList());
        this.myMlModelsDirectories = IdeModel.copyNewProperty(() -> ImmutableList.copyOf((Collection)provider.getMlModelsDirectories()), Collections.emptyList());
        this.myHashCode = this.calculateHashCode();
    }

    public String getName() {
        return this.myName;
    }

    public File getManifestFile() {
        return this.myManifestFile;
    }

    public Collection<File> getJavaDirectories() {
        return this.myJavaDirectories;
    }

    public Collection<File> getResourcesDirectories() {
        return this.myResourcesDirectories;
    }

    public Collection<File> getAidlDirectories() {
        return this.myAidlDirectories;
    }

    public Collection<File> getRenderscriptDirectories() {
        return this.myRenderscriptDirectories;
    }

    public Collection<File> getCDirectories() {
        return this.myCDirectories;
    }

    public Collection<File> getCppDirectories() {
        return this.myCppDirectories;
    }

    public Collection<File> getResDirectories() {
        return this.myResDirectories;
    }

    public Collection<File> getAssetsDirectories() {
        return this.myAssetsDirectories;
    }

    public Collection<File> getJniLibsDirectories() {
        return this.myJniLibsDirectories;
    }

    public Collection<File> getShadersDirectories() {
        return this.myShadersDirectories;
    }

    public Collection<File> getMlModelsDirectories() {
        return this.myMlModelsDirectories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSourceProvider)) {
            return false;
        }
        IdeSourceProvider provider = (IdeSourceProvider)o;
        return Objects.equals(this.myName, provider.myName) && Objects.equals(this.myManifestFile, provider.myManifestFile) && Objects.equals(this.myJavaDirectories, provider.myJavaDirectories) && Objects.equals(this.myResourcesDirectories, provider.myResourcesDirectories) && Objects.equals(this.myAidlDirectories, provider.myAidlDirectories) && Objects.equals(this.myRenderscriptDirectories, provider.myRenderscriptDirectories) && Objects.equals(this.myCDirectories, provider.myCDirectories) && Objects.equals(this.myCppDirectories, provider.myCppDirectories) && Objects.equals(this.myResDirectories, provider.myResDirectories) && Objects.equals(this.myAssetsDirectories, provider.myAssetsDirectories) && Objects.equals(this.myJniLibsDirectories, provider.myJniLibsDirectories) && Objects.equals(this.myShadersDirectories, provider.myShadersDirectories) && Objects.equals(this.myMlModelsDirectories, provider.myMlModelsDirectories);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myName, this.myManifestFile, this.myJavaDirectories, this.myResourcesDirectories, this.myAidlDirectories, this.myRenderscriptDirectories, this.myCDirectories, this.myCppDirectories, this.myResDirectories, this.myAssetsDirectories, this.myJniLibsDirectories, this.myShadersDirectories, this.myMlModelsDirectories);
    }

    public String toString() {
        return "IdeSourceProvider{myName='" + this.myName + '\'' + ", myManifestFile=" + this.myManifestFile + ", myJavaDirectories=" + this.myJavaDirectories + ", myResourcesDirectories=" + this.myResourcesDirectories + ", myAidlDirectories=" + this.myAidlDirectories + ", myRenderscriptDirectories=" + this.myRenderscriptDirectories + ", myCDirectories=" + this.myCDirectories + ", myCppDirectories=" + this.myCppDirectories + ", myResDirectories=" + this.myResDirectories + ", myAssetsDirectories=" + this.myAssetsDirectories + ", myJniLibsDirectories=" + this.myJniLibsDirectories + ", myShadersDirectories=" + this.myShadersDirectories + ", myMlModelsDirectories=" + this.myMlModelsDirectories + '}';
    }
}

