/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeProductFlavor;
import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.ide.common.gradle.model.IdeSourceProviderContainer;
import com.android.ide.common.gradle.model.ModelCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class IdeProductFlavorContainer
implements ProductFlavorContainer,
Serializable {
    private static final long serialVersionUID = 2L;
    private final ProductFlavor myProductFlavor;
    private final SourceProvider mySourceProvider;
    private final Collection<SourceProviderContainer> myExtraSourceProviders;
    private final int myHashCode;

    IdeProductFlavorContainer() {
        this.myProductFlavor = new IdeProductFlavor();
        this.mySourceProvider = new IdeSourceProvider();
        this.myExtraSourceProviders = Collections.emptyList();
        this.myHashCode = 0;
    }

    public IdeProductFlavorContainer(ProductFlavorContainer container, ModelCache modelCache) {
        this.myProductFlavor = modelCache.computeIfAbsent(container.getProductFlavor(), flavor -> new IdeProductFlavor((ProductFlavor)flavor, modelCache));
        this.mySourceProvider = modelCache.computeIfAbsent(container.getSourceProvider(), provider -> new IdeSourceProvider((SourceProvider)provider));
        this.myExtraSourceProviders = IdeModel.copy(container.getExtraSourceProviders(), modelCache, sourceProviderContainer -> new IdeSourceProviderContainer((SourceProviderContainer)sourceProviderContainer, modelCache));
        this.myHashCode = this.calculateHashCode();
    }

    public ProductFlavor getProductFlavor() {
        return this.myProductFlavor;
    }

    public SourceProvider getSourceProvider() {
        return this.mySourceProvider;
    }

    public Collection<SourceProviderContainer> getExtraSourceProviders() {
        return this.myExtraSourceProviders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeProductFlavorContainer)) {
            return false;
        }
        IdeProductFlavorContainer container = (IdeProductFlavorContainer)o;
        return Objects.equals(this.myProductFlavor, container.myProductFlavor) && Objects.equals(this.mySourceProvider, container.mySourceProvider) && Objects.equals(this.myExtraSourceProviders, container.myExtraSourceProviders);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myProductFlavor, this.mySourceProvider, this.myExtraSourceProviders);
    }

    public String toString() {
        return "IdeProductFlavorContainer{myProductFlavor=" + this.myProductFlavor + ", mySourceProvider=" + this.mySourceProvider + ", myExtraSourceProviders=" + this.myExtraSourceProviders + "}";
    }
}

