/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.build.FilterData;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Objects;

public final class IdeFilterData
implements FilterData,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myIdentifier;
    private final String myFilterType;
    private final int myHashCode;

    @VisibleForTesting
    public IdeFilterData() {
        this.myIdentifier = "";
        this.myFilterType = "";
        this.myHashCode = 0;
    }

    public IdeFilterData(FilterData data) {
        this.myIdentifier = data.getIdentifier();
        this.myFilterType = data.getFilterType();
        this.myHashCode = this.calculateHashCode();
    }

    public String getIdentifier() {
        return this.myIdentifier;
    }

    public String getFilterType() {
        return this.myFilterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeFilterData)) {
            return false;
        }
        IdeFilterData data = (IdeFilterData)o;
        return Objects.equals(this.myIdentifier, data.myIdentifier) && Objects.equals(this.myFilterType, data.myFilterType);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myIdentifier, this.myFilterType);
    }

    public String toString() {
        return "IdeFilterData{myIdentifier='" + this.myIdentifier + '\'' + ", myFilterType='" + this.myFilterType + '\'' + "}";
    }
}

