/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.ClassField;
import com.android.builder.model.CodeShrinker;
import com.android.builder.model.InstantRun;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.TestOptions;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeAndroidArtifactOutput;
import com.android.ide.common.gradle.model.IdeBaseArtifactImpl;
import com.android.ide.common.gradle.model.IdeInstantRun;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeNativeLibrary;
import com.android.ide.common.gradle.model.IdeTestOptions;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class IdeAndroidArtifactImpl
extends IdeBaseArtifactImpl
implements IdeAndroidArtifact {
    private static final long serialVersionUID = 5L;
    private final Collection<AndroidArtifactOutput> myOutputs;
    private final String myApplicationId;
    private final String mySourceGenTaskName;
    private final Collection<File> myGeneratedResourceFolders;
    private final Collection<File> myAdditionalRuntimeApks;
    private final IdeInstantRun myInstantRun;
    private final String mySigningConfigName;
    private final Set<String> myAbiFilters;
    private final Collection<NativeLibrary> myNativeLibraries;
    private final IdeTestOptions myTestOptions;
    private final String myInstrumentedTestTaskName;
    private final String myBundleTaskName;
    private final String myPostBundleTaskModelFile;
    private final String myApkFromBundleTaskName;
    private final String myPostApkFromBundleTaskModelFile;
    private final CodeShrinker myCodeShrinker;
    private final boolean mySigned;
    private final int myHashCode;

    IdeAndroidArtifactImpl() {
        this.myOutputs = Collections.emptyList();
        this.myApplicationId = "";
        this.mySourceGenTaskName = "";
        this.myGeneratedResourceFolders = Collections.emptyList();
        this.myAdditionalRuntimeApks = Collections.emptyList();
        this.myInstantRun = null;
        this.mySigningConfigName = null;
        this.myAbiFilters = Collections.emptySet();
        this.myNativeLibraries = null;
        this.myTestOptions = null;
        this.myInstrumentedTestTaskName = null;
        this.myBundleTaskName = null;
        this.myPostBundleTaskModelFile = null;
        this.myApkFromBundleTaskName = null;
        this.myPostApkFromBundleTaskModelFile = null;
        this.mySigned = false;
        this.myCodeShrinker = null;
        this.myHashCode = 0;
    }

    public IdeAndroidArtifactImpl(AndroidArtifact artifact, ModelCache modelCache, IdeDependenciesFactory dependenciesFactory, GradleVersion agpVersion) {
        super((BaseArtifact)artifact, modelCache, dependenciesFactory, agpVersion);
        this.myOutputs = IdeAndroidArtifactImpl.copyOutputs(artifact, modelCache, agpVersion);
        this.myApplicationId = artifact.getApplicationId();
        this.mySourceGenTaskName = artifact.getSourceGenTaskName();
        this.myGeneratedResourceFolders = ImmutableList.copyOf((Collection)artifact.getGeneratedResourceFolders());
        this.myInstantRun = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getInstantRun(), IdeInstantRun::new, null);
        this.mySigningConfigName = artifact.getSigningConfigName();
        this.myAbiFilters = ImmutableSet.copyOf((Collection)((Collection)MoreObjects.firstNonNull((Object)artifact.getAbiFilters(), (Object)ImmutableSet.of())));
        this.myNativeLibraries = IdeAndroidArtifactImpl.copy(modelCache, artifact.getNativeLibraries());
        this.mySigned = artifact.isSigned();
        this.myAdditionalRuntimeApks = IdeModel.copyNewPropertyNonNull(() -> ((AndroidArtifact)artifact).getAdditionalRuntimeApks(), Collections.emptySet());
        this.myTestOptions = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getTestOptions(), IdeTestOptions::new, null);
        this.myInstrumentedTestTaskName = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getInstrumentedTestTaskName(), Function.identity(), null);
        this.myBundleTaskName = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getBundleTaskName(), Function.identity(), null);
        this.myPostBundleTaskModelFile = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getBundleTaskOutputListingFile(), Function.identity(), null);
        this.myApkFromBundleTaskName = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getApkFromBundleTaskName(), Function.identity(), null);
        this.myPostApkFromBundleTaskModelFile = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getApkFromBundleTaskOutputListingFile(), Function.identity(), null);
        this.myCodeShrinker = IdeModel.copyNewProperty(modelCache, () -> ((AndroidArtifact)artifact).getCodeShrinker(), Function.identity(), null);
        this.myHashCode = this.calculateHashCode();
    }

    private static Collection<AndroidArtifactOutput> copyOutputs(AndroidArtifact artifact, ModelCache modelCache, GradleVersion agpVersion) {
        if (agpVersion != null && agpVersion.compareIgnoringQualifiers("4.0.0") >= 0) {
            return Collections.emptyList();
        }
        try {
            Collection outputs = artifact.getOutputs();
            return IdeModel.copy(outputs, modelCache, output -> new IdeAndroidArtifactOutput((AndroidArtifactOutput)output, modelCache));
        }
        catch (RuntimeException e) {
            System.err.println("Caught exception: " + e);
            return Collections.emptyList();
        }
    }

    private static Collection<NativeLibrary> copy(ModelCache modelCache, Collection<NativeLibrary> original) {
        return original != null ? IdeModel.copy(original, modelCache, IdeNativeLibrary::new) : null;
    }

    public Collection<AndroidArtifactOutput> getOutputs() {
        return this.myOutputs;
    }

    public String getApplicationId() {
        return this.myApplicationId;
    }

    public String getSourceGenTaskName() {
        return this.mySourceGenTaskName;
    }

    public Collection<File> getGeneratedResourceFolders() {
        return this.myGeneratedResourceFolders;
    }

    public Map<String, ClassField> getResValues() {
        return Collections.emptyMap();
    }

    public InstantRun getInstantRun() {
        if (this.myInstantRun != null) {
            return this.myInstantRun;
        }
        throw new UnsupportedOperationException("Unsupported method: AndroidArtifact.getInstantRun()");
    }

    public Collection<File> getAdditionalRuntimeApks() {
        return this.myAdditionalRuntimeApks;
    }

    public TestOptions getTestOptions() {
        return this.myTestOptions;
    }

    public String getInstrumentedTestTaskName() {
        return this.myInstrumentedTestTaskName;
    }

    public String getBundleTaskName() {
        return this.myBundleTaskName;
    }

    public String getBundleTaskOutputListingFile() {
        return this.myPostBundleTaskModelFile;
    }

    public String getApkFromBundleTaskName() {
        return this.myApkFromBundleTaskName;
    }

    public String getApkFromBundleTaskOutputListingFile() {
        return this.myPostApkFromBundleTaskModelFile;
    }

    public CodeShrinker getCodeShrinker() {
        return this.myCodeShrinker;
    }

    public String getSigningConfigName() {
        return this.mySigningConfigName;
    }

    @Override
    public Set<String> getAbiFilters() {
        return this.myAbiFilters;
    }

    public Collection<NativeLibrary> getNativeLibraries() {
        return this.myNativeLibraries;
    }

    public boolean isSigned() {
        return this.mySigned;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeAndroidArtifactImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdeAndroidArtifactImpl artifact = (IdeAndroidArtifactImpl)o;
        return artifact.canEquals(this) && this.mySigned == artifact.mySigned && Objects.equals(this.myOutputs, artifact.myOutputs) && Objects.equals(this.myApplicationId, artifact.myApplicationId) && Objects.equals(this.mySourceGenTaskName, artifact.mySourceGenTaskName) && Objects.equals(this.myGeneratedResourceFolders, artifact.myGeneratedResourceFolders) && Objects.equals(this.myInstantRun, artifact.myInstantRun) && Objects.equals(this.mySigningConfigName, artifact.mySigningConfigName) && Objects.equals(this.myAbiFilters, artifact.myAbiFilters) && Objects.equals(this.myAdditionalRuntimeApks, artifact.myAdditionalRuntimeApks) && Objects.equals(this.myNativeLibraries, artifact.myNativeLibraries) && Objects.equals(this.myTestOptions, artifact.myTestOptions) && Objects.equals(this.myInstrumentedTestTaskName, artifact.myInstrumentedTestTaskName) && Objects.equals(this.myBundleTaskName, artifact.myBundleTaskName) && Objects.equals(this.myPostBundleTaskModelFile, artifact.myPostBundleTaskModelFile) && Objects.equals(this.myCodeShrinker, artifact.myCodeShrinker) && Objects.equals(this.myApkFromBundleTaskName, artifact.myApkFromBundleTaskName) && Objects.equals(this.myPostApkFromBundleTaskModelFile, artifact.myPostApkFromBundleTaskModelFile);
    }

    @Override
    protected boolean canEquals(Object other) {
        return other instanceof IdeAndroidArtifactImpl;
    }

    @Override
    public int hashCode() {
        return this.myHashCode;
    }

    @Override
    protected int calculateHashCode() {
        return Objects.hash(super.calculateHashCode(), this.myOutputs, this.myApplicationId, this.mySourceGenTaskName, this.myGeneratedResourceFolders, this.myInstantRun, this.mySigningConfigName, this.myAbiFilters, this.myNativeLibraries, this.mySigned, this.myAdditionalRuntimeApks, this.myTestOptions, this.myInstrumentedTestTaskName, this.myBundleTaskName, this.myPostBundleTaskModelFile, this.myCodeShrinker, this.myApkFromBundleTaskName, this.myPostApkFromBundleTaskModelFile);
    }

    @Override
    public String toString() {
        return "IdeAndroidArtifact{" + super.toString() + ", myOutputs=" + this.myOutputs + ", myApplicationId='" + this.myApplicationId + '\'' + ", mySourceGenTaskName='" + this.mySourceGenTaskName + '\'' + ", myGeneratedResourceFolders=" + this.myGeneratedResourceFolders + ", myInstantRun=" + this.myInstantRun + ", mySigningConfigName='" + this.mySigningConfigName + '\'' + ", myAbiFilters=" + this.myAbiFilters + ", myNativeLibraries=" + this.myNativeLibraries + ", mySigned=" + this.mySigned + ", myTestOptions=" + this.myTestOptions + ", myInstrumentedTestTaskName=" + this.myInstrumentedTestTaskName + ", myBundleTaskName=" + this.myBundleTaskName + ", myPostBundleTaskModelFile=" + this.myPostBundleTaskModelFile + ", myCodeShrinker=" + this.myCodeShrinker + ", myApkFromBundleTaskName=" + this.myApkFromBundleTaskName + ", myPostApkFromBundleTaskModelFile=" + this.myPostApkFromBundleTaskModelFile + "}";
    }
}

