/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ResourceVisibilityLookup {
    public static final ResourceVisibilityLookup NONE = new ResourceVisibilityLookup(){

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            return false;
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            return false;
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            return false;
        }

        @Override
        public String getPrivateIn(ResourceType type, String name) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    public abstract boolean isPrivate(ResourceType var1, String var2);

    public abstract boolean isPublic(ResourceType var1, String var2);

    protected abstract boolean isKnown(ResourceType var1, String var2);

    public boolean isPrivate(ResourceUrl url) {
        assert (!url.isFramework());
        return this.isPrivate(url.type, url.name);
    }

    public abstract String getPrivateIn(ResourceType var1, String var2);

    public abstract boolean isEmpty();

    public static ResourceVisibilityLookup create(File publicResources, File allResources, String mapKey) {
        return new LibraryResourceVisibility(publicResources, allResources, mapKey);
    }

    public static ResourceVisibilityLookup create(List<ResourceVisibilityLookup> libraries) {
        if (libraries.size() == 1) {
            return libraries.get(0);
        }
        return new MultipleLibraryResourceVisibility(libraries);
    }

    public static ResourceVisibilityLookup create(AndroidLibrary library) {
        return new AndroidLibraryResourceVisibility(library, new SymbolProvider());
    }

    public static ResourceVisibilityLookup create(List<AndroidLibrary> libraries, Provider provider) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)libraries.size());
        for (AndroidLibrary library : libraries) {
            ResourceVisibilityLookup v = provider != null ? provider.get(library) : new AndroidLibraryResourceVisibility(library, new SymbolProvider());
            if (v.isEmpty()) continue;
            list.add(v);
        }
        return new MultipleLibraryResourceVisibility(list);
    }

    private static String getMapKey(AndroidLibrary library) {
        MavenCoordinates c = library.getResolvedCoordinates();
        if (c != null) {
            return c.getGroupId() + ':' + c.getArtifactId() + ':' + c.getVersion();
        }
        return library.getBundle().getPath();
    }

    private static String getMapKey(AndroidArtifact artifact) {
        return artifact.getApplicationId();
    }

    private static String getMapKey(Variant variant) {
        return ResourceVisibilityLookup.getMapKey(variant.getMainArtifact()) + '-' + variant.getName();
    }

    private static List<AndroidLibrary> getTransitiveDependencies(AndroidLibrary library) {
        ArrayList result2 = Lists.newArrayList();
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            ResourceVisibilityLookup.addLibraries(result2, new HashSet<String>(), dependency);
        }
        return result2;
    }

    private static void addLibraries(List<AndroidLibrary> result2, Set<String> seen, AndroidLibrary library) {
        String key = ResourceVisibilityLookup.getMapKey(library);
        if (seen.contains(key)) {
            return;
        }
        seen.add(key);
        result2.add(library);
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            ResourceVisibilityLookup.addLibraries(result2, seen, dependency);
        }
    }

    private static Multimap<String, ResourceType> readSymbolFile(File symbolFile) throws IOException {
        List lines = Files.readLines((File)symbolFile, (Charset)Charsets.UTF_8);
        ArrayListMultimap result2 = ArrayListMultimap.create((int)lines.size(), (int)2);
        ResourceType previousType = null;
        String previousTypeString = "";
        int count = lines.size();
        for (int lineIndex = 1; lineIndex <= count; ++lineIndex) {
            ResourceType type;
            String line = (String)lines.get(lineIndex - 1);
            if (!line.startsWith("int ")) continue;
            int typeStart = 4;
            int typeEnd = line.indexOf(32, typeStart);
            String typeString = line.substring(typeStart, typeEnd);
            if (typeString.equals(previousTypeString)) {
                type = previousType;
            } else {
                type = ResourceType.fromClassName((String)typeString);
                previousTypeString = typeString;
                previousType = type;
            }
            if (type == null) continue;
            int nameStart = typeEnd + 1;
            int nameEnd = line.indexOf(32, nameStart);
            String name = line.substring(nameStart, nameEnd);
            result2.put((Object)name, (Object)type);
        }
        return result2;
    }

    @VisibleForTesting
    static class SymbolProvider {
        private final Map<String, Multimap<String, ResourceType>> mCache = Maps.newHashMap();

        SymbolProvider() {
        }

        @VisibleForTesting
        Multimap<String, ResourceType> getSymbols(AndroidLibrary library) {
            File symbolFile;
            String mapKey = ResourceVisibilityLookup.getMapKey(library);
            Multimap<String, ResourceType> map = this.mCache.get(mapKey);
            if (map != null) {
                return map;
            }
            try {
                symbolFile = library.getSymbolFile();
            }
            catch (Exception e) {
                File dir = library.getPublicResources().getParentFile();
                symbolFile = new File(dir, "R.txt");
            }
            if (symbolFile == null || !symbolFile.exists()) {
                ImmutableListMultimap empty = ImmutableListMultimap.of();
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)empty);
                return empty;
            }
            try {
                Multimap result2 = ResourceVisibilityLookup.readSymbolFile(symbolFile);
                if (!result2.isEmpty()) {
                    for (AndroidLibrary dependency : ResourceVisibilityLookup.getTransitiveDependencies(library)) {
                        Multimap<String, ResourceType> imported = this.getSymbols(dependency);
                        if (imported.isEmpty()) continue;
                        for (Map.Entry entry : imported.entries()) {
                            result2.remove(entry.getKey(), entry.getValue());
                        }
                    }
                }
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)result2);
                return result2;
            }
            catch (IOException ignore) {
                ImmutableListMultimap empty = ImmutableListMultimap.of();
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)empty);
                return empty;
            }
        }
    }

    private static class AndroidLibraryResourceVisibility
    extends LibraryResourceVisibility {
        private final AndroidLibrary mLibrary;

        private AndroidLibraryResourceVisibility(AndroidLibrary library, Multimap<String, ResourceType> publicResources, SymbolProvider symbols2) {
            super(publicResources, publicResources != null ? symbols2.getSymbols(library) : null, ResourceVisibilityLookup.getMapKey(library));
            this.mLibrary = library;
        }

        private AndroidLibraryResourceVisibility(AndroidLibrary library, SymbolProvider symbols2) {
            this(library, AndroidLibraryResourceVisibility.computeVisibilityMap(library.getPublicResources()), symbols2);
        }

        @Override
        public String toString() {
            return ResourceVisibilityLookup.getMapKey(this.mLibrary);
        }

        @Override
        protected String getLibraryName() {
            String libraryName = this.mLibrary.getProject();
            if (libraryName != null) {
                return libraryName;
            }
            MavenCoordinates coordinates = this.mLibrary.getResolvedCoordinates();
            if (coordinates != null) {
                return coordinates.getGroupId() + ':' + coordinates.getArtifactId();
            }
            return super.getLibraryName();
        }
    }

    private static class LibraryResourceVisibility
    extends ResourceVisibilityLookup {
        private final String mMapKey;
        private final Multimap<String, ResourceType> mAll;
        private final Multimap<String, ResourceType> mPublic;

        protected LibraryResourceVisibility(Multimap<String, ResourceType> publicResources, Multimap<String, ResourceType> allResources, String mapKey) {
            this.mPublic = publicResources;
            this.mAll = allResources;
            this.mMapKey = mapKey;
        }

        protected LibraryResourceVisibility(File publicResources, File allResources, String mapKey) {
            this.mPublic = LibraryResourceVisibility.computeVisibilityMap(publicResources);
            Multimap all = null;
            if (this.mPublic != null) {
                try {
                    all = ResourceVisibilityLookup.readSymbolFile(allResources);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.mAll = all;
            this.mMapKey = mapKey;
        }

        public String toString() {
            return this.mMapKey;
        }

        @Override
        public boolean isEmpty() {
            return this.mPublic == null;
        }

        @Override
        public String getPrivateIn(ResourceType type, String name) {
            if (this.isPrivate(type, name)) {
                return this.getLibraryName();
            }
            return null;
        }

        protected String getLibraryName() {
            return this.mMapKey;
        }

        static Multimap<String, ResourceType> computeVisibilityMap(File publicResources) {
            if (!publicResources.exists()) {
                return null;
            }
            try {
                List lines = Files.readLines((File)publicResources, (Charset)Charsets.UTF_8);
                ArrayListMultimap result2 = ArrayListMultimap.create((int)lines.size(), (int)2);
                for (String line : lines) {
                    String typeString;
                    ResourceType type;
                    int index = line.indexOf(32);
                    if (index == -1 || line.isEmpty() || (type = ResourceType.fromClassName((String)(typeString = line.substring(0, index)))) == null) continue;
                    String name = line.substring(index + 1);
                    name = name.replace('.', '_');
                    result2.put((Object)name, (Object)type);
                }
                return result2;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            if (this.mPublic == null) {
                return false;
            }
            if (this.mAll != null && !this.mAll.containsEntry((Object)name, (Object)type)) {
                return false;
            }
            return !this.mPublic.containsEntry((Object)name, (Object)type);
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            return this.mAll != null && this.mAll.containsEntry((Object)name, (Object)type);
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            if (this.mAll == null) {
                return true;
            }
            return this.isKnown(type, name) && (this.mPublic == null || this.mPublic.containsEntry((Object)name, (Object)type));
        }
    }

    public static class Provider {
        private final Map<Object, ResourceVisibilityLookup> mInstances = Maps.newHashMap();
        private final SymbolProvider mSymbols = new SymbolProvider();

        public ResourceVisibilityLookup get(AndroidLibrary library) {
            String key = ResourceVisibilityLookup.getMapKey(library);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                List dependsOn;
                visibility = new AndroidLibraryResourceVisibility(library, this.mSymbols);
                if (visibility.isEmpty()) {
                    visibility = NONE;
                }
                if (!(dependsOn = library.getLibraryDependencies()).isEmpty()) {
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)(dependsOn.size() + 1));
                    list.add(visibility);
                    for (AndroidLibrary d : dependsOn) {
                        ResourceVisibilityLookup v = this.get(d);
                        if (v.isEmpty()) continue;
                        list.add(v);
                    }
                    if (list.size() > 1) {
                        visibility = new MultipleLibraryResourceVisibility(list);
                    }
                }
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }

        public ResourceVisibilityLookup get(AndroidArtifact artifact) {
            String key = ResourceVisibilityLookup.getMapKey(artifact);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                Collection dependsOn = artifact.getDependencies().getLibraries();
                ArrayList list = Lists.newArrayListWithExpectedSize((int)(dependsOn.size() + 1));
                for (AndroidLibrary d : dependsOn) {
                    ResourceVisibilityLookup v = this.get(d);
                    if (v.isEmpty()) continue;
                    list.add(v);
                }
                int size = list.size();
                visibility = size == 0 ? NONE : (size == 1 ? (ResourceVisibilityLookup)list.get(0) : new MultipleLibraryResourceVisibility(list));
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }

        public static boolean isVisibilityAwareModel(IdeAndroidProject project) {
            String modelVersion = project.getModelVersion();
            return !modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && project.getApiVersion() >= 3;
        }

        public ResourceVisibilityLookup get(IdeAndroidProject project, Variant variant) {
            String key = ResourceVisibilityLookup.getMapKey(variant);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                if (Provider.isVisibilityAwareModel(project)) {
                    AndroidArtifact artifact = variant.getMainArtifact();
                    visibility = this.get(artifact);
                } else {
                    visibility = NONE;
                }
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }
    }

    private static class MultipleLibraryResourceVisibility
    extends ResourceVisibilityLookup {
        private final List<ResourceVisibilityLookup> mRepositories;

        public MultipleLibraryResourceVisibility(List<ResourceVisibilityLookup> repositories) {
            this.mRepositories = repositories;
        }

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isPublic(type, name)) continue;
                return false;
            }
            return this.isKnown(type, name);
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isKnown(type, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isPublic(type, name) || !lookup.isKnown(type, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                if (this.mRepositories.get(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getPrivateIn(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup r = this.mRepositories.get(i);
                if (!r.isPrivate(type, name)) continue;
                return r.getPrivateIn(type, name);
            }
            return null;
        }

        public String toString() {
            return this.mRepositories.toString();
        }
    }
}

