/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgGradientNode;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdPath;
import com.android.utils.XmlUtils;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

class SvgLeafNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgLeafNode.class.getSimpleName());
    private String mPathData;
    private SvgGradientNode mFillGradientNode;
    private SvgGradientNode mStrokeGradientNode;

    SvgLeafNode(SvgTree svgTree, Element element, String nodeName) {
        super(svgTree, element, nodeName);
    }

    @Override
    public SvgLeafNode deepCopy() {
        SvgLeafNode newNode = new SvgLeafNode(this.getTree(), this.mDocumentElement, this.getName());
        newNode.copyFrom(this);
        return newNode;
    }

    protected void copyFrom(SvgLeafNode from) {
        super.copyFrom(from);
        this.mPathData = from.mPathData;
    }

    private void writeAttributeValues(OutputStreamWriter writer, String indent) throws IOException {
        this.parsePathOpacity();
        for (Map.Entry entry : this.mVdAttributesMap.entrySet()) {
            String key = (String)entry.getKey();
            String attribute = (String)Svg2Vector.presentationMap.get((Object)key);
            if (attribute.isEmpty()) continue;
            String svgValue = ((String)entry.getValue()).trim();
            String vdValue = this.colorSvg2Vd(svgValue, "#000000");
            if (vdValue == null) {
                if (svgValue.endsWith("px")) {
                    vdValue = svgValue.substring(0, svgValue.length() - 2).trim();
                } else {
                    if (svgValue.startsWith("url(#") && svgValue.endsWith(")")) {
                        SvgNode node;
                        vdValue = svgValue.substring(5, svgValue.length() - 1);
                        if (key.equals("fill")) {
                            node = this.getTree().getSvgNodeFromId(vdValue);
                            if (node == null) continue;
                            this.mFillGradientNode = (SvgGradientNode)node.deepCopy();
                            this.mFillGradientNode.setSvgLeafNode(this);
                            this.mFillGradientNode.setGradientUsage(SvgGradientNode.GradientUsage.FILL);
                            continue;
                        }
                        if (!key.equals("stroke") || (node = this.getTree().getSvgNodeFromId(vdValue)) == null) continue;
                        this.mStrokeGradientNode = (SvgGradientNode)node.deepCopy();
                        this.mStrokeGradientNode.setSvgLeafNode(this);
                        this.mStrokeGradientNode.setGradientUsage(SvgGradientNode.GradientUsage.STROKE);
                        continue;
                    }
                    vdValue = svgValue;
                }
            }
            writer.write(System.lineSeparator());
            writer.write(indent);
            writer.write("    ");
            writer.write(attribute);
            writer.write("=\"");
            writer.write(vdValue);
            writer.write("\"");
        }
    }

    private void parsePathOpacity() {
        double opacity = this.getOpacityValueFromMap("opacity");
        double fillOpacity = this.getOpacityValueFromMap("fill-opacity");
        double strokeOpacity = this.getOpacityValueFromMap("stroke-opacity");
        this.putOpacityValueToMap("fill-opacity", fillOpacity * opacity);
        this.putOpacityValueToMap("stroke-opacity", strokeOpacity * opacity);
        this.mVdAttributesMap.remove("opacity");
    }

    private double getOpacityValueFromMap(String attributeName) {
        double result2 = 1.0;
        String opacity = (String)this.mVdAttributesMap.get(attributeName);
        if (opacity != null) {
            try {
                result2 = opacity.endsWith("%") ? Double.parseDouble(opacity.substring(0, opacity.length() - 1)) / 100.0 : Double.parseDouble(opacity);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Math.min(Math.max(result2, 0.0), 1.0);
    }

    private void putOpacityValueToMap(String attributeName, double opacity) {
        String attributeValue = XmlUtils.formatFloatValue((double)opacity);
        if (attributeValue.equals("1")) {
            this.mVdAttributesMap.remove(attributeName);
        } else {
            this.mVdAttributesMap.put(attributeName, attributeValue);
        }
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + (this.mPathData != null ? this.mPathData : " null pathData ") + (this.mName != null ? this.mName : " null name "));
    }

    public void setPathData(String pathData) {
        this.mPathData = pathData;
    }

    public String getPathData() {
        return this.mPathData;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    public boolean hasGradient() {
        return this.mFillGradientNode != null || this.mStrokeGradientNode != null;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        if (this.mPathData == null || this.mPathData.isEmpty()) {
            return;
        }
        VdPath.Node[] nodes = PathParser.parsePath(this.mPathData, PathParser.ParseMode.SVG);
        AffineTransform finalTransform = new AffineTransform(rootTransform);
        finalTransform.concatenate(this.mStackedTransform);
        boolean needsConvertRelativeMoveAfterClose = VdPath.Node.hasRelMoveAfterClose(nodes);
        if (!finalTransform.isIdentity() || needsConvertRelativeMoveAfterClose) {
            VdPath.Node.transform(finalTransform, nodes);
        }
        this.mPathData = VdPath.Node.nodeListToString(nodes, this.mSvgTree.getCoordinateFormat());
    }

    @Override
    public void flatten(AffineTransform transform) {
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
        if (this.mVdAttributesMap.containsKey("stroke-width") && (this.mStackedTransform.getType() & 6) != 0) {
            this.logWarning("Scaling of the stroke width is ignored");
        }
    }

    @Override
    public void writeXml(OutputStreamWriter writer, String indent) throws IOException {
        boolean emptyStroke;
        if (this.mPathData == null || this.mPathData.isEmpty()) {
            return;
        }
        String fillColor = (String)this.mVdAttributesMap.get("fill");
        String strokeColor = (String)this.mVdAttributesMap.get("stroke");
        logger.log(Level.FINE, "fill color " + fillColor);
        boolean emptyFill = "none".equals(fillColor) || "#00000000".equals(fillColor);
        boolean bl = emptyStroke = strokeColor == null || "none".equals(strokeColor);
        if (emptyFill && emptyStroke) {
            return;
        }
        writer.write(indent);
        writer.write("<path");
        writer.write(System.lineSeparator());
        if (fillColor == null && this.mFillGradientNode == null) {
            logger.log(Level.FINE, "Adding default fill color");
            writer.write(indent);
            writer.write("    ");
            writer.write("android:fillColor=\"#FF000000\"");
            writer.write(System.lineSeparator());
        }
        if (!emptyStroke && !this.mVdAttributesMap.containsKey("stroke-width") && this.mStrokeGradientNode == null) {
            logger.log(Level.FINE, "Adding default stroke width");
            writer.write(indent);
            writer.write("    ");
            writer.write("android:strokeWidth=\"1\"");
            writer.write(System.lineSeparator());
        }
        writer.write(indent);
        writer.write("    ");
        writer.write("android:pathData=\"" + this.mPathData + "\"");
        this.writeAttributeValues(writer, indent);
        if (!this.hasGradient()) {
            writer.write(47);
        }
        writer.write(62);
        writer.write(System.lineSeparator());
        if (this.mFillGradientNode != null) {
            this.mFillGradientNode.writeXml(writer, indent + "  ");
        }
        if (this.mStrokeGradientNode != null) {
            this.mStrokeGradientNode.writeXml(writer, indent + "  ");
        }
        if (this.hasGradient()) {
            writer.write(indent);
            writer.write("</path>");
            writer.write(System.lineSeparator());
        }
    }
}

