/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000bR\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/ide/common/resources/PatternBasedFileFilter;", "", "()V", "ignoredPatterns", "", "(Ljava/lang/String;)V", "aaptStyleIgnoredPattern", "getAaptStyleIgnoredPattern", "()Ljava/lang/String;", "", "equals", "", "other", "hashCode", "", "isIgnored", "file", "Ljava/io/File;", "filePath", "isDirectory", "sdk-common"})
public final class PatternBasedFileFilter {
    private final List<String> ignoredPatterns;

    @NotNull
    public final String getAaptStyleIgnoredPattern() {
        String string = Joiner.on((char)':').join((Iterable)this.ignoredPatterns);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Joiner.on(':').join(ignoredPatterns)");
        return string;
    }

    public final boolean isIgnored(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String filePath = file.getPath();
        if (Intrinsics.areEqual((Object)filePath, (Object)".") || Intrinsics.areEqual((Object)filePath, (Object)"..")) {
            return true;
        }
        boolean isDirectory = file.isDirectory();
        String string = filePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filePath");
        return this.isIgnored(string, isDirectory);
    }

    public final boolean isIgnored(@NotNull String filePath, boolean isDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        if (Intrinsics.areEqual((Object)filePath, (Object)".") || Intrinsics.areEqual((Object)filePath, (Object)"..")) {
            return true;
        }
        boolean ignore = false;
        int nameIndex = StringsKt.lastIndexOf$default((CharSequence)filePath, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null) + 1;
        int nameLength = filePath.length() - nameIndex;
        for (String token : this.ignoredPatterns) {
            CharSequence charSequence = token;
            boolean bl = false;
            if (charSequence.length() == 0) continue;
            int tokenIndex = 0;
            if (token.charAt(tokenIndex) == '!') {
                ++tokenIndex;
            }
            if (StringsKt.regionMatches$default((String)token, (int)tokenIndex, (String)"<dir>", (int)0, (int)5, (boolean)false, (int)16, null)) {
                if (!isDirectory) continue;
                tokenIndex += 5;
            }
            if (StringsKt.regionMatches$default((String)token, (int)tokenIndex, (String)"<file>", (int)0, (int)6, (boolean)false, (int)16, null)) {
                if (isDirectory) continue;
                tokenIndex += 6;
            }
            int n = token.length() - tokenIndex;
            if (token.charAt(tokenIndex) == '*') {
                ++tokenIndex;
                if (--n <= nameLength) {
                    ignore = StringsKt.regionMatches((String)token, (int)tokenIndex, (String)filePath, (int)(nameIndex + nameLength - n), (int)n, (boolean)true);
                }
            } else if (n > 1 && token.charAt(token.length() - 1) == '*') {
                ignore = StringsKt.regionMatches((String)token, (int)tokenIndex, (String)filePath, (int)nameIndex, (int)(n - 1), (boolean)true);
            } else {
                boolean bl2 = ignore = token.length() - tokenIndex == filePath.length() - nameIndex && StringsKt.regionMatches((String)token, (int)tokenIndex, (String)filePath, (int)nameIndex, (int)(filePath.length() - nameIndex), (boolean)true);
            }
            if (!ignore) continue;
            break;
        }
        return ignore;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        PatternBasedFileFilter otherFilter = (PatternBasedFileFilter)other;
        return Intrinsics.areEqual(this.ignoredPatterns, otherFilter.ignoredPatterns);
    }

    public int hashCode() {
        return ((Object)this.ignoredPatterns).hashCode();
    }

    public PatternBasedFileFilter() {
        String patterns;
        block3: {
            block2: {
                patterns = System.getenv("ANDROID_AAPT_IGNORE");
                if (patterns == null) break block2;
                CharSequence charSequence = patterns;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            patterns = "!.svn:!.git:!.ds_store:!*.scc:.*:<dir>_*:!CVS:!thumbs.db:!picasa.ini:!*~";
        }
        List list = Splitter.on((char)':').splitToList((CharSequence)patterns);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"Splitter.on(':').splitToList(patterns)");
        this.ignoredPatterns = list;
    }

    public PatternBasedFileFilter(@NotNull String ignoredPatterns) {
        Intrinsics.checkParameterIsNotNull((Object)ignoredPatterns, (String)"ignoredPatterns");
        List list = Splitter.on((char)':').splitToList((CharSequence)ignoredPatterns);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"Splitter.on(':').splitToList(ignoredPatterns)");
        this.ignoredPatterns = list;
    }
}

