/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.ide.common.gradle.model.ModelCache;
import java.io.Serializable;
import java.util.Objects;

public final class IdeSourceProviderContainer
implements SourceProviderContainer,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myArtifactName;
    private final IdeSourceProvider mySourceProvider;
    private final int myHashCode;

    IdeSourceProviderContainer() {
        this.myArtifactName = "";
        this.mySourceProvider = new IdeSourceProvider();
        this.myHashCode = 0;
    }

    public IdeSourceProviderContainer(SourceProviderContainer container, ModelCache modelCache) {
        this.myArtifactName = container.getArtifactName();
        this.mySourceProvider = modelCache.computeIfAbsent(container.getSourceProvider(), provider -> new IdeSourceProvider((SourceProvider)provider));
        this.myHashCode = this.calculateHashCode();
    }

    public String getArtifactName() {
        return this.myArtifactName;
    }

    public IdeSourceProvider getSourceProvider() {
        return this.mySourceProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeSourceProviderContainer)) {
            return false;
        }
        IdeSourceProviderContainer container = (IdeSourceProviderContainer)o;
        return Objects.equals(this.myArtifactName, container.myArtifactName) && Objects.equals(this.mySourceProvider, container.mySourceProvider);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myArtifactName, this.mySourceProvider);
    }

    public String toString() {
        return "IdeSourceProviderContainer{myArtifactName='" + this.myArtifactName + '\'' + ", mySourceProvider=" + this.mySourceProvider + '}';
    }
}

