/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.JavaCompileOptions;
import java.io.Serializable;
import java.util.Objects;

public final class IdeJavaCompileOptions
implements JavaCompileOptions,
Serializable {
    private static final long serialVersionUID = 2L;
    private final String myEncoding;
    private final String mySourceCompatibility;
    private final String myTargetCompatibility;
    private final int myHashCode;

    IdeJavaCompileOptions() {
        this.myEncoding = "";
        this.mySourceCompatibility = "";
        this.myTargetCompatibility = "";
        this.myHashCode = 0;
    }

    public IdeJavaCompileOptions(JavaCompileOptions options) {
        this.myEncoding = options.getEncoding();
        this.mySourceCompatibility = options.getSourceCompatibility();
        this.myTargetCompatibility = options.getTargetCompatibility();
        this.myHashCode = this.calculateHashCode();
    }

    public String getEncoding() {
        return this.myEncoding;
    }

    public String getSourceCompatibility() {
        return this.mySourceCompatibility;
    }

    public String getTargetCompatibility() {
        return this.myTargetCompatibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeJavaCompileOptions)) {
            return false;
        }
        IdeJavaCompileOptions options = (IdeJavaCompileOptions)o;
        return Objects.equals(this.myEncoding, options.myEncoding) && Objects.equals(this.mySourceCompatibility, options.mySourceCompatibility) && Objects.equals(this.myTargetCompatibility, options.myTargetCompatibility);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myEncoding, this.mySourceCompatibility, this.myTargetCompatibility);
    }

    public String toString() {
        return "IdeJavaCompileOptions{myEncoding='" + this.myEncoding + '\'' + ", mySourceCompatibility='" + this.mySourceCompatibility + '\'' + ", myTargetCompatibility='" + this.myTargetCompatibility + '\'' + "}";
    }
}

