/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.gradle.model.IdeModel;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class IdeAaptOptions
implements AaptOptions,
Serializable {
    private final String ignoreAssets;
    private final Collection<String> noCompress;
    private final boolean failOnMissingConfigEntry;
    private final List<String> additionalParameters;
    private final AaptOptions.Namespacing namespacing;

    IdeAaptOptions() {
        this.ignoreAssets = null;
        this.noCompress = null;
        this.failOnMissingConfigEntry = false;
        this.additionalParameters = Collections.emptyList();
        this.namespacing = AaptOptions.Namespacing.DISABLED;
    }

    @VisibleForTesting
    public IdeAaptOptions(AaptOptions original) {
        this.ignoreAssets = IdeModel.copyNewProperty(() -> ((AaptOptions)original).getIgnoreAssets(), null);
        this.noCompress = IdeModel.copyNewProperty(() -> ((AaptOptions)original).getNoCompress(), null);
        this.namespacing = IdeModel.copyNewProperty(() -> ((AaptOptions)original).getNamespacing(), AaptOptions.Namespacing.DISABLED);
        this.additionalParameters = IdeModel.copyNewProperty(() -> ((AaptOptions)original).getAdditionalParameters(), Collections.emptyList());
        this.failOnMissingConfigEntry = IdeModel.copyNewProperty(() -> ((AaptOptions)original).getFailOnMissingConfigEntry(), false);
    }

    public String getIgnoreAssets() {
        return this.ignoreAssets;
    }

    public Collection<String> getNoCompress() {
        return this.noCompress;
    }

    public boolean getFailOnMissingConfigEntry() {
        return this.failOnMissingConfigEntry;
    }

    public List<String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public AaptOptions.Namespacing getNamespacing() {
        return this.namespacing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdeAaptOptions that = (IdeAaptOptions)o;
        return this.failOnMissingConfigEntry == that.failOnMissingConfigEntry && Objects.equals(this.ignoreAssets, that.ignoreAssets) && Objects.equals(this.noCompress, that.noCompress) && Objects.equals(this.additionalParameters, that.additionalParameters) && this.namespacing == that.namespacing;
    }

    public int hashCode() {
        return Objects.hash(this.ignoreAssets, this.noCompress, this.failOnMissingConfigEntry, this.additionalParameters, this.namespacing);
    }
}

