/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Locale;

public class LegacyNdkOutputParser
implements PatternAwareOutputParser {
    private static final String FROM = "from";
    private static final String UNKNOWN_MSG_PREFIX1 = "In file included from";
    private static final String UNKNOWN_MSG_PREFIX2 = "                 from";
    private static final char COLON = ':';

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        if (line.startsWith(UNKNOWN_MSG_PREFIX1) || line.startsWith(UNKNOWN_MSG_PREFIX2)) {
            int fromIndex = line.indexOf(FROM);
            String unknownMsgCause = line.substring(0, fromIndex).trim();
            unknownMsgCause = "(Unknown) " + unknownMsgCause;
            String coordinates = line.substring(fromIndex + FROM.length()).trim();
            if (!coordinates.isEmpty()) {
                List segments;
                int colonIndex1 = coordinates.indexOf(58);
                if (colonIndex1 == 1) {
                    coordinates = coordinates.substring(colonIndex1 + 1);
                }
                if (coordinates.endsWith(",") || coordinates.endsWith(":")) {
                    coordinates = coordinates.substring(0, coordinates.length() - 1);
                }
                if ((segments = Splitter.on((char)':').splitToList((CharSequence)coordinates)).size() == 3) {
                    String pathname = (String)segments.get(0);
                    File file = new File(pathname);
                    int lineNumber = 0;
                    try {
                        lineNumber = Integer.parseInt((String)segments.get(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int column = 0;
                    try {
                        column = Integer.parseInt((String)segments.get(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    SourceFilePosition position = new SourceFilePosition(file, new SourcePosition(lineNumber - 1, column - 1, -1));
                    Message message = new Message(Message.Kind.INFO, unknownMsgCause.trim(), position, new SourceFilePosition[0]);
                    if (!messages.contains(message)) {
                        LegacyNdkOutputParser.addMessage(message, messages);
                    }
                }
            }
            return true;
        }
        int colonIndex1 = line.indexOf(58);
        if (colonIndex1 == 1) {
            colonIndex1 = line.indexOf(58, colonIndex1 + 1);
        }
        if (colonIndex1 >= 0) {
            String part1 = line.substring(0, colonIndex1).trim();
            int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
            if (colonIndex2 >= 0) {
                File file = new File(part1);
                if (!file.isFile()) {
                    return false;
                }
                try {
                    int lineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                    int colonIndex3 = line.indexOf(58, colonIndex2 + 1);
                    if (colonIndex3 >= 0) {
                        int column = Integer.parseInt(line.substring(colonIndex2 + 1, colonIndex3).trim());
                        int colonIndex4 = line.indexOf(58, colonIndex3 + 1);
                        if (colonIndex4 >= 0) {
                            Message.Kind kind = Message.Kind.INFO;
                            String severity = line.substring(colonIndex3 + 1, colonIndex4).toLowerCase(Locale.getDefault()).trim();
                            if (severity.endsWith("error")) {
                                kind = Message.Kind.ERROR;
                            } else if (severity.endsWith("warning")) {
                                kind = Message.Kind.WARNING;
                            }
                            String text = line.substring(colonIndex4 + 1).trim();
                            List<Object> messageList = Lists.newArrayList();
                            messageList.add(text);
                            String prevLine = null;
                            while (true) {
                                String nextLine;
                                if ((nextLine = reader.readLine()) == null) {
                                    return false;
                                }
                                if (nextLine.trim().equals("^")) {
                                    Object messageEnd = reader.readLine();
                                    while (LegacyNdkOutputParser.isMessageEnd((String)messageEnd)) {
                                        messageList.add(((String)messageEnd).trim());
                                        messageEnd = reader.readLine();
                                    }
                                    if (messageEnd == null) break;
                                    reader.pushBack();
                                    break;
                                }
                                if (prevLine != null) {
                                    messageList.add(prevLine);
                                }
                                prevLine = nextLine;
                            }
                            if (column >= 0) {
                                messageList = LegacyNdkOutputParser.convertMessages((List<String>)messageList);
                                StringBuilder buf = new StringBuilder();
                                for (String string : messageList) {
                                    if (buf.length() > 0) {
                                        buf.append(System.lineSeparator());
                                    }
                                    buf.append(string);
                                }
                                Message msg = new Message(kind, buf.toString(), new SourceFilePosition(file, new SourcePosition(lineNumber - 1, column - 1, -1)), new SourceFilePosition[0]);
                                if (!messages.contains(msg)) {
                                    LegacyNdkOutputParser.addMessage(msg, messages);
                                }
                                return true;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static void addMessage(Message message, List<Message> messages) {
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Message lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = lastMessage.equals((Object)message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
    }

    private static boolean isMessageEnd(String line) {
        return line != null && !line.isEmpty() && Character.isWhitespace(line.charAt(0));
    }

    private static List<String> convertMessages(List<String> messages) {
        String part1;
        if (messages.size() <= 1) {
            return messages;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        return messages;
    }
}

