/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitSelectTool;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.resources.Density;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SplitOutputMatcher {
    public static List<File> computeBestOutput(ProcessExecutor processExecutor, File splitSelectExe, DeviceConfigProvider deviceConfigProvider, Collection<OutputFile> outputs, Collection<String> variantAbiFilters) throws ProcessException {
        List<String> splitApksPath = outputs.stream().filter(outputFile -> outputFile.getOutputType().equals(OutputFile.SPLIT)).map(outputFile -> outputFile.getOutputFile().getAbsolutePath()).collect(Collectors.toList());
        if (splitApksPath.isEmpty()) {
            ArrayList<File> apkFiles = new ArrayList<File>();
            List<OutputFile> outputFiles = SplitOutputMatcher.computeBestOutput(outputs, variantAbiFilters, deviceConfigProvider.getDensity(), deviceConfigProvider.getAbis());
            for (OutputFile outputFile2 : outputFiles) {
                apkFiles.add(outputFile2.getOutputFile());
            }
            return apkFiles;
        }
        Optional<OutputFile> mainApk = outputs.stream().filter(outputFile -> !outputFile.getOutputType().equals(OutputFile.SPLIT)).findFirst();
        if (!mainApk.isPresent()) {
            throw new RuntimeException("Cannot retrieve the main APK from variant outputs");
        }
        if (splitSelectExe == null) {
            throw new RuntimeException("Pure splits installation requires build tools 22 or above");
        }
        return SplitOutputMatcher.computeBestOutput(processExecutor, splitSelectExe, deviceConfigProvider, mainApk.get().getOutputFile(), splitApksPath);
    }

    public static List<File> computeBestOutput(ProcessExecutor processExecutor, File splitSelectExe, DeviceConfigProvider deviceConfigProvider, File mainApk, Collection<String> splitApksPath) throws ProcessException {
        if (splitApksPath.isEmpty()) {
            return ImmutableList.of((Object)mainApk);
        }
        ArrayList<File> apkFiles = new ArrayList<File>();
        HashSet<String> resultApksPath = new HashSet<String>();
        for (String abi : deviceConfigProvider.getAbis()) {
            String deviceConfiguration = SplitOutputMatcher.prepareConfigFormatMccMnc(deviceConfigProvider.getConfigFor(abi));
            resultApksPath.addAll(SplitSelectTool.splitSelect(processExecutor, splitSelectExe, deviceConfiguration, mainApk.getAbsolutePath(), splitApksPath));
        }
        for (String resultApkPath : resultApksPath) {
            apkFiles.add(new File(resultApkPath));
        }
        apkFiles.add(mainApk);
        return apkFiles;
    }

    public static <T extends VariantOutput> List<T> computeBestOutput(Collection<? extends T> outputs, Collection<String> variantAbiFilters, int deviceDensity, List<String> deviceAbis) {
        Density densityEnum = Density.getEnum((int)deviceDensity);
        String densityValue = densityEnum == null ? null : densityEnum.getResourceValue();
        ArrayList matches = Lists.newArrayList();
        for (VariantOutput variantOutput : outputs) {
            String densityFilter = SplitOutputMatcher.getFilter(variantOutput, OutputFile.DENSITY);
            String abiFilter = SplitOutputMatcher.getFilter(variantOutput, OutputFile.ABI);
            if (densityFilter != null && !densityFilter.equals(densityValue) || abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
            matches.add(variantOutput);
        }
        if (matches.isEmpty()) {
            return ImmutableList.of();
        }
        VariantOutput match = (VariantOutput)Collections.max(matches, (splitOutput, splitOutput2) -> {
            int rc = splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            if (rc != 0) {
                return rc;
            }
            int abiOrder1 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput, deviceAbis);
            int abiOrder2 = SplitOutputMatcher.getAbiPreferenceOrder(splitOutput2, deviceAbis);
            return abiOrder1 - abiOrder2;
        });
        return SplitOutputMatcher.isMainApkCompatibleWithDevice(match, variantAbiFilters, deviceAbis) ? ImmutableList.of((Object)match) : ImmutableList.of();
    }

    private static int getAbiPreferenceOrder(VariantOutput variantOutput, List<String> deviceAbi) {
        String abiFilter = SplitOutputMatcher.getFilter(variantOutput, OutputFile.ABI);
        if (Strings.isNullOrEmpty((String)abiFilter)) {
            return deviceAbi.size() - 1;
        }
        int match = deviceAbi.indexOf(abiFilter);
        if (match == 0) {
            match = deviceAbi.size();
        } else if (match > 0) {
            match = deviceAbi.size() - match - 1;
        }
        return match;
    }

    private static boolean isMainApkCompatibleWithDevice(VariantOutput mainOutputFile, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (SplitOutputMatcher.getFilter(mainOutputFile, OutputFile.ABI) == null && variantAbiFilters != null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String getFilter(VariantOutput variantOutput, String filterType) {
        Collection filters;
        try {
            filters = variantOutput.getFilters();
        }
        catch (UnsupportedOperationException ignored) {
            filters = variantOutput.getOutputs().stream().map(VariantOutput::getFilters).flatMap(Collection::stream).collect(Collectors.toList());
        }
        for (FilterData filterData : filters) {
            if (!filterData.getFilterType().equals(filterType)) continue;
            return filterData.getIdentifier();
        }
        return null;
    }

    public static String prepareConfigFormatMccMnc(String deviceConfig) {
        Iterable configParts = Splitter.on((String)"-").split((CharSequence)deviceConfig);
        ArrayList outputParts = Lists.newArrayList();
        int processed = 0;
        for (String part : configParts) {
            boolean matchingFormat;
            boolean bl = matchingFormat = part.length() == 6 && Character.isDigit(part.charAt(0)) && Character.isDigit(part.charAt(1)) && Character.isDigit(part.charAt(2));
            if (processed == 0 && matchingFormat && part.endsWith("mcc")) {
                processed = 1;
                outputParts.add(SplitOutputMatcher.fixSingleConfigDimension(part, "mcc"));
                continue;
            }
            if (processed < 2 && matchingFormat && part.endsWith("mnc")) {
                processed = 2;
                outputParts.add(SplitOutputMatcher.fixSingleConfigDimension(part, "mnc"));
                continue;
            }
            outputParts.add(part);
        }
        return Joiner.on((String)"-").join((Iterable)outputParts);
    }

    private static String fixSingleConfigDimension(String configDimension, String dimensionName) {
        int nameStartIndex = configDimension.lastIndexOf(dimensionName);
        if (nameStartIndex > 0) {
            return dimensionName + configDimension.substring(0, nameStartIndex);
        }
        return configDimension;
    }
}

