/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public interface ResourceRepository {
    public List<ResourceItem> getResources(ResourceNamespace var1, ResourceType var2, String var3);

    default public List<ResourceItem> getResources(ResourceReference reference) {
        return this.getResources(reference.getNamespace(), reference.getResourceType(), reference.getName());
    }

    public List<ResourceItem> getResources(ResourceNamespace var1, ResourceType var2, Predicate<ResourceItem> var3);

    public ListMultimap<String, ResourceItem> getResources(ResourceNamespace var1, ResourceType var2);

    public void accept(ResourceVisitor var1);

    default public List<ResourceItem> getAllResources() {
        ArrayList<ResourceItem> result2 = new ArrayList<ResourceItem>();
        this.accept(item -> {
            result2.add(item);
            return ResourceVisitor.VisitResult.CONTINUE;
        });
        return result2;
    }

    public Collection<ResourceItem> getPublicResources(ResourceNamespace var1, ResourceType var2);

    public boolean hasResources(ResourceNamespace var1, ResourceType var2, String var3);

    public boolean hasResources(ResourceNamespace var1, ResourceType var2);

    public Set<ResourceType> getResourceTypes(ResourceNamespace var1);

    public Set<ResourceNamespace> getNamespaces();

    public void getLeafResourceRepositories(Collection<SingleNamespaceResourceRepository> var1);
}

