/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import java.io.File;
import java.util.Objects;

public final class IdeMavenCoordinates
extends IdeModel
implements MavenCoordinates {
    private static final long serialVersionUID = 2L;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myPacking;
    private final String myClassifier;
    private final int myHashCode;

    public IdeMavenCoordinates(MavenCoordinates coordinates, ModelCache modelCache) {
        super(coordinates, modelCache);
        this.myGroupId = coordinates.getGroupId();
        this.myArtifactId = coordinates.getArtifactId();
        this.myVersion = coordinates.getVersion();
        this.myPacking = coordinates.getPackaging();
        this.myClassifier = coordinates.getClassifier();
        this.myHashCode = this.calculateHashCode();
    }

    public IdeMavenCoordinates(File localJar, ModelCache modelCache) {
        super(localJar, modelCache);
        this.myGroupId = "__local_aars__";
        this.myArtifactId = localJar.getPath();
        this.myVersion = "unspecified";
        this.myPacking = "jar";
        this.myClassifier = null;
        this.myHashCode = this.calculateHashCode();
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getPackaging() {
        return this.myPacking;
    }

    public String getClassifier() {
        return this.myClassifier;
    }

    public String getVersionlessId() {
        throw new UnusedModelMethodException("getVersionlessId");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeMavenCoordinates)) {
            return false;
        }
        IdeMavenCoordinates that = (IdeMavenCoordinates)o;
        return Objects.equals(this.myGroupId, that.myGroupId) && Objects.equals(this.myArtifactId, that.myArtifactId) && Objects.equals(this.myVersion, that.myVersion) && Objects.equals(this.myPacking, that.myPacking) && Objects.equals(this.myClassifier, that.myClassifier);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myGroupId, this.myArtifactId, this.myVersion, this.myPacking, this.myClassifier);
    }

    public String toString() {
        return "IdeMavenCoordinates{myGroupId='" + this.myGroupId + '\'' + ", myArtifactId='" + this.myArtifactId + '\'' + ", myVersion='" + this.myVersion + '\'' + ", myPacking='" + this.myPacking + '\'' + ", myClassifier='" + this.myClassifier + '\'' + '}';
    }
}

