/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.android.ide.common.gradle.model.IdeClassField;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.gradle.model.UnusedModelMethodException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public abstract class IdeBaseConfig
extends IdeModel
implements BaseConfig {
    private static final long serialVersionUID = 1L;
    private final String myName;
    private final Map<String, ClassField> myResValues;
    private final Collection<File> myProguardFiles;
    private final Collection<File> myConsumerProguardFiles;
    private final Map<String, Object> myManifestPlaceholders;
    private final String myApplicationIdSuffix;
    private final String myVersionNameSuffix;
    private final Boolean myMultiDexEnabled;
    private final int myHashCode;

    protected IdeBaseConfig(BaseConfig config, ModelCache modelCache) {
        super(config, modelCache);
        this.myName = config.getName();
        this.myResValues = IdeBaseConfig.copy(config.getResValues(), modelCache, (V classField) -> new IdeClassField((ClassField)classField, modelCache));
        this.myProguardFiles = ImmutableList.copyOf((Collection)config.getProguardFiles());
        this.myConsumerProguardFiles = ImmutableList.copyOf((Collection)config.getConsumerProguardFiles());
        this.myManifestPlaceholders = ImmutableMap.copyOf((Map)config.getManifestPlaceholders());
        this.myApplicationIdSuffix = config.getApplicationIdSuffix();
        this.myVersionNameSuffix = IdeBaseConfig.copyNewProperty(() -> ((BaseConfig)config).getVersionNameSuffix(), null);
        this.myMultiDexEnabled = IdeBaseConfig.copyNewProperty(() -> ((BaseConfig)config).getMultiDexEnabled(), null);
        this.myHashCode = this.calculateHashCode();
    }

    public String getName() {
        return this.myName;
    }

    public Map<String, ClassField> getBuildConfigFields() {
        throw new UnusedModelMethodException("getBuildConfigFields");
    }

    public Map<String, ClassField> getResValues() {
        return this.myResValues;
    }

    public Collection<File> getProguardFiles() {
        return this.myProguardFiles;
    }

    public Collection<File> getConsumerProguardFiles() {
        return this.myConsumerProguardFiles;
    }

    public Collection<File> getTestProguardFiles() {
        throw new UnusedModelMethodException("getTestProguardFiles");
    }

    public Map<String, Object> getManifestPlaceholders() {
        return this.myManifestPlaceholders;
    }

    public String getApplicationIdSuffix() {
        return this.myApplicationIdSuffix;
    }

    public String getVersionNameSuffix() {
        return this.myVersionNameSuffix;
    }

    public Boolean getMultiDexEnabled() {
        return this.myMultiDexEnabled;
    }

    public File getMultiDexKeepFile() {
        throw new UnusedModelMethodException("getMultiDexKeepFile");
    }

    public File getMultiDexKeepProguard() {
        throw new UnusedModelMethodException("getMultiDexKeepProguard");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeBaseConfig)) {
            return false;
        }
        IdeBaseConfig config = (IdeBaseConfig)o;
        return config.canEqual(this) && Objects.equals(this.myName, config.myName) && Objects.deepEquals(this.myResValues, config.myResValues) && Objects.deepEquals(this.myProguardFiles, config.myProguardFiles) && Objects.deepEquals(this.myConsumerProguardFiles, config.myConsumerProguardFiles) && Objects.deepEquals(this.myManifestPlaceholders, config.myManifestPlaceholders) && Objects.equals(this.myApplicationIdSuffix, config.myApplicationIdSuffix) && Objects.equals(this.myVersionNameSuffix, config.myVersionNameSuffix) && Objects.equals(this.myMultiDexEnabled, config.myMultiDexEnabled);
    }

    public boolean canEqual(Object other) {
        return other instanceof IdeBaseConfig;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    protected int calculateHashCode() {
        return Objects.hash(this.myName, this.myResValues, this.myProguardFiles, this.myConsumerProguardFiles, this.myManifestPlaceholders, this.myApplicationIdSuffix, this.myVersionNameSuffix, this.myMultiDexEnabled);
    }

    public String toString() {
        return "myName='" + this.myName + '\'' + ", myResValues=" + this.myResValues + ", myProguardFiles=" + this.myProguardFiles + ", myConsumerProguardFiles=" + this.myConsumerProguardFiles + ", myManifestPlaceholders=" + this.myManifestPlaceholders + ", myApplicationIdSuffix='" + this.myApplicationIdSuffix + '\'' + ", myVersionNameSuffix='" + this.myVersionNameSuffix + '\'' + ", myMultiDexEnabled=" + this.myMultiDexEnabled;
    }
}

