/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.EllipseSolver;
import com.android.ide.common.vectordrawable.GradientStop;
import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.ResourcesNotSupportedException;
import com.android.ide.common.vectordrawable.VdElement;
import com.android.ide.common.vectordrawable.VdNodeRender;
import com.android.ide.common.vectordrawable.VdUtil;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

class VdPath
extends VdElement {
    private static final String PATH_ID = "android:name";
    private static final String PATH_DESCRIPTION = "android:pathData";
    private static final String PATH_FILL = "android:fillColor";
    private static final String PATH_FILL_OPACITY = "android:fillAlpha";
    private static final String PATH_FILL_TYPE = "android:fillType";
    private static final String PATH_STROKE = "android:strokeColor";
    private static final String PATH_STROKE_OPACITY = "android:strokeAlpha";
    private static final String FILL_TYPE_EVEN_ODD = "evenOdd";
    private static final String PATH_STROKE_WIDTH = "android:strokeWidth";
    private static final String PATH_TRIM_START = "android:trimPathStart";
    private static final String PATH_TRIM_END = "android:trimPathEnd";
    private static final String PATH_TRIM_OFFSET = "android:trimPathOffset";
    private static final String PATH_STROKE_LINE_CAP = "android:strokeLineCap";
    private static final String PATH_STROKE_LINE_JOIN = "android:strokeLineJoin";
    private static final String PATH_STROKE_MITER_LIMIT = "android:strokeMiterLimit";
    private static final String LINE_CAP_BUTT = "butt";
    private static final String LINE_CAP_ROUND = "round";
    private static final String LINE_CAP_SQUARE = "square";
    private static final String LINE_JOIN_MITER = "miter";
    private static final String LINE_JOIN_ROUND = "round";
    private static final String LINE_JOIN_BEVEL = "bevel";
    public static final float EPSILON = 1.0E-6f;
    private VdGradient fillGradient;
    private VdGradient strokeGradient;
    private Node[] mNodeList;
    private int mStrokeColor;
    private int mFillColor;
    private float mStrokeWidth;
    private int mStrokeLineCap;
    private int mStrokeLineJoin;
    private float mStrokeMiterlimit = 4.0f;
    private float mStrokeAlpha = 1.0f;
    private float mFillAlpha = 1.0f;
    private int mFillType = 1;
    private float mTrimPathStart;
    private float mTrimPathEnd = 1.0f;
    private float mTrimPathOffset;

    VdPath() {
    }

    private void toPath(Path2D path) {
        path.reset();
        if (this.mNodeList != null) {
            VdNodeRender.createPath(this.mNodeList, path);
        }
    }

    private void setNameValue(String name, String value) {
        if (value.startsWith("@")) {
            throw new ResourcesNotSupportedException(name, value);
        }
        if (PATH_DESCRIPTION.equals(name)) {
            this.mNodeList = PathParser.parsePath(value);
        } else if (PATH_ID.equals(name)) {
            this.mName = value;
        } else if (PATH_FILL.equals(name)) {
            this.mFillColor = VdUtil.parseColorValue(value);
        } else if (PATH_FILL_TYPE.equals(name)) {
            this.mFillType = VdPath.parseFillType(value);
        } else if (PATH_STROKE.equals(name)) {
            this.mStrokeColor = VdUtil.parseColorValue(value);
        } else if (PATH_FILL_OPACITY.equals(name)) {
            this.mFillAlpha = Float.parseFloat(value);
        } else if (PATH_STROKE_OPACITY.equals(name)) {
            this.mStrokeAlpha = Float.parseFloat(value);
        } else if (PATH_STROKE_WIDTH.equals(name)) {
            this.mStrokeWidth = Float.parseFloat(value);
        } else if (PATH_TRIM_START.equals(name)) {
            this.mTrimPathStart = Float.parseFloat(value);
        } else if (PATH_TRIM_END.equals(name)) {
            this.mTrimPathEnd = Float.parseFloat(value);
        } else if (PATH_TRIM_OFFSET.equals(name)) {
            this.mTrimPathOffset = Float.parseFloat(value);
        } else if (PATH_STROKE_LINE_CAP.equals(name)) {
            if (LINE_CAP_BUTT.equals(value)) {
                this.mStrokeLineCap = 0;
            } else if ("round".equals(value)) {
                this.mStrokeLineCap = 1;
            } else if (LINE_CAP_SQUARE.equals(value)) {
                this.mStrokeLineCap = 2;
            }
        } else if (PATH_STROKE_LINE_JOIN.equals(name)) {
            if (LINE_JOIN_MITER.equals(value)) {
                this.mStrokeLineJoin = 0;
            } else if ("round".equals(value)) {
                this.mStrokeLineJoin = 1;
            } else if (LINE_JOIN_BEVEL.equals(value)) {
                this.mStrokeLineJoin = 2;
            }
        } else if (PATH_STROKE_MITER_LIMIT.equals(name)) {
            this.mStrokeMiterlimit = Float.parseFloat(value);
        } else {
            VdPath.getLogger().log(Level.WARNING, ">>>>>> DID NOT UNDERSTAND ! \"" + name + "\" <<<<");
        }
    }

    private static int parseFillType(String value) {
        if (FILL_TYPE_EVEN_ODD.equalsIgnoreCase(value)) {
            return 0;
        }
        return 1;
    }

    protected static int applyAlpha(int color, float alpha) {
        int alphaBytes = color >> 24 & 0xFF;
        color &= 0xFFFFFF;
        return color |= (int)((float)alphaBytes * alpha) << 24;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform currentMatrix, float scaleX, float scaleY) {
        Path2D.Double path2d = new Path2D.Double(this.mFillType);
        this.toPath(path2d);
        g.setTransform(new AffineTransform());
        g.scale(scaleX, scaleY);
        g.transform(currentMatrix);
        if (this.mFillColor != 0 && this.fillGradient == null) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color fillColor = new Color(VdPath.applyAlpha(this.mFillColor, this.mFillAlpha), true);
            g.setColor(fillColor);
            g.fill(path2d);
        }
        if (this.mStrokeColor != 0 && this.mStrokeWidth != 0.0f && this.strokeGradient == null) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BasicStroke stroke = new BasicStroke(this.mStrokeWidth, this.mStrokeLineCap, this.mStrokeLineJoin, this.mStrokeMiterlimit);
            g.setStroke(stroke);
            Color strokeColor = new Color(VdPath.applyAlpha(this.mStrokeColor, this.mStrokeAlpha), true);
            g.setColor(strokeColor);
            g.draw(path2d);
        }
        if (this.isClipPath) {
            g.setClip(path2d);
        }
        if (this.fillGradient != null) {
            this.fillGradient.drawGradient(g, path2d, true);
        }
        if (this.strokeGradient != null) {
            this.strokeGradient.drawGradient(g, path2d, false);
        }
    }

    @Override
    public void parseAttributes(NamedNodeMap attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            org.w3c.dom.Node attribute = attributes.item(i);
            if (Objects.equals(attribute.getNamespaceURI(), "http://schemas.android.com/tools")) continue;
            String name = attribute.getNodeName();
            String value = attribute.getNodeValue();
            this.setNameValue(name, value);
        }
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    public String toString() {
        return "Path: Name: " + this.mName + " Node: " + Arrays.toString(this.mNodeList) + " mFillColor: " + Integer.toHexString(this.mFillColor) + " mFillAlpha:" + this.mFillAlpha + " mFillType:" + this.mFillType + " mStrokeColor:" + Integer.toHexString(this.mStrokeColor) + " mStrokeWidth:" + this.mStrokeWidth + " mStrokeAlpha:" + this.mStrokeAlpha;
    }

    protected void addGradientIfExists(org.w3c.dom.Node current) {
        org.w3c.dom.Node gradientNode = current.getFirstChild();
        VdGradient newGradient = new VdGradient();
        if (gradientNode != null && (gradientNode = gradientNode.getNextSibling()) != null) {
            String attrValue = gradientNode.getAttributes().getNamedItem("name").getNodeValue();
            if (attrValue.equals(PATH_FILL)) {
                this.fillGradient = newGradient;
            } else if (attrValue.equals(PATH_STROKE)) {
                this.strokeGradient = newGradient;
            }
            gradientNode = gradientNode.getFirstChild();
            if (gradientNode != null) {
                gradientNode = gradientNode.getNextSibling();
            }
        }
        if (gradientNode != null && gradientNode.getNodeName().equals("gradient")) {
            NamedNodeMap gradientAttributes = gradientNode.getAttributes();
            for (int i = 0; i < gradientAttributes.getLength(); ++i) {
                String name = gradientAttributes.item(i).getNodeName();
                String value = gradientAttributes.item(i).getNodeValue();
                newGradient.setGradientValue(name, value);
            }
            NodeList items = gradientNode.getChildNodes();
            for (int i = 0; i < items.getLength(); ++i) {
                org.w3c.dom.Node stop = items.item(i);
                if (!stop.getNodeName().equals("item")) continue;
                NamedNodeMap stopAttr = stop.getAttributes();
                String color = null;
                String offset = null;
                for (int j = 0; j < stopAttr.getLength(); ++j) {
                    org.w3c.dom.Node currentItem = stopAttr.item(j);
                    if (currentItem.getNodeName().equals("android:color")) {
                        color = currentItem.getNodeValue();
                        continue;
                    }
                    if (!currentItem.getNodeName().equals("android:offset")) continue;
                    offset = currentItem.getNodeValue();
                }
                if (color == null) {
                    color = "#000000";
                    VdPath.getLogger().log(Level.WARNING, ">>>>>> No color for gradient found >>>>>>");
                }
                if (offset == null) {
                    offset = "0";
                    VdPath.getLogger().log(Level.WARNING, ">>>>>> No offset for gradient found>>>>>>");
                }
                GradientStop gradientStop = new GradientStop(color, offset);
                newGradient.mGradientStops.add(gradientStop);
            }
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(VdPath.class.getSimpleName());
    }

    class VdGradient {
        private float mStartX;
        private float mStartY;
        private float mEndX;
        private float mEndY;
        private float mCenterX;
        private float mCenterY;
        private float mGradientRadius;
        private String mTileMode = "NO_CYCLE";
        private String mGradientType = "linear";
        private final ArrayList<GradientStop> mGradientStops = new ArrayList();

        VdGradient() {
        }

        private void setGradientValue(String name, String value) {
            switch (name) {
                case "android:type": {
                    this.mGradientType = value;
                    break;
                }
                case "android:tileMode": {
                    this.mTileMode = value;
                    break;
                }
                case "android:startX": {
                    this.mStartX = Float.parseFloat(value);
                    break;
                }
                case "android:startY": {
                    this.mStartY = Float.parseFloat(value);
                    break;
                }
                case "android:endX": {
                    this.mEndX = Float.parseFloat(value);
                    break;
                }
                case "android:endY": {
                    this.mEndY = Float.parseFloat(value);
                    break;
                }
                case "android:centerX": {
                    this.mCenterX = Float.parseFloat(value);
                    break;
                }
                case "android:centerY": {
                    this.mCenterY = Float.parseFloat(value);
                    break;
                }
                case "android:gradientRadius": {
                    this.mGradientRadius = Float.parseFloat(value);
                }
            }
        }

        private void drawGradient(Graphics2D g, Path2D path2d, boolean fill) {
            int i;
            if (this.mGradientStops.isEmpty()) {
                return;
            }
            float[] mFractions = new float[this.mGradientStops.size()];
            Color[] mGradientColors = new Color[this.mGradientStops.size()];
            for (int j = 0; j < this.mGradientStops.size(); ++j) {
                GradientStop stop = this.mGradientStops.get(j);
                float fraction = Float.parseFloat(stop.getOffset());
                int colorInt = VdUtil.parseColorValue(stop.getColor());
                Color color = new Color(colorInt, true);
                mFractions[j] = fraction;
                mGradientColors[j] = color;
            }
            for (i = 0; i < this.mGradientStops.size() - 1; ++i) {
                if (!(mFractions[i] >= mFractions[i + 1]) || !(mFractions[i] + 1.0E-6f <= 1.0f)) continue;
                mFractions[i + 1] = mFractions[i] + 1.0E-6f;
            }
            for (i = this.mGradientStops.size() - 2; i >= 0 && mFractions[i] >= mFractions[i + 1] && mFractions[i] >= 1.0f; --i) {
                mFractions[i] = mFractions[i + 1] - 1.0E-6f;
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BasicStroke stroke = new BasicStroke(VdPath.this.mStrokeWidth, VdPath.this.mStrokeLineCap, VdPath.this.mStrokeLineJoin, VdPath.this.mStrokeMiterlimit);
            if (this.mGradientStops.size() == 1) {
                g.setColor(mGradientColors[0]);
                if (!fill) {
                    g.setStroke(stroke);
                }
                g.draw(path2d);
            } else {
                MultipleGradientPaint.CycleMethod tile = MultipleGradientPaint.CycleMethod.NO_CYCLE;
                if (this.mTileMode.equals("mirror")) {
                    tile = MultipleGradientPaint.CycleMethod.REFLECT;
                } else if (this.mTileMode.equals("repeat")) {
                    tile = MultipleGradientPaint.CycleMethod.REPEAT;
                }
                if (this.mGradientType.equals("linear")) {
                    LinearGradientPaint gradient = new LinearGradientPaint(this.mStartX, this.mStartY, this.mEndX, this.mEndY, mFractions, mGradientColors, tile);
                    g.setPaint(gradient);
                } else if (this.mGradientType.equals("radial")) {
                    RadialGradientPaint paint = new RadialGradientPaint(this.mCenterX, this.mCenterY, this.mGradientRadius, mFractions, mGradientColors, tile);
                    g.setPaint(paint);
                } else {
                    VdPath.getLogger().log(Level.WARNING, ">>>>>> Unsupported gradient type: \"" + this.mGradientType + "\">>>>>>");
                }
                if (fill) {
                    g.fill(path2d);
                } else {
                    g.setStroke(stroke);
                    g.draw(path2d);
                }
            }
        }
    }

    public static class Node {
        private char mType;
        private float[] mParams;
        private static final char INIT_TYPE = ' ';
        private static final ImmutableMap<Character, Integer> commandStepMap = ImmutableMap.builder().put((Object)Character.valueOf('z'), (Object)2).put((Object)Character.valueOf('Z'), (Object)2).put((Object)Character.valueOf('m'), (Object)2).put((Object)Character.valueOf('M'), (Object)2).put((Object)Character.valueOf('l'), (Object)2).put((Object)Character.valueOf('L'), (Object)2).put((Object)Character.valueOf('t'), (Object)2).put((Object)Character.valueOf('T'), (Object)2).put((Object)Character.valueOf('h'), (Object)1).put((Object)Character.valueOf('H'), (Object)1).put((Object)Character.valueOf('v'), (Object)1).put((Object)Character.valueOf('V'), (Object)1).put((Object)Character.valueOf('c'), (Object)6).put((Object)Character.valueOf('C'), (Object)6).put((Object)Character.valueOf('s'), (Object)4).put((Object)Character.valueOf('S'), (Object)4).put((Object)Character.valueOf('q'), (Object)4).put((Object)Character.valueOf('Q'), (Object)4).put((Object)Character.valueOf('a'), (Object)7).put((Object)Character.valueOf('A'), (Object)7).build();

        public char getType() {
            return this.mType;
        }

        public float[] getParams() {
            return this.mParams;
        }

        public Node(char type, float[] params) {
            this.mType = type;
            this.mParams = params;
        }

        public Node(Node n) {
            this.mType = n.mType;
            this.mParams = Arrays.copyOf(n.mParams, n.mParams.length);
        }

        public static boolean hasRelMoveAfterClose(Node[] nodes) {
            int preType = 32;
            for (Node n : nodes) {
                if ((preType == 122 || preType == 90) && n.mType == 'm') {
                    return true;
                }
                preType = n.mType;
            }
            return false;
        }

        public static String nodeListToString(Node[] nodes, NumberFormat format) {
            StringBuilder result = new StringBuilder();
            for (Node node : nodes) {
                result.append(node.mType);
                int len = node.mParams.length;
                boolean implicitLineTo = false;
                char lineToType = ' ';
                if ((node.mType == 'm' || node.mType == 'M') && len > 2) {
                    implicitLineTo = true;
                    lineToType = node.mType == 'm' ? (char)'l' : 'L';
                }
                for (int j = 0; j < len; ++j) {
                    float param;
                    if (j > 0) {
                        result.append(j % 2 != 0 ? "," : " ");
                    }
                    if (implicitLineTo && j == 2) {
                        result.append(lineToType);
                    }
                    if (!Float.isFinite(param = node.mParams[j])) {
                        throw new IllegalArgumentException("Invalid number: " + param);
                    }
                    String str = XmlUtils.trimInsignificantZeros((String)format.format(param));
                    result.append(str);
                }
            }
            return result.toString();
        }

        public static void transform(AffineTransform totalTransform, Node[] nodes) {
            Point2D.Float currentPoint = new Point2D.Float();
            Point2D.Float currentSegmentStartPoint = new Point2D.Float();
            char previousType = ' ';
            for (Node n : nodes) {
                n.transform(totalTransform, currentPoint, currentSegmentStartPoint, previousType);
                previousType = n.mType;
            }
        }

        private void transform(AffineTransform totalTransform, Point2D.Float currentPoint, Point2D.Float currentSegmentStartPoint, char previousType) {
            int paramsLen = this.mParams.length;
            float[] tempParams = new float[2 * paramsLen];
            float currentX = currentPoint.x;
            float currentY = currentPoint.y;
            float currentSegmentStartX = currentSegmentStartPoint.x;
            float currentSegmentStartY = currentSegmentStartPoint.y;
            int step = (Integer)commandStepMap.get((Object)Character.valueOf(this.mType));
            switch (this.mType) {
                case 'Z': 
                case 'z': {
                    currentX = currentSegmentStartX;
                    currentY = currentSegmentStartY;
                    break;
                }
                case 'C': 
                case 'L': 
                case 'M': 
                case 'Q': 
                case 'S': 
                case 'T': {
                    currentX = this.mParams[paramsLen - 2];
                    currentY = this.mParams[paramsLen - 1];
                    if (this.mType == 'M') {
                        currentSegmentStartX = currentX;
                        currentSegmentStartY = currentY;
                    }
                    totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLen / 2);
                    break;
                }
                case 'm': {
                    if (previousType == 'z' || previousType == 'Z') {
                        this.mType = (char)77;
                        this.mParams[0] = this.mParams[0] + currentSegmentStartX;
                        this.mParams[1] = this.mParams[1] + currentSegmentStartY;
                        currentSegmentStartX = this.mParams[0];
                        currentSegmentStartY = this.mParams[1];
                        for (int i = step; i < paramsLen; i += step) {
                            int n = i;
                            this.mParams[n] = this.mParams[n] + this.mParams[i - step];
                            int n2 = i + 1;
                            this.mParams[n2] = this.mParams[n2] + this.mParams[i + 1 - step];
                        }
                        currentX = this.mParams[paramsLen - 2];
                        currentY = this.mParams[paramsLen - 1];
                        totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLen / 2);
                        break;
                    }
                    int startIndex = 0;
                    if (previousType == ' ') {
                        int paramsLenInitialM = 2;
                        currentX = this.mParams[paramsLenInitialM - 2];
                        currentY = this.mParams[paramsLenInitialM - 1];
                        currentSegmentStartX = currentX;
                        currentSegmentStartY = currentY;
                        totalTransform.transform(this.mParams, 0, this.mParams, 0, paramsLenInitialM / 2);
                        startIndex = step;
                    }
                    for (int i = startIndex; i < paramsLen; i += step) {
                        currentX += this.mParams[i + step - 2];
                        currentY += this.mParams[i + step - 1];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    Node.deltaTransform(totalTransform, this.mParams, startIndex, paramsLen - startIndex);
                    break;
                }
                case 'c': 
                case 'l': 
                case 'q': 
                case 's': 
                case 't': {
                    for (int i = 0; i < paramsLen; i += step) {
                        currentX += this.mParams[i + step - 2];
                        currentY += this.mParams[i + step - 1];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    Node.deltaTransform(totalTransform, this.mParams, 0, paramsLen);
                    break;
                }
                case 'H': {
                    this.mType = (char)76;
                    for (int i = 0; i < paramsLen; ++i) {
                        tempParams[i * 2] = this.mParams[i];
                        tempParams[i * 2 + 1] = currentY;
                        currentX = this.mParams[i];
                    }
                    totalTransform.transform(tempParams, 0, tempParams, 0, paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'V': {
                    this.mType = (char)76;
                    for (int i = 0; i < paramsLen; ++i) {
                        tempParams[i * 2] = currentX;
                        tempParams[i * 2 + 1] = this.mParams[i];
                        currentY = this.mParams[i];
                    }
                    totalTransform.transform(tempParams, 0, tempParams, 0, paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'h': {
                    for (int i = 0; i < paramsLen; ++i) {
                        currentX += this.mParams[i];
                        tempParams[i * 2] = this.mParams[i];
                        tempParams[i * 2 + 1] = 0.0f;
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    this.mType = (char)108;
                    Node.deltaTransform(totalTransform, tempParams, 0, 2 * paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'v': {
                    for (int i = 0; i < paramsLen; ++i) {
                        tempParams[i * 2] = 0.0f;
                        tempParams[i * 2 + 1] = this.mParams[i];
                        currentY += this.mParams[i];
                    }
                    if (Node.isTranslationOnly(totalTransform)) break;
                    this.mType = (char)108;
                    Node.deltaTransform(totalTransform, tempParams, 0, 2 * paramsLen);
                    this.mParams = tempParams;
                    break;
                }
                case 'A': {
                    for (int i = 0; i < paramsLen; i += step) {
                        if (!Node.isTranslationOnly(totalTransform)) {
                            EllipseSolver ellipseSolver = new EllipseSolver(totalTransform, currentX, currentY, this.mParams[i], this.mParams[i + 1], this.mParams[i + 2], this.mParams[i + 3], this.mParams[i + 4], this.mParams[i + 5], this.mParams[i + 6]);
                            this.mParams[i] = ellipseSolver.getMajorAxis();
                            this.mParams[i + 1] = ellipseSolver.getMinorAxis();
                            this.mParams[i + 2] = ellipseSolver.getRotationDegree();
                            if (ellipseSolver.getDirectionChanged()) {
                                this.mParams[i + 4] = 1.0f - this.mParams[i + 4];
                            }
                        }
                        currentX = this.mParams[i + 5];
                        currentY = this.mParams[i + 6];
                        totalTransform.transform(this.mParams, i + 5, this.mParams, i + 5, 1);
                    }
                    break;
                }
                case 'a': {
                    for (int i = 0; i < paramsLen; i += step) {
                        float oldCurrentX = currentX;
                        float oldCurrentY = currentY;
                        currentX += this.mParams[i + 5];
                        currentY += this.mParams[i + 6];
                        if (Node.isTranslationOnly(totalTransform)) continue;
                        EllipseSolver ellipseSolver = new EllipseSolver(totalTransform, oldCurrentX, oldCurrentY, this.mParams[i], this.mParams[i + 1], this.mParams[i + 2], this.mParams[i + 3], this.mParams[i + 4], oldCurrentX + this.mParams[i + 5], oldCurrentY + this.mParams[i + 6]);
                        Node.deltaTransform(totalTransform, this.mParams, i + 5, 2);
                        this.mParams[i] = ellipseSolver.getMajorAxis();
                        this.mParams[i + 1] = ellipseSolver.getMinorAxis();
                        this.mParams[i + 2] = ellipseSolver.getRotationDegree();
                        if (!ellipseSolver.getDirectionChanged()) continue;
                        this.mParams[i + 4] = 1.0f - this.mParams[i + 4];
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected type " + this.mType);
                }
            }
            currentPoint.setLocation(currentX, currentY);
            currentSegmentStartPoint.setLocation(currentSegmentStartX, currentSegmentStartY);
        }

        private static boolean isTranslationOnly(AffineTransform totalTransform) {
            int type = totalTransform.getType();
            return type == 0 || type == 1;
        }

        private static void deltaTransform(AffineTransform totalTransform, float[] coordinates, int offset, int paramsLen) {
            int i;
            double[] doubleArray = new double[paramsLen];
            for (i = 0; i < paramsLen; ++i) {
                doubleArray[i] = coordinates[i + offset];
            }
            totalTransform.deltaTransform(doubleArray, 0, doubleArray, 0, paramsLen / 2);
            for (i = 0; i < paramsLen; ++i) {
                coordinates[i + offset] = (float)doubleArray[i];
            }
        }
    }
}

