/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMerger;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceTable;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;

public class ResourceRepositories {
    private ResourceRepositories() {
    }

    public static void sortItemLists(ListMultimap<String, ResourceItem> multimap) {
        ArrayListMultimap sorted = ArrayListMultimap.create();
        Ordering ordering = Ordering.from(ResourceItem.BY_KEY);
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            sorted.putAll(entry.getKey(), (Iterable)ordering.sortedCopy((Iterable)entry.getValue()));
        }
        multimap.clear();
        multimap.putAll((Multimap)sorted);
    }

    public static void updateTableFromMerger(ResourceMerger merger, final ResourceTable fullTable) {
        MergeConsumer<ResourceMergerItem> consumer = new MergeConsumer<ResourceMergerItem>(){

            @Override
            public void start(DocumentBuilderFactory factory) {
            }

            @Override
            public void end() {
            }

            @Override
            public void addItem(ResourceMergerItem item) {
                ListMultimap<String, ResourceItem> multimap;
                if (item.isTouched() && !(multimap = fullTable.getOrPutEmpty(item.getNamespace(), item.getType())).containsEntry((Object)item.getName(), (Object)item)) {
                    multimap.put((Object)item.getName(), (Object)item);
                }
            }

            @Override
            public void removeItem(ResourceMergerItem removedItem, ResourceMergerItem replacedBy) {
                fullTable.remove(removedItem);
            }

            @Override
            public boolean ignoreItemInMerge(ResourceMergerItem item) {
                return false;
            }
        };
        try {
            merger.mergeData(consumer, true);
        }
        catch (MergingException e) {
            throw new RuntimeException(e);
        }
    }
}

