/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"ALPHA_MASK", "", "getCoordinateFormat", "Ljava/text/DecimalFormat;", "maxViewportSize", "", "parseColorValue", "color", "", "sdk-common"})
@JvmName(name="VdUtil")
public final class VdUtil {
    private static final int ALPHA_MASK = -16777216;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DecimalFormat getCoordinateFormat(float maxViewportSize) {
        int exponent = (int)Math.floor(Math.log10(maxViewportSize));
        int fractionalDigits = 5 - exponent;
        StringBuilder formatBuilder = new StringBuilder("#");
        if (fractionalDigits > 0) {
            if (fractionalDigits > 6) {
                fractionalDigits = 6;
            }
            formatBuilder.append('.');
            int n = 0;
            int n2 = fractionalDigits;
            while (n < n2) {
                void i;
                formatBuilder.append('#');
                ++i;
            }
        }
        DecimalFormatSymbols fractionSeparator = new DecimalFormatSymbols();
        fractionSeparator.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat(formatBuilder.toString(), fractionSeparator);
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format;
    }

    public static final int parseColorValue(@NotNull String color) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        switch (color.length()) {
            case 7: {
                String string = color;
                int n2 = 1;
                String string2 = string.substring(n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                n = Integer.parseUnsignedInt(string2, 16) | 0xFF000000;
                break;
            }
            case 9: {
                String string = color;
                int n3 = 1;
                String string3 = string.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                n = Integer.parseUnsignedInt(string3, 16);
                break;
            }
            case 4: {
                String string = color;
                int n4 = 1;
                String string4 = string.substring(n4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                int v = Integer.parseUnsignedInt(string4, 16);
                int k = (v >> 8 & 0xF) * 0x110000;
                k |= (v >> 4 & 0xF) * 4352;
                n = (k |= (v & 0xF) * 17) | 0xFF000000;
                break;
            }
            case 5: {
                String k = color;
                int n5 = 1;
                String string = k.substring(n5);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                int v = Integer.parseUnsignedInt(string, 16);
                int k2 = (v >> 12 & 0xF) * 0x11000000;
                k2 |= (v >> 8 & 0xF) * 0x110000;
                k2 |= (v >> 4 & 0xF) * 4352;
                n = (k2 |= (v & 0xF) * 17) | 0xFF000000;
                break;
            }
            default: {
                n = -16777216;
            }
        }
        return n;
    }
}

