/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.HighDynamicRangeQualifier;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenRoundQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.resources.configuration.WideGamutColorQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class FolderConfiguration
implements Comparable<FolderConfiguration>,
Serializable {
    private static final ResourceQualifier[] DEFAULT_QUALIFIERS;
    public static final Splitter QUALIFIER_SPLITTER;
    private static final int INDEX_COUNTRY_CODE = 0;
    private static final int INDEX_NETWORK_CODE = 1;
    private static final int INDEX_LOCALE = 2;
    private static final int INDEX_LAYOUT_DIR = 3;
    private static final int INDEX_SMALLEST_SCREEN_WIDTH = 4;
    private static final int INDEX_SCREEN_WIDTH = 5;
    private static final int INDEX_SCREEN_HEIGHT = 6;
    private static final int INDEX_SCREEN_LAYOUT_SIZE = 7;
    private static final int INDEX_SCREEN_RATIO = 8;
    private static final int INDEX_SCREEN_ROUND = 9;
    private static final int INDEX_WIDE_COLOR_GAMUT = 10;
    private static final int INDEX_HIGH_DYNAMIC_RANGE = 11;
    private static final int INDEX_SCREEN_ORIENTATION = 12;
    private static final int INDEX_UI_MODE = 13;
    private static final int INDEX_NIGHT_MODE = 14;
    private static final int INDEX_PIXEL_DENSITY = 15;
    private static final int INDEX_TOUCH_TYPE = 16;
    private static final int INDEX_KEYBOARD_STATE = 17;
    private static final int INDEX_TEXT_INPUT_METHOD = 18;
    private static final int INDEX_NAVIGATION_STATE = 19;
    private static final int INDEX_NAVIGATION_METHOD = 20;
    private static final int INDEX_SCREEN_DIMENSION = 21;
    private static final int INDEX_VERSION = 22;
    private static final int INDEX_COUNT = 23;
    private static final ResourceQualifier[] NULL_QUALIFIERS;
    private final ResourceQualifier[] mQualifiers = new ResourceQualifier[23];
    private String mQualifierString;

    public FolderConfiguration() {
        this(NULL_QUALIFIERS);
        this.mQualifierString = "";
    }

    private FolderConfiguration(ResourceQualifier[] qualifiers) {
        System.arraycopy(qualifiers, 0, this.mQualifiers, 0, 23);
    }

    public static FolderConfiguration getConfig(String[] folderSegments) {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])folderSegments);
        if (iterator.hasNext()) {
            iterator.next();
        }
        return FolderConfiguration.getConfigFromQualifiers((Iterator<String>)iterator);
    }

    public static FolderConfiguration getConfig(Iterable<String> folderSegments) {
        Iterator<String> iterator = folderSegments.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return FolderConfiguration.getConfigFromQualifiers(iterator);
    }

    public static FolderConfiguration getConfigFromQualifiers(Iterable<String> qualifiers) {
        return FolderConfiguration.getConfigFromQualifiers(qualifiers.iterator());
    }

    public static FolderConfiguration getConfigFromQualifiers(Iterator<String> qualifiers) {
        String seg;
        FolderConfiguration config = new FolderConfiguration();
        int qualifierIndex = 0;
        int qualifierCount = DEFAULT_QUALIFIERS.length;
        if (!qualifiers.hasNext()) {
            return config;
        }
        while (qualifiers.hasNext()) {
            seg = qualifiers.next();
            if (seg.isEmpty()) {
                return null;
            }
            seg = seg.toLowerCase(Locale.US);
            while (qualifierIndex < 2 && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                ++qualifierIndex;
            }
            if (qualifierIndex == 2) {
                boolean handle = true;
                if (DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                    ++qualifierIndex;
                    if (qualifiers.hasNext()) {
                        seg = qualifiers.next();
                        if (seg.isEmpty()) {
                            return null;
                        }
                        if (LocaleQualifier.isRegionSegment(seg)) {
                            LocaleQualifier localeQualifier = config.getLocaleQualifier();
                            assert (localeQualifier != null);
                            localeQualifier.setRegionSegment(seg);
                            handle = false;
                        } else {
                            seg = seg.toLowerCase(Locale.US);
                        }
                    } else {
                        return config;
                    }
                }
                if (!handle) break;
                while (qualifierIndex < qualifierCount && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                    ++qualifierIndex;
                }
                if (qualifierIndex == qualifierCount) {
                    return null;
                }
                ++qualifierIndex;
                break;
            }
            ++qualifierIndex;
        }
        while (qualifiers.hasNext()) {
            seg = qualifiers.next();
            if (seg.isEmpty()) {
                return null;
            }
            seg = seg.toLowerCase(Locale.US);
            while (qualifierIndex < qualifierCount && !DEFAULT_QUALIFIERS[qualifierIndex].checkAndSet(seg, config)) {
                ++qualifierIndex;
            }
            if (qualifierIndex == qualifierCount) {
                return null;
            }
            ++qualifierIndex;
        }
        return config;
    }

    public static FolderConfiguration getConfigForFolder(String folderName) {
        return FolderConfiguration.getConfig(QUALIFIER_SPLITTER.split((CharSequence)folderName));
    }

    public static FolderConfiguration copyOf(FolderConfiguration original) {
        return new FolderConfiguration(original.mQualifiers);
    }

    public static FolderConfiguration getConfigForQualifierString(String qualifierString) {
        if (qualifierString.isEmpty()) {
            return new FolderConfiguration();
        }
        return FolderConfiguration.getConfigFromQualifiers(QUALIFIER_SPLITTER.split((CharSequence)qualifierString));
    }

    public static int getQualifierCount() {
        return 23;
    }

    public void set(FolderConfiguration config) {
        this.set(config, false);
    }

    public void set(FolderConfiguration config, boolean nonFakeValuesOnly) {
        if (config != null) {
            for (int i = 0; i < 23; ++i) {
                ResourceQualifier q = config.mQualifiers[i];
                if (nonFakeValuesOnly && q != null && q.hasFakeValue()) continue;
                this.mQualifiers[i] = q;
                this.mQualifierString = null;
            }
        }
    }

    public void reset() {
        System.arraycopy(NULL_QUALIFIERS, 0, this.mQualifiers, 0, 23);
        this.mQualifierString = "";
    }

    public void substract(FolderConfiguration config) {
        for (int i = 0; i < 23; ++i) {
            if (!ResourceQualifier.isValid(config.mQualifiers[i])) continue;
            this.mQualifiers[i] = NULL_QUALIFIERS[i];
            this.mQualifierString = null;
        }
    }

    public void add(FolderConfiguration config) {
        for (int i = 0; i < 23; ++i) {
            if (config.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            this.mQualifiers[i] = config.mQualifiers[i];
            this.mQualifierString = null;
        }
    }

    public ResourceQualifier getInvalidQualifier() {
        for (int i = 0; i < 23; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i].isValid()) continue;
            return this.mQualifiers[i];
        }
        return null;
    }

    public void addQualifier(ResourceQualifier qualifier) {
        if (qualifier instanceof CountryCodeQualifier) {
            this.mQualifiers[0] = qualifier;
        } else if (qualifier instanceof NetworkCodeQualifier) {
            this.mQualifiers[1] = qualifier;
        } else if (qualifier instanceof LocaleQualifier) {
            this.mQualifiers[2] = qualifier;
        } else if (qualifier instanceof LayoutDirectionQualifier) {
            this.mQualifiers[3] = qualifier;
        } else if (qualifier instanceof SmallestScreenWidthQualifier) {
            this.mQualifiers[4] = qualifier;
        } else if (qualifier instanceof ScreenWidthQualifier) {
            this.mQualifiers[5] = qualifier;
        } else if (qualifier instanceof ScreenHeightQualifier) {
            this.mQualifiers[6] = qualifier;
        } else if (qualifier instanceof ScreenSizeQualifier) {
            this.mQualifiers[7] = qualifier;
        } else if (qualifier instanceof ScreenRatioQualifier) {
            this.mQualifiers[8] = qualifier;
        } else if (qualifier instanceof ScreenRoundQualifier) {
            this.mQualifiers[9] = qualifier;
        } else if (qualifier instanceof WideGamutColorQualifier) {
            this.mQualifiers[10] = qualifier;
        } else if (qualifier instanceof HighDynamicRangeQualifier) {
            this.mQualifiers[11] = qualifier;
        } else if (qualifier instanceof ScreenOrientationQualifier) {
            this.mQualifiers[12] = qualifier;
        } else if (qualifier instanceof UiModeQualifier) {
            this.mQualifiers[13] = qualifier;
        } else if (qualifier instanceof NightModeQualifier) {
            this.mQualifiers[14] = qualifier;
        } else if (qualifier instanceof DensityQualifier) {
            this.mQualifiers[15] = qualifier;
        } else if (qualifier instanceof TouchScreenQualifier) {
            this.mQualifiers[16] = qualifier;
        } else if (qualifier instanceof KeyboardStateQualifier) {
            this.mQualifiers[17] = qualifier;
        } else if (qualifier instanceof TextInputMethodQualifier) {
            this.mQualifiers[18] = qualifier;
        } else if (qualifier instanceof NavigationStateQualifier) {
            this.mQualifiers[19] = qualifier;
        } else if (qualifier instanceof NavigationMethodQualifier) {
            this.mQualifiers[20] = qualifier;
        } else if (qualifier instanceof ScreenDimensionQualifier) {
            this.mQualifiers[21] = qualifier;
        } else if (qualifier instanceof VersionQualifier) {
            this.mQualifiers[22] = qualifier;
        }
        this.mQualifierString = null;
    }

    public void removeQualifier(ResourceQualifier qualifier) {
        for (int i = 0; i < 23; ++i) {
            if (this.mQualifiers[i] != qualifier) continue;
            this.mQualifiers[i] = NULL_QUALIFIERS[i];
            this.mQualifierString = null;
            return;
        }
    }

    public ResourceQualifier getQualifier(int index) {
        return this.mQualifiers[index];
    }

    public void setCountryCodeQualifier(CountryCodeQualifier qualifier) {
        this.mQualifiers[0] = qualifier == null ? NULL_QUALIFIERS[0] : qualifier;
        this.mQualifierString = null;
    }

    public CountryCodeQualifier getCountryCodeQualifier() {
        return (CountryCodeQualifier)this.mQualifiers[0];
    }

    public void setNetworkCodeQualifier(NetworkCodeQualifier qualifier) {
        this.mQualifiers[1] = qualifier == null ? NULL_QUALIFIERS[1] : qualifier;
        this.mQualifierString = null;
    }

    public NetworkCodeQualifier getNetworkCodeQualifier() {
        return (NetworkCodeQualifier)this.mQualifiers[1];
    }

    public void setLocaleQualifier(LocaleQualifier qualifier) {
        this.mQualifiers[2] = qualifier == null ? NULL_QUALIFIERS[2] : qualifier;
        this.mQualifierString = null;
    }

    public LocaleQualifier getLocaleQualifier() {
        return (LocaleQualifier)this.mQualifiers[2];
    }

    public void setLayoutDirectionQualifier(LayoutDirectionQualifier qualifier) {
        this.mQualifiers[3] = qualifier == null ? NULL_QUALIFIERS[3] : qualifier;
        this.mQualifierString = null;
    }

    public LayoutDirectionQualifier getLayoutDirectionQualifier() {
        return (LayoutDirectionQualifier)this.mQualifiers[3];
    }

    public void setSmallestScreenWidthQualifier(SmallestScreenWidthQualifier qualifier) {
        this.mQualifiers[4] = qualifier == null ? NULL_QUALIFIERS[4] : qualifier;
        this.mQualifierString = null;
    }

    public SmallestScreenWidthQualifier getSmallestScreenWidthQualifier() {
        return (SmallestScreenWidthQualifier)this.mQualifiers[4];
    }

    public void setScreenWidthQualifier(ScreenWidthQualifier qualifier) {
        this.mQualifiers[5] = qualifier == null ? NULL_QUALIFIERS[5] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenWidthQualifier getScreenWidthQualifier() {
        return (ScreenWidthQualifier)this.mQualifiers[5];
    }

    public void setScreenHeightQualifier(ScreenHeightQualifier qualifier) {
        this.mQualifiers[6] = qualifier == null ? NULL_QUALIFIERS[6] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenHeightQualifier getScreenHeightQualifier() {
        return (ScreenHeightQualifier)this.mQualifiers[6];
    }

    public void setScreenSizeQualifier(ScreenSizeQualifier qualifier) {
        this.mQualifiers[7] = qualifier == null ? NULL_QUALIFIERS[7] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenSizeQualifier getScreenSizeQualifier() {
        return (ScreenSizeQualifier)this.mQualifiers[7];
    }

    public void setScreenRatioQualifier(ScreenRatioQualifier qualifier) {
        this.mQualifiers[8] = qualifier == null ? NULL_QUALIFIERS[8] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenRatioQualifier getScreenRatioQualifier() {
        return (ScreenRatioQualifier)this.mQualifiers[8];
    }

    public void setScreenRoundQualifier(ScreenRoundQualifier qualifier) {
        this.mQualifiers[9] = qualifier == null ? NULL_QUALIFIERS[9] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenRoundQualifier getScreenRoundQualifier() {
        return (ScreenRoundQualifier)this.mQualifiers[9];
    }

    public void setWideColorGamutQualifier(WideGamutColorQualifier qualifier) {
        this.mQualifiers[10] = qualifier == null ? NULL_QUALIFIERS[10] : qualifier;
        this.mQualifierString = null;
    }

    public WideGamutColorQualifier getWideColorGamutQualifier() {
        return (WideGamutColorQualifier)this.mQualifiers[10];
    }

    public void setHighDynamicRangeQualifier(HighDynamicRangeQualifier qualifier) {
        this.mQualifiers[11] = qualifier == null ? NULL_QUALIFIERS[11] : qualifier;
        this.mQualifierString = null;
    }

    public HighDynamicRangeQualifier getHighDynamicRangeQualifier() {
        return (HighDynamicRangeQualifier)this.mQualifiers[11];
    }

    public void setScreenOrientationQualifier(ScreenOrientationQualifier qualifier) {
        this.mQualifiers[12] = qualifier == null ? NULL_QUALIFIERS[12] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenOrientationQualifier getScreenOrientationQualifier() {
        return (ScreenOrientationQualifier)this.mQualifiers[12];
    }

    public void setUiModeQualifier(UiModeQualifier qualifier) {
        this.mQualifiers[13] = qualifier == null ? NULL_QUALIFIERS[13] : qualifier;
        this.mQualifierString = null;
    }

    public UiModeQualifier getUiModeQualifier() {
        return (UiModeQualifier)this.mQualifiers[13];
    }

    public void setNightModeQualifier(NightModeQualifier qualifier) {
        this.mQualifiers[14] = qualifier == null ? NULL_QUALIFIERS[14] : qualifier;
        this.mQualifierString = null;
    }

    public NightModeQualifier getNightModeQualifier() {
        return (NightModeQualifier)this.mQualifiers[14];
    }

    public void setDensityQualifier(DensityQualifier qualifier) {
        this.mQualifiers[15] = qualifier == null ? NULL_QUALIFIERS[15] : qualifier;
        this.mQualifierString = null;
    }

    public DensityQualifier getDensityQualifier() {
        return (DensityQualifier)this.mQualifiers[15];
    }

    public void setTouchTypeQualifier(TouchScreenQualifier qualifier) {
        this.mQualifiers[16] = qualifier == null ? NULL_QUALIFIERS[16] : qualifier;
        this.mQualifierString = null;
    }

    public TouchScreenQualifier getTouchTypeQualifier() {
        return (TouchScreenQualifier)this.mQualifiers[16];
    }

    public void setKeyboardStateQualifier(KeyboardStateQualifier qualifier) {
        this.mQualifiers[17] = qualifier == null ? NULL_QUALIFIERS[17] : qualifier;
        this.mQualifierString = null;
    }

    public KeyboardStateQualifier getKeyboardStateQualifier() {
        return (KeyboardStateQualifier)this.mQualifiers[17];
    }

    public void setTextInputMethodQualifier(TextInputMethodQualifier qualifier) {
        this.mQualifiers[18] = qualifier == null ? NULL_QUALIFIERS[18] : qualifier;
        this.mQualifierString = null;
    }

    public TextInputMethodQualifier getTextInputMethodQualifier() {
        return (TextInputMethodQualifier)this.mQualifiers[18];
    }

    public void setNavigationStateQualifier(NavigationStateQualifier qualifier) {
        this.mQualifiers[19] = qualifier == null ? NULL_QUALIFIERS[19] : qualifier;
        this.mQualifierString = null;
    }

    public NavigationStateQualifier getNavigationStateQualifier() {
        return (NavigationStateQualifier)this.mQualifiers[19];
    }

    public void setNavigationMethodQualifier(NavigationMethodQualifier qualifier) {
        this.mQualifiers[20] = qualifier == null ? NULL_QUALIFIERS[20] : qualifier;
        this.mQualifierString = null;
    }

    public NavigationMethodQualifier getNavigationMethodQualifier() {
        return (NavigationMethodQualifier)this.mQualifiers[20];
    }

    public void setScreenDimensionQualifier(ScreenDimensionQualifier qualifier) {
        this.mQualifiers[21] = qualifier == null ? NULL_QUALIFIERS[21] : qualifier;
        this.mQualifierString = null;
    }

    public ScreenDimensionQualifier getScreenDimensionQualifier() {
        return (ScreenDimensionQualifier)this.mQualifiers[21];
    }

    public void setVersionQualifier(VersionQualifier qualifier) {
        this.mQualifiers[22] = qualifier == null ? NULL_QUALIFIERS[22] : qualifier;
        this.mQualifierString = null;
    }

    public VersionQualifier getVersionQualifier() {
        return (VersionQualifier)this.mQualifiers[22];
    }

    public void normalize() {
        int minSdk = 1;
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            int min;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (min = qualifier.since()) <= minSdk) continue;
            minSdk = min;
        }
        if (minSdk == 1) {
            return;
        }
        if (this.mQualifiers[22] == NULL_QUALIFIERS[22] || ((VersionQualifier)this.mQualifiers[22]).getVersion() < minSdk) {
            this.mQualifiers[22] = new VersionQualifier(minSdk);
            this.mQualifierString = null;
        }
    }

    public void updateScreenWidthAndHeight() {
        ResourceQualifier sizeQ = this.mQualifiers[21];
        ResourceQualifier densityQ = this.mQualifiers[15];
        ResourceQualifier orientQ = this.mQualifiers[12];
        if (sizeQ != NULL_QUALIFIERS[21] && densityQ != NULL_QUALIFIERS[15] && orientQ != NULL_QUALIFIERS[12]) {
            int size2;
            Density density = ((DensityQualifier)densityQ).getValue();
            if (density == Density.NODPI || density == Density.ANYDPI) {
                return;
            }
            ScreenOrientation orientation = ((ScreenOrientationQualifier)orientQ).getValue();
            int size1 = ((ScreenDimensionQualifier)sizeQ).getValue1();
            if (size1 < (size2 = ((ScreenDimensionQualifier)sizeQ).getValue2())) {
                int a = size1;
                size1 = size2;
                size2 = a;
            }
            assert (density != null);
            int dp1 = FolderConfiguration.divideWithRoundingUp(size1 * 160, density.getDpiValue());
            int dp2 = FolderConfiguration.divideWithRoundingUp(size2 * 160, density.getDpiValue());
            this.setSmallestScreenWidthQualifier(new SmallestScreenWidthQualifier(dp2));
            switch (orientation) {
                case PORTRAIT: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp2));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp1));
                    break;
                }
                case LANDSCAPE: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp1));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp2));
                    break;
                }
                case SQUARE: {
                    this.setScreenWidthQualifier(new ScreenWidthQualifier(dp2));
                    this.setScreenHeightQualifier(new ScreenHeightQualifier(dp2));
                }
            }
        }
    }

    private static int divideWithRoundingUp(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FolderConfiguration)) {
            return false;
        }
        FolderConfiguration fc = (FolderConfiguration)obj;
        for (int i = 0; i < 23; ++i) {
            ResourceQualifier qualifier = this.mQualifiers[i];
            ResourceQualifier fcQualifier = fc.mQualifiers[i];
            if (Objects.equals(qualifier, fcQualifier)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getQualifierString().hashCode();
    }

    public boolean isDefault() {
        return this.getQualifierString().isEmpty();
    }

    public String getFolderName(ResourceFolderType folder) {
        StringBuilder result = new StringBuilder(folder.getName());
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            String segment;
            ResourceQualifier qualifier = this.mQualifiers[i];
            if (qualifier == NULL_QUALIFIERS[i] || (segment = qualifier.getFolderSegment()) == null || segment.isEmpty()) continue;
            result.append("-");
            result.append(segment);
        }
        return result.toString();
    }

    public String getUniqueKey() {
        String qualifierString = this.getQualifierString();
        return qualifierString.isEmpty() ? "" : "-" + qualifierString;
    }

    public String getQualifierString() {
        if (this.mQualifierString == null) {
            StringBuilder result = null;
            for (int i = 0; i < this.mQualifiers.length; ++i) {
                String segment;
                ResourceQualifier qualifier = this.mQualifiers[i];
                if (qualifier == NULL_QUALIFIERS[i] || (segment = qualifier.getFolderSegment()) == null || segment.isEmpty()) continue;
                if (result == null) {
                    result = new StringBuilder(40);
                } else {
                    result.append("-");
                }
                result.append(segment);
            }
            this.mQualifierString = result == null ? "" : result.toString();
        }
        return this.mQualifierString;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        if (this.isDefault()) {
            return "default";
        }
        StringBuilder result = null;
        int index = 0;
        while (index < 23) {
            ResourceQualifier qualifier = this.mQualifiers[index];
            if (qualifier == NULL_QUALIFIERS[index++]) continue;
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(", ");
            }
            result.append(qualifier.getLongDisplayValue());
        }
        return result == null ? "" : result.toString();
    }

    public String toShortDisplayString() {
        if (this.isDefault()) {
            return "default";
        }
        StringBuilder result = new StringBuilder(100);
        int index = 0;
        while (index < 23) {
            ResourceQualifier qualifier = this.mQualifiers[index];
            if (qualifier == NULL_QUALIFIERS[index++]) continue;
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(qualifier.getShortDisplayValue());
        }
        return result.toString();
    }

    @Override
    public int compareTo(FolderConfiguration folderConfig) {
        if (this.isDefault()) {
            if (folderConfig.isDefault()) {
                return 0;
            }
            return -1;
        }
        for (int i = 0; i < 23; ++i) {
            ResourceQualifier qualifier1 = this.mQualifiers[i];
            ResourceQualifier qualifier2 = folderConfig.mQualifiers[i];
            if (Objects.equals(qualifier1, qualifier2)) continue;
            if (qualifier1 != null && qualifier2 != null) {
                return qualifier1.compareTo(qualifier2);
            }
            return qualifier1 == NULL_QUALIFIERS[i] ? -1 : 1;
        }
        return 0;
    }

    public <T extends Configurable> T findMatchingConfigurable(List<T> configurables) {
        List<T> matches = this.findMatchingConfigurables(configurables);
        return (T)(matches.isEmpty() ? null : (Configurable)matches.get(0));
    }

    public <T extends Configurable> List<T> findMatchingConfigurables(List<T> configurables) {
        if (configurables == null) {
            return Collections.emptyList();
        }
        ArrayList<Configurable> matchingConfigurables = new ArrayList<Configurable>();
        for (Configurable res : configurables) {
            FolderConfiguration configuration = res.getConfiguration();
            if (configuration == null || !configuration.isMatchFor(this)) continue;
            matchingConfigurables.add(res);
        }
        if (matchingConfigurables.size() < 2) {
            return matchingConfigurables;
        }
        int count = FolderConfiguration.getQualifierCount();
        for (int q = 0; q < count; ++q) {
            ResourceQualifier referenceQualifier = this.getQualifier(q);
            if (referenceQualifier == NULL_QUALIFIERS[q] || referenceQualifier == null) continue;
            boolean found = false;
            ResourceQualifier bestMatch = null;
            for (Configurable configurable : matchingConfigurables) {
                ResourceQualifier qualifier = configurable.getConfiguration().getQualifier(q);
                if (qualifier == null) continue;
                found = true;
                if (!qualifier.isBetterMatchThan(bestMatch, referenceQualifier)) continue;
                bestMatch = qualifier;
            }
            if (!found) continue;
            int i = 0;
            while (i < matchingConfigurables.size()) {
                Configurable configurable;
                configurable = (Configurable)matchingConfigurables.get(i);
                FolderConfiguration configuration = configurable.getConfiguration();
                ResourceQualifier qualifier = configuration.getQualifier(q);
                if (qualifier == null) {
                    matchingConfigurables.remove(configurable);
                    continue;
                }
                if (bestMatch != null && !bestMatch.equals(qualifier)) {
                    matchingConfigurables.remove(configurable);
                    continue;
                }
                ++i;
            }
            if (matchingConfigurables.size() < 2) break;
        }
        return matchingConfigurables;
    }

    public boolean isMatchFor(FolderConfiguration referenceConfig) {
        if (referenceConfig == null) {
            return false;
        }
        for (int i = 0; i < 23; ++i) {
            ResourceQualifier testQualifier = this.mQualifiers[i];
            ResourceQualifier referenceQualifier = referenceConfig.mQualifiers[i];
            if (testQualifier == null || testQualifier == testQualifier.getNullQualifier() || referenceQualifier == null || referenceQualifier == referenceQualifier.getNullQualifier() || testQualifier.isMatchFor(referenceQualifier)) continue;
            return false;
        }
        return true;
    }

    public int getHighestPriorityQualifier(int startIndex) {
        for (int i = startIndex; i < 23; ++i) {
            if (this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            return i;
        }
        return -1;
    }

    public void createDefault() {
        this.mQualifiers[0] = new CountryCodeQualifier();
        this.mQualifiers[1] = new NetworkCodeQualifier();
        this.mQualifiers[2] = new LocaleQualifier();
        this.mQualifiers[3] = new LayoutDirectionQualifier();
        this.mQualifiers[4] = new SmallestScreenWidthQualifier();
        this.mQualifiers[5] = new ScreenWidthQualifier();
        this.mQualifiers[6] = new ScreenHeightQualifier();
        this.mQualifiers[7] = new ScreenSizeQualifier();
        this.mQualifiers[8] = new ScreenRatioQualifier();
        this.mQualifiers[9] = new ScreenRoundQualifier();
        this.mQualifiers[10] = new WideGamutColorQualifier();
        this.mQualifiers[11] = new HighDynamicRangeQualifier();
        this.mQualifiers[12] = new ScreenOrientationQualifier();
        this.mQualifiers[13] = new UiModeQualifier();
        this.mQualifiers[14] = new NightModeQualifier();
        this.mQualifiers[15] = new DensityQualifier();
        this.mQualifiers[16] = new TouchScreenQualifier();
        this.mQualifiers[17] = new KeyboardStateQualifier();
        this.mQualifiers[18] = new TextInputMethodQualifier();
        this.mQualifiers[19] = new NavigationStateQualifier();
        this.mQualifiers[20] = new NavigationMethodQualifier();
        this.mQualifiers[21] = new ScreenDimensionQualifier();
        this.mQualifiers[22] = new VersionQualifier();
        this.mQualifierString = null;
    }

    public ResourceQualifier[] getQualifiers() {
        int count = 0;
        for (int i = 0; i < 23; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            ++count;
        }
        ResourceQualifier[] array = new ResourceQualifier[count];
        int index = 0;
        for (int i = 0; i < 23; ++i) {
            if (this.mQualifiers[i] == null || this.mQualifiers[i] == NULL_QUALIFIERS[i]) continue;
            array[index++] = this.mQualifiers[i];
        }
        return array;
    }

    static {
        QUALIFIER_SPLITTER = Splitter.on((char)'-');
        NULL_QUALIFIERS = new ResourceQualifier[23];
        FolderConfiguration defaultConfig = new FolderConfiguration();
        defaultConfig.createDefault();
        DEFAULT_QUALIFIERS = defaultConfig.mQualifiers;
        for (int i = 0; i < DEFAULT_QUALIFIERS.length; ++i) {
            FolderConfiguration.NULL_QUALIFIERS[i] = DEFAULT_QUALIFIERS[i].getNullQualifier();
        }
    }
}

