/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.ResourceNamespaces;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.Table;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NamespaceAwareTable<C, V>
extends ForwardingTable<String, C, V> {
    private final Table<String, C, V> delegate;

    private static Object getNamespaceKey(Object namespace) {
        return namespace == null ? ResourceNamespaces.normalizeNamespace(null) : namespace;
    }

    public NamespaceAwareTable(Table<String, C, V> delegate) {
        this.delegate = delegate;
    }

    protected Table<String, C, V> delegate() {
        return this.delegate;
    }

    public boolean contains(Object namespace, Object resourceType) {
        return super.contains(NamespaceAwareTable.getNamespaceKey(namespace), resourceType);
    }

    public boolean containsRow(Object namespace) {
        return super.containsRow(NamespaceAwareTable.getNamespaceKey(namespace));
    }

    public V get(Object namespace, Object resourceType) {
        return (V)super.get(NamespaceAwareTable.getNamespaceKey(namespace), resourceType);
    }

    public V put(String namespace, C resourceType, V value) {
        return (V)super.put((Object)ResourceNamespaces.normalizeNamespace(namespace), resourceType, value);
    }

    public V remove(Object namespace, Object resourceType) {
        return (V)super.remove(NamespaceAwareTable.getNamespaceKey(namespace), resourceType);
    }

    public Map<C, V> row(String namespace) {
        return super.row((Object)ResourceNamespaces.normalizeNamespace(namespace));
    }

    public Set<String> rowKeySet() {
        return super.rowKeySet().stream().map(ResourceNamespaces::normalizeNamespace).collect(Collectors.toSet());
    }
}

