/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.gradle.model;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.ide.common.gradle.model.IdeAndroidLibrary;
import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeJavaLibrary;
import com.android.ide.common.gradle.model.IdeModel;
import com.android.ide.common.gradle.model.IdeProjectIdentifierImpl;
import com.android.ide.common.gradle.model.ModelCache;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

public final class IdeDependenciesImpl
extends IdeModel
implements IdeDependencies {
    private static final long serialVersionUID = 2L;
    private final Collection<AndroidLibrary> myLibraries;
    private final Collection<JavaLibrary> myJavaLibraries;
    private final Collection<String> myProjects;
    private final Collection<Dependencies.ProjectIdentifier> myJavaModules;
    private final int myHashCode;

    public IdeDependenciesImpl(Dependencies dependencies, ModelCache modelCache, GradleVersion modelVersion) {
        super(dependencies, modelCache);
        this.myLibraries = IdeDependenciesImpl.copy(dependencies.getLibraries(), modelCache, (K library) -> new IdeAndroidLibrary((AndroidLibrary)library, modelCache));
        this.myJavaLibraries = IdeDependenciesImpl.copy(dependencies.getJavaLibraries(), modelCache, (K library) -> new IdeJavaLibrary((JavaLibrary)library, modelCache));
        this.myProjects = ImmutableList.copyOf((Collection)dependencies.getProjects());
        this.myJavaModules = IdeDependenciesImpl.copy(() -> ((Dependencies)dependencies).getJavaModules(), modelCache, (K projectId) -> new IdeProjectIdentifierImpl((Dependencies.ProjectIdentifier)projectId, modelCache));
        this.myHashCode = this.calculateHashCode();
    }

    public Collection<AndroidLibrary> getLibraries() {
        return this.myLibraries;
    }

    public Collection<JavaLibrary> getJavaLibraries() {
        return this.myJavaLibraries;
    }

    public Collection<String> getProjects() {
        return this.myProjects;
    }

    public Collection<Dependencies.ProjectIdentifier> getJavaModules() {
        return this.myJavaModules;
    }

    @Override
    public void forEachLibrary(Consumer<IdeAndroidLibrary> action) {
        for (AndroidLibrary library : this.myLibraries) {
            action.accept((IdeAndroidLibrary)library);
        }
    }

    @Override
    public void forEachJavaLibrary(Consumer<IdeJavaLibrary> action) {
        for (JavaLibrary library : this.myJavaLibraries) {
            action.accept((IdeJavaLibrary)library);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeDependenciesImpl)) {
            return false;
        }
        IdeDependenciesImpl that = (IdeDependenciesImpl)o;
        return Objects.equals(this.myLibraries, that.myLibraries) && Objects.equals(this.myJavaLibraries, that.myJavaLibraries) && Objects.equals(this.myProjects, that.myProjects) && Objects.equals(this.myJavaModules, that.myJavaModules);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private int calculateHashCode() {
        return Objects.hash(this.myLibraries, this.myJavaLibraries, this.myProjects, this.myJavaModules);
    }

    public String toString() {
        return "IdeDependencies{myLibraries=" + this.myLibraries + ", myJavaLibraries=" + this.myJavaLibraries + ", myProjects=" + this.myProjects + ", myJavaModules=" + this.myJavaModules + '}';
    }
}

