/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import java.util.Collection;

public class SimpleRepositorySource
implements RepositorySource {
    private final String mUrl;
    private final String mDisplayName;
    private boolean mEnabled;
    private final Collection<SchemaModule<?>> mAllowedModules;
    private String mError;
    private final RepositorySourceProvider mProvider;

    public SimpleRepositorySource(String url, String displayName, boolean enabled, Collection<SchemaModule<?>> allowedModules, RepositorySourceProvider provider) {
        this.mProvider = provider;
        this.mUrl = url.trim();
        this.mDisplayName = displayName;
        this.mEnabled = enabled;
        this.mAllowedModules = allowedModules;
    }

    @Override
    public Collection<SchemaModule<?>> getPermittedModules() {
        return this.mAllowedModules;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getProvider().isModifiable()) {
            this.mEnabled = enabled;
        }
    }

    @Override
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Override
    public String getUrl() {
        return this.mUrl;
    }

    public String toString() {
        return String.format("<RepositorySource URL='%1$s' Name='%2$s'>", this.mUrl, this.mDisplayName);
    }

    @Override
    public void setFetchError(String error) {
        this.mError = error;
    }

    @Override
    public String getFetchError() {
        return this.mError;
    }

    @Override
    public RepositorySourceProvider getProvider() {
        return this.mProvider;
    }
}

