/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;

public abstract class AbstractInstallerFactory
implements InstallerFactory {
    private InstallerFactory.StatusChangeListenerFactory mListenerFactory;
    protected InstallerFactory mFallbackFactory;

    @Override
    public void setFallbackFactory(InstallerFactory fallback) {
        this.mFallbackFactory = fallback;
        if (this.mFallbackFactory != null && this.mListenerFactory != null) {
            this.mFallbackFactory.setListenerFactory(this.mListenerFactory);
        }
    }

    @Override
    public void setListenerFactory(InstallerFactory.StatusChangeListenerFactory listenerFactory) {
        this.mListenerFactory = listenerFactory;
        if (this.mFallbackFactory != null) {
            this.mFallbackFactory.setListenerFactory(listenerFactory);
        }
    }

    @Override
    public final Installer createInstaller(RemotePackage remote, RepoManager mgr, Downloader downloader) {
        if (!this.canHandlePackage(remote, mgr) && this.mFallbackFactory != null) {
            return this.mFallbackFactory.createInstaller(remote, mgr, downloader);
        }
        Installer installer = this.doCreateInstaller(remote, mgr, downloader);
        if (this.mFallbackFactory != null) {
            installer.setFallbackOperation(this.mFallbackFactory.createInstaller(remote, mgr, downloader));
        }
        this.registerListeners(installer);
        return installer;
    }

    private void registerListeners(PackageOperation op) {
        if (this.mListenerFactory != null) {
            for (PackageOperation.StatusChangeListener listener : this.mListenerFactory.createListeners(op.getPackage())) {
                op.registerStateChangeListener(listener);
            }
        }
    }

    protected abstract Installer doCreateInstaller(RemotePackage var1, RepoManager var2, Downloader var3);

    @Override
    public final Uninstaller createUninstaller(LocalPackage local, RepoManager mgr) {
        if (!this.canHandlePackage(local, mgr) && this.mFallbackFactory != null) {
            return this.mFallbackFactory.createUninstaller(local, mgr);
        }
        Uninstaller uninstaller = this.doCreateUninstaller(local, mgr);
        if (this.mFallbackFactory != null) {
            uninstaller.setFallbackOperation(this.mFallbackFactory.createUninstaller(local, mgr));
        }
        this.registerListeners(uninstaller);
        return uninstaller;
    }

    protected abstract Uninstaller doCreateUninstaller(LocalPackage var1, RepoManager var2);

    protected boolean canHandlePackage(RepoPackage pack, RepoManager manager) {
        return true;
    }
}

