/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.ProgressIndicatorAdapter;
import com.google.common.annotations.VisibleForTesting;
import java.io.PrintStream;

public class ConsoleProgressIndicator
extends ProgressIndicatorAdapter {
    private static final int PROGRESS_WIDTH = 40;
    private static final int MAX_WIDTH = 80;
    private String mText = "";
    private String mSecondaryText = "";
    private double mProgress = 0.0;
    private PrintStream mOut;
    private PrintStream mErr;
    private final boolean mDumb;
    private String mLast = null;
    private static final String SPACES = "                                                                                ";

    public ConsoleProgressIndicator() {
        this(System.out, System.err);
    }

    public ConsoleProgressIndicator(PrintStream out, PrintStream err) {
        this(out, err, "dumb".equals(System.getenv("TERM")));
    }

    @VisibleForTesting
    ConsoleProgressIndicator(PrintStream out, PrintStream err, boolean dumb) {
        this.mOut = out;
        this.mErr = err;
        this.mDumb = dumb;
    }

    public void setOut(PrintStream out) {
        this.mOut = out;
    }

    public void setErr(PrintStream err) {
        this.mErr = err;
    }

    @Override
    public double getFraction() {
        return this.mProgress;
    }

    @Override
    public void setFraction(double progress) {
        this.mProgress = progress;
        this.printStatusLine(true);
    }

    private void printStatusLine(boolean forceShowProgress) {
        if (this.mDumb) {
            return;
        }
        StringBuilder line = new StringBuilder();
        if (forceShowProgress || this.getFraction() > 0.0) {
            line.append("[");
            int i = 1;
            while ((double)i < 40.0 * this.mProgress) {
                line.append("=");
                ++i;
            }
            while (i < 40) {
                line.append(" ");
                ++i;
            }
            line.append("] ");
            line.append(String.format("%.0f%%", 100.0 * this.mProgress));
            line.append(" ");
        }
        line.append(this.mText);
        line.append(" ");
        line.append(this.mSecondaryText);
        if (line.length() > 80) {
            line.delete(80, line.length());
        } else {
            line.append(SPACES.substring(0, 80 - line.length()));
        }
        line.append("\r");
        String result = line.toString();
        if (!result.equals(this.mLast)) {
            this.mOut.print(result);
            this.mOut.flush();
            this.mLast = result;
        }
    }

    private void logMessage(String s, Throwable e, PrintStream stream) {
        if (this.mProgress > 0.0) {
            this.mOut.print(SPACES);
            this.mOut.print("\r");
            this.mLast = null;
        }
        stream.println(s);
        if (e != null) {
            e.printStackTrace();
        }
        if (this.mProgress > 0.0) {
            this.printStatusLine(false);
        }
    }

    @Override
    public void logWarning(String s, Throwable e) {
        this.logMessage("Warning: " + s, e, this.mErr);
    }

    @Override
    public void logError(String s, Throwable e) {
        this.logMessage("Error: " + s, e, this.mErr);
    }

    @Override
    public void logInfo(String s) {
        this.logMessage("Info: " + s, null, this.mOut);
    }

    @Override
    public void setText(String text) {
        this.mText = text;
        this.printStatusLine(false);
    }

    @Override
    public void setSecondaryText(String text) {
        this.mSecondaryText = text;
        this.printStatusLine(false);
    }
}

