/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.Dependency;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RepoPackageImpl;
import java.io.File;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class LocalPackageImpl
extends RepoPackageImpl
implements LocalPackage {
    @XmlTransient
    private File mInstalledPath;

    @Override
    public File getLocation() {
        return this.mInstalledPath;
    }

    @Override
    public void setInstalledPath(File path) {
        this.mInstalledPath = path;
    }

    public static LocalPackageImpl create(RepoPackage repoPackage) {
        if (repoPackage instanceof LocalPackageImpl) {
            return (LocalPackageImpl)repoPackage;
        }
        CommonFactory factory = RepoManager.getCommonModule().createLatestFactory();
        LocalPackageImpl result = factory.createLocalPackage();
        result.setVersion(repoPackage.getVersion());
        result.setLicense(repoPackage.getLicense());
        result.setPath(repoPackage.getPath());
        for (Dependency d : repoPackage.getAllDependencies()) {
            Dependency newDep = factory.createDependencyType();
            newDep.setPath(d.getPath());
            newDep.setMinRevision(d.getMinRevision());
            result.addDependency(newDep);
        }
        result.setObsolete(repoPackage.obsolete());
        result.setTypeDetails(repoPackage.getTypeDetails());
        result.setDisplayName(repoPackage.getDisplayName());
        return result;
    }

    @Override
    public RepoPackageImpl asMarshallable() {
        return this;
    }

    @Override
    public void addTo(Repository repo) {
        repo.setLocalPackage(this);
    }
}

