/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URL;

class BasicInstaller
extends AbstractInstaller {
    static final String FN_UNZIP_DIR = "unzip";
    private File myUnzipDir;

    BasicInstaller(RemotePackage p, RepoManager mgr, Downloader downloader, FileOp fop) {
        super(p, mgr, downloader, fop);
    }

    @Override
    protected boolean doPrepare(File installTempPath, ProgressIndicator progress) {
        URL url = InstallerUtil.resolveCompleteArchiveUrl(this.getPackage(), progress);
        if (url == null) {
            progress.logWarning("No compatible archive found!");
            return false;
        }
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        try {
            String path = url.getPath();
            File downloadLocation = new File(installTempPath, path.substring(path.lastIndexOf(47) + 1));
            String checksum = archive.getComplete().getChecksum();
            this.getDownloader().downloadFullyWithCaching(url, downloadLocation, checksum, progress.createSubProgress(0.5));
            if (progress.isCanceled()) {
                progress.setFraction(1.0);
                return false;
            }
            progress.setFraction(0.5);
            if (!this.mFop.exists(downloadLocation)) {
                progress.logWarning("Failed to download package!");
                return false;
            }
            this.myUnzipDir = new File(installTempPath, FN_UNZIP_DIR);
            this.mFop.mkdirs(this.myUnzipDir);
            InstallerUtil.unzip(downloadLocation, this.myUnzipDir, this.mFop, archive.getComplete().getSize(), progress.createSubProgress(1.0));
            progress.setFraction(1.0);
            if (progress.isCanceled()) {
                return false;
            }
            this.mFop.delete(downloadLocation);
            return true;
        }
        catch (IOException e) {
            String message = e.getMessage();
            progress.logWarning(String.format("An error occurred while preparing SDK package %1$s%2$s", this.getPackage().getDisplayName(), Strings.isNullOrEmpty((String)message) ? "." : ": " + message + "."), e);
            return false;
        }
    }

    @Override
    protected void cleanup(ProgressIndicator progress) {
        super.cleanup(progress);
        this.mFop.deleteFileOrFolder(this.getLocation(progress));
        if (this.myUnzipDir != null) {
            this.mFop.deleteFileOrFolder(this.myUnzipDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doComplete(File installTempPath, ProgressIndicator progress) {
        if (installTempPath == null) {
            return false;
        }
        try {
            if (progress.isCanceled()) {
                boolean bl = false;
                return bl;
            }
            File unzipDir = new File(installTempPath, FN_UNZIP_DIR);
            File[] topDirContents = this.mFop.listFiles(unzipDir);
            File packageRoot = topDirContents.length != 1 ? unzipDir : topDirContents[0];
            progress.logInfo(String.format("Installing %1$s in %2$s", this.getPackage().getDisplayName(), this.getLocation(progress)));
            FileOpUtils.safeRecursiveOverwrite(packageRoot, this.getLocation(progress), this.mFop, progress);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            String message = e.getMessage();
            progress.logWarning("An error occurred during installation" + (message.isEmpty() ? "." : ": " + message + "."), e);
        }
        finally {
            progress.setFraction(1.0);
        }
        return false;
    }
}

