/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.uast.UFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/infrastructure/WhitespaceTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "transformMessage", "message", "lint-tests"})
public final class WhitespaceTestMode
extends UastSourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n        The user is allowed to add extra or\n        unnecessary whitespace through their code. This test mode adds a lot of\n        unnecessary whitespace to catch bugs where detectors are incorrectly\n        making guesses about offsets assuming \"normal\" spacing, as well as\n        to catch issues where quickfixes are incorrectly handling space such\n        as making assumptions like element.asSourceString() being equal to\n        the underlying source code.\n\n        In the unlikely event that your lint check is actually doing something\n        whitespace specific, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));

    public WhitespaceTestMode() {
        super("Extra whitespace added", "TestMode.WHITESPACE", "whitespace");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        Ref.IntRef ordinal = new Ref.IntRef();
        Map editMap = new LinkedHashMap();
        root.getSourcePsi().accept((PsiElementVisitor)new PsiRecursiveElementVisitor(editMap, ordinal){
            final /* synthetic */ Map<Integer, Edit> $editMap;
            final /* synthetic */ Ref.IntRef $ordinal;
            {
                this.$editMap = $editMap;
                this.$ordinal = $ordinal;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement next = element.getNextSibling();
                if (element instanceof KtContainerNode && Intrinsics.areEqual((Object)((KtContainerNode)element).getNode().getElementType(), (Object)KtNodeTypes.LABEL_QUALIFIER) || next instanceof KtContainerNode && Intrinsics.areEqual((Object)((KtContainerNode)next).getNode().getElementType(), (Object)KtNodeTypes.LABEL_QUALIFIER)) {
                    return;
                }
                this.checkElement(element);
                PsiElement psiElement = element;
                if (((((((((psiElement instanceof PsiComment ? true : psiElement instanceof PsiWhiteSpace) ? true : psiElement instanceof KtStringTemplateExpression) ? true : psiElement instanceof KtAnnotationEntry) ? true : psiElement instanceof KtAnnotation) ? true : psiElement instanceof PsiAnnotation) ? true : psiElement instanceof PsiImportList) ? true : psiElement instanceof KtImportList) ? true : psiElement instanceof PsiPackageStatement) ? true : psiElement instanceof KtPackageDirective) {
                    return;
                }
                if (psiElement instanceof KtPrefixExpression ? Intrinsics.areEqual((Object)((KtPrefixExpression)element).getOperationToken(), (Object)KtTokens.MINUS) && ((KtPrefixExpression)element).getBaseExpression() instanceof KtConstantExpression : psiElement instanceof PsiPrefixExpression && Intrinsics.areEqual((Object)((PsiPrefixExpression)element).getOperationTokenType(), (Object)JavaTokenType.MINUS) && ((PsiPrefixExpression)element).getOperand() instanceof PsiLiteralExpression) {
                    return;
                }
                super.visitElement(element);
            }

            private final void checkElement(PsiElement element) {
                TextRange range = element.getTextRange();
                WhitespaceTestMode.access$transform$insert(this.$editMap, this.$ordinal, range.getStartOffset());
                WhitespaceTestMode.access$transform$insert(this.$editMap, this.$ordinal, range.getEndOffset());
            }
        });
        return CollectionsKt.toMutableList((Collection)CollectionsKt.sorted((Iterable)editMap.values()));
    }

    @Override
    @NotNull
    public String transformMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CharSequence charSequence = message;
        Regex regex = new Regex("\\s+");
        String string = "";
        return regex.replace(charSequence, string);
    }

    private static final void transform$insert(Map<Integer, Edit> editMap, Ref.IntRef ordinal, int offset) {
        Map<Integer, Edit> map = editMap;
        Integer n = offset;
        int n2 = ordinal.element;
        ordinal.element = n2 + 1;
        Edit edit = new Edit(offset, offset, " ", true, n2);
        map.put(n, edit);
    }

    public static final /* synthetic */ void access$transform$insert(Map editMap, Ref.IntRef ordinal, int offset) {
        WhitespaceTestMode.transform$insert(editMap, ordinal, offset);
    }
}

