/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.FullyQualifyNamesTestMode;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TypeAliasTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "isRelevantFile", "", "file", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "messagesMatch", "original", "modified", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "PackageAliases", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nTypeAliasTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeAliasTestMode.kt\ncom/android/tools/lint/checks/infrastructure/TypeAliasTestMode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
public final class TypeAliasTestMode
extends UastSourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n         In Kotlin, types can be renamed\n        via type aliases. This means that detectors should look at the\n        resolved types, not the local identifier names.\n\n        This test mode introduces type aliases for all types accessed\n        from Kotlin source files and makes sure the test results are\n        unaffected.\n\n        In the unlikely event that your lint check is actually doing something\n        specific to type aliasing, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));

    public TypeAliasTestMode() {
        super("Type aliases", "TestMode.TYPE_ALIAS", "type-alias");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    protected boolean isRelevantFile(@NotNull TestFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.targetRelativePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
        return StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        if (!Lint.isKotlin((Language)root.getLang())) {
            return new ArrayList();
        }
        Map editMap = new LinkedHashMap();
        String pkg = root.getPackageName();
        Object object = clientData.get(TestMode.TYPE_ALIAS.getFolderName());
        Object object2 = object instanceof PackageAliases ? (PackageAliases)object : null;
        if (object2 == null) {
            Object it = object = new PackageAliases(0, null, 3, null);
            boolean bl = false;
            clientData.put(TestMode.TYPE_ALIAS.getFolderName(), it);
            object2 = object;
        }
        PackageAliases packageAliases = object2;
        Map<String, Map<String, String>> aliasesPerPackage = packageAliases.getAliasesPerPackage();
        LinkedHashMap<String, String> newAliases = new LinkedHashMap<String, String>();
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new FullyQualifyNamesTestMode.TypeVisitor(context, source2, aliasesPerPackage, pkg, packageAliases, newAliases, editMap){
            final /* synthetic */ String $source;
            final /* synthetic */ Map<String, Map<String, String>> $aliasesPerPackage;
            final /* synthetic */ String $pkg;
            final /* synthetic */ PackageAliases $packageAliases;
            final /* synthetic */ LinkedHashMap<String, String> $newAliases;
            final /* synthetic */ Map<Integer, Edit> $editMap;
            {
                this.$source = $source;
                this.$aliasesPerPackage = $aliasesPerPackage;
                this.$pkg = $pkg;
                this.$packageAliases = $packageAliases;
                this.$newAliases = $newAliases;
                this.$editMap = $editMap;
                super($context, $source);
            }

            private final String getTypeAlias(String typeText) {
                Map packageMap;
                Object object;
                Object object2;
                Map map = this.$aliasesPerPackage.get(this.$pkg);
                if (map == null) {
                    object2 = new LinkedHashMap<K, V>();
                    Map<String, Map<String, String>> map2 = this.$aliasesPerPackage;
                    String string = this.$pkg;
                    Object it = object2;
                    boolean bl = false;
                    map2.put(string, (Map<String, String>)it);
                    map = (Map)object2;
                }
                if ((object = (packageMap = map).get(typeText)) == null) {
                    object2 = this.$packageAliases;
                    int n = ((PackageAliases)object2).getNextAliasId();
                    ((PackageAliases)object2).setNextAliasId(n + 1);
                    object2 = "TYPE_ALIAS_" + n;
                    LinkedHashMap<String, String> linkedHashMap = this.$newAliases;
                    Object it = object2;
                    boolean bl = false;
                    packageMap.put(typeText, it);
                    ((Map)linkedHashMap).put(typeText, it);
                    object = object2;
                }
                return object;
            }

            public boolean visitAnnotation(@NotNull UAnnotation node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void checkTypeReference(@NotNull UElement node, @Nullable PsiClass cls, int offset, @NotNull PsiType type) {
                void var13_13;
                PsiClass parent;
                PsiElement next;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                PsiClass psiClass = cls;
                if ((psiClass != null ? psiClass.getContainingClass() : null) != null) {
                    return;
                }
                PsiElement psiElement = node.getSourcePsi();
                if (psiElement == null) return;
                TextRange textRange = psiElement.getTextRange();
                if (textRange == null) {
                    return;
                }
                TextRange range = textRange;
                int start = range.getStartOffset();
                int end = 0;
                end = range.getEndOffset();
                PsiElement psiElement2 = node.getSourcePsi();
                Object object = psiElement2;
                if (psiElement2 == null) return;
                String string = object.getText();
                object = string;
                if (string == null) return;
                Object it = object;
                boolean bl = false;
                Object object2 = it;
                PsiElement psiElement4 = node.getSourcePsi();
                psiElement4 = psiElement4 != null && (psiElement3 = psiElement4.getParent()) != null ? psiElement4.getNextSibling() : (next = null);
                if (next instanceof KtTypeArgumentList) {
                    String wildcards = ((KtTypeArgumentList)next).getText();
                    String string2 = (String)object2 + wildcards;
                    end += wildcards.length();
                }
                PsiClass curr = cls;
                while (curr != null && (parent = curr.getContainingClass()) != null) {
                    curr = parent;
                    String string3 = curr.getName() + "." + (String)var13_13;
                }
                void v8 = var13_13;
                object = v8;
                if (v8 == null) {
                    return;
                }
                Object typeText = object;
                if (StringsKt.isBlank((CharSequence)((CharSequence)typeText))) return;
                if (type instanceof PsiEllipsisType) return;
                if (this.hasTypeParameter(type)) {
                    return;
                }
                switch (((String)typeText).hashCode()) {
                    case 1146952063: {
                        if (((String)typeText).equals("@Composable (() -> Unit)?")) return;
                        break;
                    }
                    case -1561179353: {
                        if (((String)typeText).equals("@Composable () -> Unit")) return;
                        break;
                    }
                    case 1461201605: {
                        if (!((String)typeText).equals("(@Composable () -> Unit)?")) break;
                        return;
                    }
                }
                String aliasName = this.getTypeAlias((String)typeText);
                Integer n = offset;
                this.$editMap.put(n, UastSourceTransformationTestMode.EditVisitor.replace$default(this, start, end, aliasName, false, 8, null));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean hasTypeParameter(PsiType $this$hasTypeParameter) {
                boolean bl;
                PsiType psiType = $this$hasTypeParameter;
                if (psiType instanceof PsiPrimitiveType) {
                    return false;
                }
                if (psiType instanceof PsiClassType) {
                    PsiType[] psiTypeArray = ((PsiClassType)$this$hasTypeParameter).getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
                    Object[] $this$any$iv = psiTypeArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiType it = (PsiType)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.hasTypeParameter(it)) continue;
                        return true;
                    }
                    boolean bl3 = false;
                    if (bl3) return true;
                    if (!(((PsiClassType)$this$hasTypeParameter).resolve() instanceof PsiTypeParameter)) return false;
                    return true;
                }
                if (psiType instanceof PsiWildcardType) {
                    if (((PsiWildcardType)$this$hasTypeParameter).isBounded()) {
                        boolean bl4;
                        PsiType psiType2 = ((PsiWildcardType)$this$hasTypeParameter).getBound();
                        if (psiType2 != null) {
                            if (this.hasTypeParameter(psiType2)) {
                                return true;
                            }
                            bl4 = false;
                        } else {
                            bl4 = false;
                        }
                        if (bl4) return true;
                    }
                    if (!((PsiWildcardType)$this$hasTypeParameter).isExtends()) return false;
                    PsiType psiType3 = ((PsiWildcardType)$this$hasTypeParameter).getExtendsBound();
                    Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"getExtendsBound(...)");
                    if (!this.hasTypeParameter(psiType3)) return false;
                    return true;
                }
                if (psiType instanceof PsiCapturedWildcardType) {
                    PsiType psiType4 = ((PsiCapturedWildcardType)$this$hasTypeParameter).getUpperBound();
                    Intrinsics.checkNotNullExpressionValue((Object)psiType4, (String)"getUpperBound(...)");
                    bl = this.hasTypeParameter(psiType4);
                    return bl;
                } else if (psiType instanceof PsiArrayType) {
                    PsiType psiType5 = ((PsiArrayType)$this$hasTypeParameter).getComponentType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiType5, (String)"getComponentType(...)");
                    bl = this.hasTypeParameter(psiType5);
                    return bl;
                } else {
                    PsiType it;
                    if (psiType instanceof PsiIntersectionType) {
                        PsiType[] psiTypeArray = ((PsiIntersectionType)$this$hasTypeParameter).getConjuncts();
                        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getConjuncts(...)");
                        Object[] $this$any$iv = psiTypeArray;
                        boolean $i$f$any = false;
                        int n = 0;
                        int n2 = $this$any$iv.length;
                        while (n < n2) {
                            Object element$iv = $this$any$iv[n];
                            PsiType it2 = (PsiType)element$iv;
                            boolean bl5 = false;
                            Intrinsics.checkNotNull((Object)it2);
                            if (this.hasTypeParameter(it2)) {
                                return true;
                            }
                            ++n;
                        }
                        return false;
                    }
                    if (!(psiType instanceof PsiDisjunctionType)) return false;
                    List list2 = ((PsiDisjunctionType)$this$hasTypeParameter).getDisjunctions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDisjunctions(...)");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator<T> iterator = $this$any$iv.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        T element$iv = iterator.next();
                        it = (PsiType)element$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNull((Object)it);
                    } while (!this.hasTypeParameter(it));
                    return true;
                }
            }

            protected boolean allowClassReference(@NotNull USimpleNameReferenceExpression node, @NotNull UQualifiedReferenceExpression parent) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                PsiElement psiElement = parent.resolve();
                if (psiElement == null) {
                    return false;
                }
                PsiElement parentResolved = psiElement;
                return parentResolved instanceof PsiField;
            }

            public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void afterVisitFile(@NotNull UFile node) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Map $this$map$iv = this.$newAliases;
                boolean $i$f$map = false;
                Object object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String type = (String)entry.getKey();
                    String name = (String)entry.getValue();
                    collection.add("typealias " + name + " = " + type);
                }
                String aliases = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                int end = this.$source.length();
                object = end;
                this.$editMap.put((Integer)object, UastSourceTransformationTestMode.EditVisitor.insert$default(this, end, "\n" + aliases, false, 4, null));
            }
        }));
        return CollectionsKt.toMutableList(editMap.values());
    }

    @Override
    public boolean messagesMatch(@NotNull String original, @NotNull String modified) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        if (Intrinsics.areEqual((Object)original, (Object)modified)) {
            return true;
        }
        int index = StringsKt.indexOf$default((CharSequence)modified, (String)"TYPE_ALIAS_", (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return false;
        }
        return StringsKt.regionMatches$default((String)original, (int)0, (String)modified, (int)0, (int)index, (boolean)false, (int)16, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012 \b\u0002\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\u0002\u0010\u0007R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TypeAliasTestMode$PackageAliases;", "", "nextAliasId", "", "aliasesPerPackage", "", "", "(ILjava/util/Map;)V", "getAliasesPerPackage", "()Ljava/util/Map;", "getNextAliasId", "()I", "setNextAliasId", "(I)V", "lint-tests"})
    public static final class PackageAliases {
        private int nextAliasId;
        @NotNull
        private final Map<String, Map<String, String>> aliasesPerPackage;

        public PackageAliases(int nextAliasId, @NotNull Map<String, Map<String, String>> aliasesPerPackage) {
            Intrinsics.checkNotNullParameter(aliasesPerPackage, (String)"aliasesPerPackage");
            this.nextAliasId = nextAliasId;
            this.aliasesPerPackage = aliasesPerPackage;
        }

        public /* synthetic */ PackageAliases(int n, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            if ((n2 & 2) != 0) {
                map = new LinkedHashMap();
            }
            this(n, map);
        }

        public final int getNextAliasId() {
            return this.nextAliasId;
        }

        public final void setNextAliasId(int n) {
            this.nextAliasId = n;
        }

        @NotNull
        public final Map<String, Map<String, String>> getAliasesPerPackage() {
            return this.aliasesPerPackage;
        }

        public PackageAliases() {
            this(0, null, 3, null);
        }
    }
}

