/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.ArgumentReorderingTestMode;
import com.android.tools.lint.checks.infrastructure.BodyRemovalTestMode;
import com.android.tools.lint.checks.infrastructure.BytecodeTestFile;
import com.android.tools.lint.checks.infrastructure.CharacterDataTestMode;
import com.android.tools.lint.checks.infrastructure.FullyQualifyNamesTestMode;
import com.android.tools.lint.checks.infrastructure.IfToWhenTestMode;
import com.android.tools.lint.checks.infrastructure.ImportAliasTestMode;
import com.android.tools.lint.checks.infrastructure.ModuleResourcesTestMode;
import com.android.tools.lint.checks.infrastructure.ParenthesisTestMode;
import com.android.tools.lint.checks.infrastructure.PartialTestMode;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.SuppressibleTestMode;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.TestResultState;
import com.android.tools.lint.checks.infrastructure.TypeAliasTestMode;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestModeGroup;
import com.android.tools.lint.checks.infrastructure.WhitespaceTestMode;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintListener;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003+,-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00000\"H\u0096\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000\u001e2\u0006\u0010\u001a\u001a\u00020\fH\u0016J \u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0003H\u0016J\b\u0010*\u001a\u00020\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R0\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestMode;", "", "description", "", "fieldName", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "diffExplanation", "getDiffExplanation", "eventListener", "Lkotlin/Function3;", "Lcom/android/tools/lint/checks/infrastructure/TestMode$TestModeContext;", "Lcom/android/tools/lint/client/api/LintListener$EventType;", "", "", "getEventListener", "()Lkotlin/jvm/functions/Function3;", "getFieldName", "folderName", "getFolderName", "modifiesSources", "", "getModifiesSources", "()Z", "after", "context", "applies", "before", "configureProjects", "", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "projects", "iterator", "", "partition", "sameOutput", "expected", "actual", "type", "Lcom/android/tools/lint/checks/infrastructure/TestMode$OutputKind;", "toString", "usePartialAnalysis", "Companion", "OutputKind", "TestModeContext", "lint-tests"})
public class TestMode
implements Iterable<TestMode>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    @NotNull
    private final String fieldName;
    @NotNull
    private final String folderName;
    @Nullable
    private final Function3<TestModeContext, LintListener.EventType, Object, Unit> eventListener;
    @Nullable
    private final String diffExplanation;
    private final boolean modifiesSources;
    @NotNull
    private static final Object CANCEL = new String("cancel");
    @JvmField
    @NotNull
    public static final TestMode DEFAULT = new TestMode("Default", "TestMode.DEFAULT");
    @JvmField
    @NotNull
    public static final TestMode BYTECODE_ONLY = new TestMode(){
        @NotNull
        private final String folderName;
        @NotNull
        private final String diffExplanation;
        {
            this.folderName = "bytecode";
            this.diffExplanation = "The unit test was re-run with only the bytecode from the `compiled()` test files,\nnot the sources, and the output did not match. This is sometimes expected (since\nit's common to include source details in error messages), and in those cases, you\ncan set the `testModes(...)` to include only one of these two, or turn off\nthe equality check altogether via `.expectIdenticalTestModeOutput(false)`.\nYou can then check each output by passing in a `testMode` parameter\nto `expect`(...).";
        }

        @NotNull
        public String getFolderName() {
            return this.folderName;
        }

        public boolean applies(@NotNull TestModeContext context) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Iterable $this$any$iv = context.getProjects();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        boolean bl2;
                        block4: {
                            ProjectDescription it = (ProjectDescription)element$iv;
                            boolean bl3 = false;
                            TestFile[] $this$any$iv2 = it.getFiles();
                            boolean $i$f$any2 = false;
                            int n = $this$any$iv2.length;
                            for (int i = 0; i < n; ++i) {
                                TestFile element$iv2;
                                TestFile file = element$iv2 = $this$any$iv2[i];
                                boolean bl4 = false;
                                if (!(file instanceof BytecodeTestFile && ((BytecodeTestFile)((Object)file)).getType() == BytecodeTestFile.Type.SOURCE_AND_BYTECODE)) continue;
                                bl2 = true;
                                break block4;
                            }
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Nullable
        public Object before(@NotNull TestModeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            com.android.tools.lint.checks.infrastructure.TestMode$Companion.deleteCompiledSources$default(TestMode.Companion, context.getProjects(), context, true, false, 8, null);
            return null;
        }

        @NotNull
        public String getDiffExplanation() {
            return this.diffExplanation;
        }
    };
    @JvmField
    @NotNull
    public static final TestMode SOURCE_ONLY = new TestMode(){
        @NotNull
        private final String folderName;
        @NotNull
        private final String diffExplanation;
        {
            this.folderName = "source";
            this.diffExplanation = "The unit test was re-run with only the source files from the `compiled()` test files,\nnot the bytecode, and the output did not match. This is sometimes expected,\nand in those cases, you can set the `testModes(...)` to include only one of these two,\nor turn off the equality check altogether via `.expectIdenticalTestModeOutput(false)`.\nYou can then check each output by passing in a `testMode` parameter\nto `expect`(...).";
        }

        @NotNull
        public String getFolderName() {
            return this.folderName;
        }

        public boolean applies(@NotNull TestModeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return TestMode.BYTECODE_ONLY.applies(context);
        }

        @Nullable
        public Object before(@NotNull TestModeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            com.android.tools.lint.checks.infrastructure.TestMode$Companion.deleteCompiledSources$default(TestMode.Companion, context.getProjects(), context, false, true, 4, null);
            return null;
        }

        @NotNull
        public String getDiffExplanation() {
            return this.diffExplanation;
        }
    };
    @JvmField
    @NotNull
    public static final TestMode RESOURCE_REPOSITORIES = new TestMode(){
        @NotNull
        private final String diffExplanation;
        {
            this.diffExplanation = "The unit test output varies whe using lint's resource\nrepository (optimized for lint's use-cases) and the AGP\nresource repository. This is a bug in lint. Please report it.";
        }

        public boolean applies(@NotNull TestModeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return context.getTask().requestedResourceRepository;
        }

        @Nullable
        public Object before(@NotNull TestModeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.getTask().forceAgpResourceRepository = true;
            return null;
        }

        public void after(@NotNull TestModeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.getTask().forceAgpResourceRepository = false;
        }

        @NotNull
        public String getDiffExplanation() {
            return this.diffExplanation;
        }

        public boolean sameOutput(@NotNull String expected, @NotNull String actual, @NotNull OutputKind type) {
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return super.sameOutput(this.transformOutput(expected), this.transformOutput(actual), type);
        }

        @NotNull
        public final String transformOutput(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return this.trimLines(StringsKt.replace$default((String)s, (String)"~", (String)"", (boolean)false, (int)4, null));
        }

        private final String trimLines(String $this$trimLines) {
            return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)$this$trimLines), (Function1)Companion.RESOURCE_REPOSITORIES.trimLines.1.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }
    };
    @JvmField
    @NotNull
    public static final TestMode PARTIAL = new PartialTestMode();
    @JvmField
    @NotNull
    public static final TestMode MODULE_RESOURCES = new ModuleResourcesTestMode();
    @JvmField
    @NotNull
    public static final TestMode SUPPRESSIBLE = new SuppressibleTestMode();
    @JvmField
    @NotNull
    public static final TestMode PARENTHESIZED = new ParenthesisTestMode(false, 1, null);
    @JvmField
    @NotNull
    public static final TestMode FULLY_QUALIFIED = new FullyQualifyNamesTestMode();
    @JvmField
    @NotNull
    public static final TestMode REORDER_ARGUMENTS = new ArgumentReorderingTestMode();
    @JvmField
    @NotNull
    public static final TestMode BODY_REMOVAL = new BodyRemovalTestMode();
    @JvmField
    @NotNull
    public static final TestMode TYPE_ALIAS = new TypeAliasTestMode();
    @JvmField
    @NotNull
    public static final TestMode IMPORT_ALIAS = new ImportAliasTestMode();
    @JvmField
    @NotNull
    public static final TestMode WHITESPACE = new WhitespaceTestMode();
    @JvmField
    @NotNull
    public static final TestMode IF_TO_WHEN = new IfToWhenTestMode();
    @JvmField
    @NotNull
    public static final TestMode CDATA = new CharacterDataTestMode();
    @JvmField
    @NotNull
    public static final TestMode SOURCE_TRANSFORMATION_GROUP;

    public TestMode(@NotNull String description2, @NotNull String fieldName2) {
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)fieldName2, (String)"fieldName");
        this.description = description2;
        this.fieldName = fieldName2;
        this.folderName = "default";
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public String getFolderName() {
        return this.folderName;
    }

    public boolean applies(@NotNull TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return true;
    }

    @Nullable
    public Object before(@NotNull TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    public void after(@NotNull TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    @Nullable
    public Function3<TestModeContext, LintListener.EventType, Object, Unit> getEventListener() {
        return this.eventListener;
    }

    @Nullable
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    public boolean getModifiesSources() {
        return this.modifiesSources;
    }

    @Override
    @NotNull
    public Iterator<TestMode> iterator() {
        return Companion.values().iterator();
    }

    @NotNull
    public String toString() {
        return this.getDescription();
    }

    public boolean usePartialAnalysis() {
        return false;
    }

    public boolean sameOutput(@NotNull String expected, @NotNull String actual, @NotNull OutputKind type) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return Intrinsics.areEqual((Object)expected, (Object)actual);
    }

    @NotNull
    public List<TestMode> partition(@NotNull TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public List<ProjectDescription> configureProjects(@NotNull List<ProjectDescription> projects) {
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        return projects;
    }

    @JvmStatic
    @NotNull
    public static final List<TestMode> values() {
        return Companion.values();
    }

    static {
        TestMode[] testModeArray = new TestMode[]{PARENTHESIZED, FULLY_QUALIFIED, REORDER_ARGUMENTS, BODY_REMOVAL, TYPE_ALIAS, IMPORT_ALIAS, IF_TO_WHEN, WHITESPACE};
        SOURCE_TRANSFORMATION_GROUP = new UastSourceTransformationTestModeGroup(testModeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ0\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00192\b\b\u0002\u0010%\u001a\u00020\u0019J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'H\u0007J\n\u0010\u0018\u001a\u00020\u0019*\u00020(R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestMode$Companion;", "", "()V", "BODY_REMOVAL", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "BYTECODE_ONLY", "CANCEL", "getCANCEL", "()Ljava/lang/Object;", "CDATA", "DEFAULT", "FULLY_QUALIFIED", "IF_TO_WHEN", "IMPORT_ALIAS", "MODULE_RESOURCES", "PARENTHESIZED", "PARTIAL", "REORDER_ARGUMENTS", "RESOURCE_REPOSITORIES", "SOURCE_ONLY", "SOURCE_TRANSFORMATION_GROUP", "SUPPRESSIBLE", "TYPE_ALIAS", "WHITESPACE", "classOnly", "", "set", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "deleteCompiledSources", "", "projects", "", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "context", "Lcom/android/tools/lint/checks/infrastructure/TestMode$TestModeContext;", "deleteSourceFiles", "deleteBinaryFiles", "values", "", "Lcom/android/tools/lint/detector/api/Implementation;", "lint-tests"})
    @SourceDebugExtension(value={"SMAP\nTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestMode.kt\ncom/android/tools/lint/checks/infrastructure/TestMode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,376:1\n1726#2,3:377\n1747#2,3:384\n12271#3,2:380\n12271#3,2:382\n*S KotlinDebug\n*F\n+ 1 TestMode.kt\ncom/android/tools/lint/checks/infrastructure/TestMode$Companion\n*L\n113#1:377,3\n147#1:384,3\n119#1:380,2\n134#1:382,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getCANCEL() {
            return CANCEL;
        }

        public final boolean classOnly(@NotNull EnumSet<Scope> set) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(set, (String)"set");
                Iterable $this$all$iv = set;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Scope it = (Scope)element$iv;
                        boolean bl2 = false;
                        if (it == Scope.CLASS_FILE || it == Scope.JAVA_LIBRARIES || it == Scope.ALL_CLASS_FILES) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean classOnly(@NotNull Implementation $this$classOnly) {
            Intrinsics.checkNotNullParameter((Object)$this$classOnly, (String)"<this>");
            EnumSet enumSet = $this$classOnly.getScope();
            Intrinsics.checkNotNullExpressionValue((Object)enumSet, (String)"getScope(...)");
            if (!this.classOnly(enumSet)) return false;
            EnumSet[] enumSetArray = $this$classOnly.getAnalysisScopes();
            Intrinsics.checkNotNullExpressionValue((Object)enumSetArray, (String)"getAnalysisScopes(...)");
            Object[] $this$all$iv = enumSetArray;
            boolean $i$f$all = false;
            int n = 0;
            int n2 = $this$all$iv.length;
            while (n < n2) {
                Object element$iv = $this$all$iv[n];
                EnumSet it = (EnumSet)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Companion.classOnly(it)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public final void deleteCompiledSources(@NotNull Collection<ProjectDescription> projects, @NotNull TestModeContext context, boolean deleteSourceFiles, boolean deleteBinaryFiles) {
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            for (ProjectDescription project : projects) {
                block18: {
                    block17: {
                        boolean bl;
                        block15: {
                            if (context.getTask().issues == null) break block17;
                            Intrinsics.checkNotNullExpressionValue((Object)context.getTask().issues, (String)"issues");
                            Object[] $this$all$iv = context.getTask().issues;
                            boolean $i$f$all = false;
                            for (Object element$iv : $this$all$iv) {
                                Issue it = (Issue)element$iv;
                                boolean bl2 = false;
                                if (Companion.classOnly(it.getImplementation())) continue;
                                bl = false;
                                break block15;
                            }
                            bl = true;
                        }
                        if (!bl) break block18;
                    }
                    return;
                }
                Object[] projectFiles = project.getFiles();
                int n = projectFiles.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    List<String> classFiles;
                    List<TestFile> sources;
                    TestFile file;
                    block16: {
                        file = projectFiles[i];
                        sources = null;
                        classFiles = null;
                        if (!(file instanceof BytecodeTestFile)) continue;
                        Iterable $this$any$iv = ((BytecodeTestFile)((Object)file)).getSources();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                TestFile it = (TestFile)element$iv;
                                boolean bl3 = false;
                                if (!ArraysKt.contains((Object[])projectFiles, (Object)it)) continue;
                                bl = true;
                                break block16;
                            }
                            bl = false;
                        }
                    }
                    if (bl) continue;
                    sources = deleteSourceFiles ? ((BytecodeTestFile)((Object)file)).getSources() : CollectionsKt.emptyList();
                    classFiles = deleteBinaryFiles ? ((BytecodeTestFile)((Object)file)).getGeneratedPaths() : CollectionsKt.emptyList();
                    if (deleteSourceFiles) {
                        for (File dir : context.getProjectFolders()) {
                            for (TestFile testFile : sources) {
                                File source2 = new File(dir, testFile.getTargetPath());
                                if (!source2.exists()) continue;
                                source2.delete();
                            }
                        }
                    }
                    if (!deleteBinaryFiles) continue;
                    block6: for (String classTestFile : classFiles) {
                        for (File dir : context.getProjectFolders()) {
                            File classFile = new File(dir, classTestFile);
                            if (!classFile.exists()) continue;
                            classFile.delete();
                            continue block6;
                        }
                    }
                }
            }
        }

        public static /* synthetic */ void deleteCompiledSources$default(Companion companion, Collection collection, TestModeContext testModeContext, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            companion.deleteCompiledSources(collection, testModeContext, bl, bl2);
        }

        @JvmStatic
        @NotNull
        public final List<TestMode> values() {
            Object[] objectArray = new TestMode[]{DEFAULT, RESOURCE_REPOSITORIES, PARTIAL, MODULE_RESOURCES, BYTECODE_ONLY, SOURCE_ONLY, CDATA, SOURCE_TRANSFORMATION_GROUP, SUPPRESSIBLE};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestMode$OutputKind;", "", "(Ljava/lang/String;I)V", "REPORT", "QUICKFIXES", "lint-tests"})
    public static final class OutputKind
    extends Enum<OutputKind> {
        public static final /* enum */ OutputKind REPORT = new OutputKind();
        public static final /* enum */ OutputKind QUICKFIXES = new OutputKind();
        private static final /* synthetic */ OutputKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OutputKind[] values() {
            return (OutputKind[])$VALUES.clone();
        }

        public static OutputKind valueOf(String value) {
            return Enum.valueOf(OutputKind.class, value);
        }

        @NotNull
        public static EnumEntries<OutputKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = outputKindArray = new OutputKind[]{OutputKind.REPORT, OutputKind.QUICKFIXES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0013R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u001f\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/checks/infrastructure/TestMode$TestModeContext;", "", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "rootDir", "Ljava/io/File;", "projects", "", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "projectFolders", "clientState", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "lintContext", "Lcom/android/tools/lint/detector/api/Context;", "results", "", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "Lcom/android/tools/lint/checks/infrastructure/TestResultState;", "(Lcom/android/tools/lint/checks/infrastructure/TestLintTask;Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/lang/Object;Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Context;Ljava/util/Map;)V", "getClientState", "()Ljava/lang/Object;", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "getLintContext", "()Lcom/android/tools/lint/detector/api/Context;", "getProjectFolders", "()Ljava/util/List;", "getProjects", "getResults", "()Ljava/util/Map;", "getRootDir", "()Ljava/io/File;", "getTask", "()Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "lint-tests"})
    public static final class TestModeContext {
        @NotNull
        private final TestLintTask task;
        @NotNull
        private final File rootDir;
        @NotNull
        private final List<ProjectDescription> projects;
        @NotNull
        private final List<File> projectFolders;
        @Nullable
        private final Object clientState;
        @Nullable
        private final LintDriver driver;
        @Nullable
        private final Context lintContext;
        @Nullable
        private final Map<TestMode, TestResultState> results;

        public TestModeContext(@NotNull TestLintTask task, @NotNull File rootDir, @NotNull List<ProjectDescription> projects, @NotNull List<? extends File> projectFolders, @Nullable Object clientState, @Nullable LintDriver driver, @Nullable Context lintContext, @Nullable Map<TestMode, ? extends TestResultState> results) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Intrinsics.checkNotNullParameter(projectFolders, (String)"projectFolders");
            this.task = task;
            this.rootDir = rootDir;
            this.projects = projects;
            this.projectFolders = projectFolders;
            this.clientState = clientState;
            this.driver = driver;
            this.lintContext = lintContext;
            this.results = results;
        }

        public /* synthetic */ TestModeContext(TestLintTask testLintTask, File file, List list2, List list3, Object object, LintDriver lintDriver, Context context, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                lintDriver = null;
            }
            if ((n & 0x40) != 0) {
                context = null;
            }
            if ((n & 0x80) != 0) {
                map = null;
            }
            this(testLintTask, file, list2, list3, object, lintDriver, context, map);
        }

        @NotNull
        public final TestLintTask getTask() {
            return this.task;
        }

        @NotNull
        public final File getRootDir() {
            return this.rootDir;
        }

        @NotNull
        public final List<ProjectDescription> getProjects() {
            return this.projects;
        }

        @NotNull
        public final List<File> getProjectFolders() {
            return this.projectFolders;
        }

        @Nullable
        public final Object getClientState() {
            return this.clientState;
        }

        @Nullable
        public final LintDriver getDriver() {
            return this.driver;
        }

        @Nullable
        public final Context getLintContext() {
            return this.lintContext;
        }

        @Nullable
        public final Map<TestMode, TestResultState> getResults() {
            return this.results;
        }
    }
}

