/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.LintIssueDocGenerator;
import com.android.tools.lint.checks.infrastructure.LintFixVerifier;
import com.android.tools.lint.checks.infrastructure.SourceTransformationTestMode;
import com.android.tools.lint.checks.infrastructure.TestMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/infrastructure/SourceTransformationTestMode;", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "description", "", "testMode", "folder", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "folderName", "getFolderName", "()Ljava/lang/String;", "modifiesSources", "", "getModifiesSources", "()Z", "messagesMatch", "original", "modified", "sameOutput", "expected", "actual", "type", "Lcom/android/tools/lint/checks/infrastructure/TestMode$OutputKind;", "transformMessage", "message", "lint-tests"})
public abstract class SourceTransformationTestMode
extends TestMode {
    @NotNull
    private final String folderName;
    private final boolean modifiesSources;

    public SourceTransformationTestMode(@NotNull String description2, @NotNull String testMode, @NotNull String folder) {
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)testMode, (String)"testMode");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        super(description2, testMode);
        this.folderName = folder;
        this.modifiesSources = true;
    }

    @Override
    @NotNull
    public String getFolderName() {
        return this.folderName;
    }

    @Override
    public boolean getModifiesSources() {
        return this.modifiesSources;
    }

    @Override
    public boolean sameOutput(@NotNull String expected, @NotNull String actual, @NotNull TestMode.OutputKind type) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (Intrinsics.areEqual((Object)expected, (Object)actual)) {
            return true;
        }
        KFunction filterOutput2 = type == TestMode.OutputKind.REPORT ? (KFunction)new Function1<String, List<? extends String>>((Object)LintIssueDocGenerator.Companion){

            @NotNull
            public final List<String> invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LintIssueDocGenerator.Companion)this.receiver).getOutputLines(p0);
            }
        } : (KFunction)new Function1<String, List<? extends String>>((Object)LintIssueDocGenerator.Companion){

            @NotNull
            public final List<String> invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((LintIssueDocGenerator.Companion)this.receiver).getFixLines(p0);
            }
        };
        List expectedLines = (List)((Function1)filterOutput2).invoke((Object)expected);
        List actualLines = (List)((Function1)filterOutput2).invoke((Object)actual);
        if (expectedLines.size() != actualLines.size()) {
            return false;
        }
        int n = expectedLines.size();
        for (int i = 0; i < n; ++i) {
            String adjustedActual2;
            String adjustedExpectations2;
            String actualLine;
            String expectedLine = (String)expectedLines.get(i);
            if (Intrinsics.areEqual((Object)expectedLine, (Object)(actualLine = (String)actualLines.get(i))) || this.messagesMatch(expectedLine, actualLine) || type == TestMode.OutputKind.QUICKFIXES && this.messagesMatch(adjustedExpectations2 = LintFixVerifier.Companion.adjustLineNumbers(expectedLine, (Function1<? super Integer, Integer>)((Function1)sameOutput.adjustedExpectations.1.INSTANCE)), adjustedActual2 = LintFixVerifier.Companion.adjustLineNumbers(actualLine, (Function1<? super Integer, Integer>)((Function1)sameOutput.adjustedActual.1.INSTANCE)))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String transformMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return message;
    }

    public boolean messagesMatch(@NotNull String original, @NotNull String modified) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        if (Intrinsics.areEqual((Object)original, (Object)modified)) {
            return true;
        }
        String l1 = this.transformMessage(original);
        String l2 = this.transformMessage(modified);
        return Intrinsics.areEqual((Object)l1, (Object)l2);
    }
}

