/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.ModuleResourcesTestModeKt;
import com.android.tools.lint.checks.infrastructure.ProjectDescription;
import com.android.tools.lint.checks.infrastructure.SourceTransformationTestMode;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ModuleResourcesTestMode;", "Lcom/android/tools/lint/checks/infrastructure/SourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "applies", "", "context", "Lcom/android/tools/lint/checks/infrastructure/TestMode$TestModeContext;", "configureProjects", "", "Lcom/android/tools/lint/checks/infrastructure/ProjectDescription;", "projects", "sameOutput", "expected", "actual", "type", "Lcom/android/tools/lint/checks/infrastructure/TestMode$OutputKind;", "transformMessage", "message", "usePartialAnalysis", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nModuleResourcesTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleResourcesTestMode.kt\ncom/android/tools/lint/checks/infrastructure/ModuleResourcesTestMode\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n3792#2:137\n4307#2,2:138\n3792#2:142\n4307#2,2:143\n3792#2:147\n4307#2,2:148\n37#3,2:140\n37#3,2:145\n37#3,2:150\n*S KotlinDebug\n*F\n+ 1 ModuleResourcesTestMode.kt\ncom/android/tools/lint/checks/infrastructure/ModuleResourcesTestMode\n*L\n92#1:137\n92#1:138,2\n97#1:142\n97#1:143,2\n103#1:147\n103#1:148,2\n92#1:140,2\n97#1:145,2\n103#1:150,2\n*E\n"})
public final class ModuleResourcesTestMode
extends SourceTransformationTestMode {
    @NotNull
    private final String diffExplanation;

    public ModuleResourcesTestMode() {
        super("Resources In Separate Module Test Mode", "TestMode.MODULE_RESOURCES", "module-resources");
        this.diffExplanation = "The lint detector is triggering\na lint error when resources are moved into their own module and\nthe detector is attempting to access resources from the resource\nrepository in other modules than the current one.";
    }

    @Override
    public boolean usePartialAnalysis() {
        return true;
    }

    @Override
    public boolean applies(@NotNull TestMode.TestModeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getTask().requestedResourceRepository && context.getTask().incrementalFileName == null && context.getProjects().size() == 1) {
            boolean hasCode = false;
            int resourceCount = 0;
            boolean hasManifest = false;
            for (TestFile file : ((ProjectDescription)CollectionsKt.first(context.getProjects())).getFiles()) {
                if (ModuleResourcesTestModeKt.access$isXmlResource(file)) {
                    ++resourceCount;
                } else if (ModuleResourcesTestModeKt.access$isManifest(file) && !(file instanceof TestFile.ManifestTestFile)) {
                    hasManifest = true;
                } else {
                    String path;
                    if (file.targetRelativePath == null) continue;
                    if (StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null)) {
                        hasCode = true;
                    }
                }
                if (resourceCount != 2 && (resourceCount != 1 || !hasManifest && !hasCode)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ProjectDescription> configureProjects(@NotNull List<ProjectDescription> projects) {
        void $this$toTypedArray$iv;
        void $this$filterTo$iv$iv;
        void $this$toTypedArray$iv2;
        void $this$filterTo$iv$iv2;
        TestFile[] $this$toTypedArray$iv3;
        void $this$filterTo$iv$iv3;
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        ProjectDescription project = (ProjectDescription)CollectionsKt.single(projects);
        Object $this$filter$iv = project.getFiles();
        boolean $i$f$filter = false;
        TestFile[] testFileArray = $this$filter$iv;
        TestFile[] destination$iv$iv = (TestFile[])new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv3).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv3[i];
            boolean bl = false;
            if (!ModuleResourcesTestModeKt.access$isValueXmlResource((TestFile)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv3;
        TestFile[] testFileArray2 = thisCollection$iv.toArray(new TestFile[0]);
        TestFile[] testFileArray3 = Arrays.copyOf(testFileArray2, testFileArray2.length);
        ProjectDescription values = new ProjectDescription(testFileArray3).name("values");
        Object $this$filter$iv2 = project.getFiles();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        TestFile[] destination$iv$iv2 = (TestFile[])new ArrayList();
        boolean $i$f$filterTo2 = false;
        int n2 = ((void)$this$filterTo$iv$iv2).length;
        for (n = 0; n < n2; ++n) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv2[n];
            boolean bl = false;
            if (!(ModuleResourcesTestModeKt.access$isXmlResource((TestFile)it) && !ModuleResourcesTestModeKt.access$isValueXmlResource((TestFile)it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv2 = $this$toTypedArray$iv2;
        $this$toTypedArray$iv3 = thisCollection$iv2.toArray(new TestFile[0]);
        TestFile[] testFileArray4 = Arrays.copyOf($this$toTypedArray$iv3, $this$toTypedArray$iv3.length);
        ProjectDescription files2 = new ProjectDescription(testFileArray4).name("resources").dependsOn(values);
        Object $this$filter$iv3 = project.getFiles();
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        int n3 = ((void)$this$filterTo$iv$iv).length;
        for (n2 = 0; n2 < n3; ++n2) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[n2];
            boolean bl = false;
            if (!(!ModuleResourcesTestModeKt.access$isXmlResource((TestFile)it))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        boolean $i$f$toTypedArray3 = false;
        void thisCollection$iv3 = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv3.toArray(new TestFile[0]);
        TestFile[] testFileArray5 = Arrays.copyOf(objectArray, objectArray.length);
        ProjectDescription code2 = new ProjectDescription(testFileArray5).name(project.getName()).dependsOn(files2);
        objectArray = new ProjectDescription[]{files2, values, code2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean sameOutput(@NotNull String expected, @NotNull String actual, @NotNull TestMode.OutputKind type) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return !StringsKt.contains$default((CharSequence)actual, (CharSequence)"[LintError]", (boolean)false, (int)2, null) || super.sameOutput(expected, actual, type);
    }

    @Override
    @NotNull
    public String transformMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)message, (String)" lib/", (String)" ", (boolean)false, (int)4, null), (String)"../lib/", (String)"", (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }
}

