/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.SdkConstants;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.checks.infrastructure.ClassName;
import com.android.tools.lint.checks.infrastructure.JavaTestContext;
import com.android.tools.lint.checks.infrastructure.KotlinClasspathKt;
import com.android.tools.lint.checks.infrastructure.LintTestUtils;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestFiles;
import com.android.tools.lint.checks.infrastructure.TestIssueRegistry;
import com.android.tools.lint.checks.infrastructure.TestLintClient;
import com.android.tools.lint.checks.infrastructure.TestLintResult;
import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.checks.infrastructure.TestResultTransformer;
import com.android.tools.lint.checks.infrastructure.XmlTestContext;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.client.api.UastParser;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.uast.UFile;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.w3c.dom.Document;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a6\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a$\u0010\u0000\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0005\u001a2\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u0002H\u00020\u0007j\b\u0012\u0004\u0012\u0002H\u0002`\b\u001al\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\f\u001a\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001aq\u0010!\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u0005\u0012\u0004\u0012\u00020$0\"2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)\u00a2\u0006\u0002\u0010*\u001a~\u0010!\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u0005\u0012\u0004\u0012\u00020$0\"2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\b\u0002\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u001am\u0010-\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0014\b\u0002\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)\u00a2\u0006\u0002\u0010.\u001a\u00b2\u0001\u0010/\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u00100\u001a\b\u0012\u0004\u0012\u000202012\b\b\u0002\u00103\u001a\u00020\u000f2\u0014\b\u0002\u00104\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012052\u0014\b\u0002\u00106\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0012052\b\b\u0002\u00107\u001a\u00020 2\b\b\u0002\u00108\u001a\u00020\u00122\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u00052\b\b\u0002\u0010;\u001a\u00020\u00122\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u000f2$\b\u0002\u0010=\u001a\u001e\u0012\u0004\u0012\u00020?\u0012\n\u0012\b\u0012\u0004\u0012\u00020@0\u0005\u0012\u0006\u0012\u0004\u0018\u00010@\u0018\u00010>\u001a\u0016\u0010A\u001a\u00020\u000f*\u00020\u000f2\b\b\u0002\u0010B\u001a\u00020\u0012H\u0007\u001a\n\u0010C\u001a\u00020\u000f*\u00020\u000f\u001a\n\u0010D\u001a\u00020\u000f*\u00020\u000f\u001a<\u0010E\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020)0\u00052\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u000105\u00a8\u0006G"}, d2={"checkTransitiveComparator", "", "T", "", "list", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "createTestProjectForFiles", "Lcom/android/tools/lint/detector/api/Project;", "dir", "Ljava/io/File;", "sourcesMap", "", "", "libs", "library", "", "android", "javaLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "kotlinLanguageLevel", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "sdkHome", "createXmlContext", "Lcom/android/tools/lint/detector/api/XmlContext;", "xml", "relativePath", "isLikelyPathSeparator", "s", "index", "", "parse", "Lkotlin/Pair;", "Lcom/android/tools/lint/detector/api/JavaContext;", "Lcom/intellij/openapi/Disposable;", "temporaryFolder", "Lorg/junit/rules/TemporaryFolder;", "testFiles", "", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "(Lcom/intellij/pom/java/LanguageLevel;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;ZLjava/io/File;ZLorg/junit/rules/TemporaryFolder;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)Lkotlin/Pair;", "sourceOverride", "extraLibs", "parseFirst", "(Lcom/intellij/pom/java/LanguageLevel;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;ZZLorg/junit/rules/TemporaryFolder;Ljava/io/File;[Lcom/android/tools/lint/checks/infrastructure/TestFile;)Lkotlin/Pair;", "runOnSources", "lintFactory", "Lkotlin/Function0;", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "expected", "accept", "Lkotlin/Function1;", "ignore", "bucketSize", "absolutePaths", "testModes", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "verbose", "expectFixDiffs", "applyFixes", "Lkotlin/Function2;", "Lcom/android/tools/lint/detector/api/Incident;", "Lcom/android/tools/lint/detector/api/LintFix;", "dos2unix", "indiscriminate", "platformPath", "portablePath", "use", "block", "lint-tests"})
@JvmName(name="LintTestUtils")
@SourceDebugExtension(value={"SMAP\nLintTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LintTestUtils.kt\ncom/android/tools/lint/checks/infrastructure/LintTestUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,646:1\n1549#2:647\n1620#2,3:648\n288#2,2:653\n1855#2,2:656\n1603#2,9:666\n1855#2:675\n1856#2:677\n1612#2:678\n1247#3,2:651\n1313#3,2:661\n603#3:665\n26#4:655\n1#5:658\n1#5:676\n37#6,2:659\n37#6,2:679\n37#6,2:681\n1766#7,2:663\n*S KotlinDebug\n*F\n+ 1 LintTestUtils.kt\ncom/android/tools/lint/checks/infrastructure/LintTestUtils\n*L\n141#1:647\n141#1:648,3\n283#1:653,2\n345#1:656,2\n523#1:666,9\n523#1:675\n523#1:677\n523#1:678\n193#1:651,2\n373#1:661,2\n515#1:665\n270#1:655\n523#1:676\n369#1:659,2\n571#1:679,2\n572#1:681,2\n388#1:663,2\n*E\n"})
public final class LintTestUtils {
    public static final <T extends Comparable<? super T>> void checkTransitiveComparator(@NotNull List<? extends T> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            int n2 = list2.size();
            for (int j = 0; j < n2; ++j) {
                int n3 = list2.size();
                for (int k = 0; k < n3; ++k) {
                    Comparable x = (Comparable)list2.get(i);
                    Comparable y = (Comparable)list2.get(j);
                    Comparable z = (Comparable)list2.get(k);
                    int a = Integer.signum(x.compareTo(y));
                    int b = Integer.signum(y.compareTo(z));
                    int c = Integer.signum(x.compareTo(z));
                    if (a != -Integer.signum(y.compareTo(x))) {
                        Assert.fail((String)("x.compareTo(y) != -y.compareTo(x) for x=" + x + " and y=" + y));
                    }
                    if (b != -Integer.signum(z.compareTo(y))) {
                        Assert.fail((String)("x.compareTo(y) != -y.compareTo(z) for x=" + y + " and y=" + z));
                    }
                    if (a != 0 && b != 0) {
                        if (a != b || c == a) continue;
                        if (x.compareTo(y) <= 0 || y.compareTo(z) <= 0 || x.compareTo(z) <= 0) {
                            Assert.fail((String)("Not true that when x > y and y > z, then x > z for x = " + x + ", y = " + y + ", z = " + z + "\n"));
                            continue;
                        }
                        Assert.assertFalse((x.compareTo(y) < 0 && y.compareTo(x) < 0 && x.compareTo(z) < 0 ? 1 : 0) != 0);
                        Assert.fail((String)("Not true that when x < y and y < z, then x < z for x = " + x + ", y = " + y + ", z = " + z + "\n"));
                        continue;
                    }
                    if (a == b) {
                        if (c == 0) continue;
                        Assert.fail((String)("\nEquality not transitive: Not true that x == y and y == z, then x = y for x = " + x + ", y = " + y + ", z = " + z + "\n"));
                        continue;
                    }
                    if (a != 0) {
                        if (c == a) continue;
                        if (x.compareTo(y) >= 0 || !Intrinsics.areEqual((Object)y, (Object)z) || x.compareTo(z) >= 0) {
                            Assert.fail((String)("Not true that when x < y and y == z, then x < z for x = " + x + ", y = " + y + ", z = " + z + "\n"));
                            continue;
                        }
                        Assert.assertFalse((x.compareTo(y) > 0 && Intrinsics.areEqual((Object)y, (Object)z) && x.compareTo(z) > 0 ? 1 : 0) != 0);
                        Assert.fail((String)("Not true that when x > y and y == z, then x > z for x = " + x + ", y = " + y + ", z = " + z + "\n"));
                        continue;
                    }
                    if (b == 0 || c == b) continue;
                    Assert.fail((String)("\nEither\n  x == y && y < z => x < z\nor\n  x == y && y > z => x > z\nis not true for x = " + x + ", y = " + y + ", z = " + z));
                    if (!Intrinsics.areEqual((Object)x, (Object)y) || y.compareTo(z) >= 0 || x.compareTo(z) >= 0) {
                        Assert.fail((String)("Not true that when x == y and y < z, then x < z for x = " + x + ", y = " + y + ", z = " + z + "\n"));
                        continue;
                    }
                    Assert.assertFalse((Intrinsics.areEqual((Object)x, (Object)y) && y.compareTo(z) > 0 && x.compareTo(z) > 0 ? 1 : 0) != 0);
                    Assert.fail((String)("Not true that when x == y and y > z, then x > z for x = " + x + ", y = " + y + ", z = " + z + "\n"));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> void checkTransitiveComparator(@NotNull List<? extends T> list2, @NotNull Comparator<T> comparator2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\n\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0013\u0010\u0002\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"com/android/tools/lint/checks/infrastructure/LintTestUtils$checkTransitiveComparator$Wrapper", "", "item", "(Ljava/util/Comparator;Ljava/lang/Object;)V", "getItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "compareTo", "", "other", "(Lcom/android/tools/lint/checks/infrastructure/LintTestUtils$checkTransitiveComparator$Wrapper;)I", "toString", "", "lint-tests"})
            public final class Wrapper
            implements Comparable<Wrapper<T>> {
                private final T item;
                final /* synthetic */ Comparator<T> $comparator;

                public Wrapper(@NotNull Comparator<T> $comparator, T item) {
                    Intrinsics.checkNotNullParameter($comparator, (String)"$comparator");
                    this.$comparator = $comparator;
                    this.item = item;
                }

                public final T getItem() {
                    return this.item;
                }

                @NotNull
                public String toString() {
                    return String.valueOf(this.item);
                }

                public int compareTo(@NotNull Wrapper<T> other) {
                    Intrinsics.checkNotNullParameter(other, (String)"other");
                    return this.$comparator.compare(this.item, other.item);
                }
            }
            collection.add(new Wrapper(comparator2, it));
        }
        LintTestUtils.checkTransitiveComparator((List)destination$iv$iv);
    }

    @NotNull
    public static final XmlContext createXmlContext(@Language(value="XML") @NotNull String xml, @NotNull File relativePath) {
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File dir = new File(System.getProperty("java.io.tmpdir"));
        File fullPath = new File(dir, relativePath.getPath());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)fullPath, (Object)xml)};
        Project project = LintTestUtils.createTestProjectForFiles$default(dir, MapsKt.mutableMapOf((Pair[])pairArray), null, false, false, null, null, null, 252, null);
        LintClient client2 = project.getClient();
        Intrinsics.checkNotNull((Object)client2);
        LintRequest request = new LintRequest(client2, CollectionsKt.listOf((Object)fullPath));
        LintDriver driver = new LintDriver((IssueRegistry)new TestIssueRegistry(), (LintClient)new LintCliClient("test"), request);
        driver.setScope(Scope.JAVA_FILE_SCOPE);
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)relativePath.getParentFile().getName());
        Document document2 = client2.getXmlDocument(fullPath, (CharSequence)xml);
        ResourceFolderType resourceFolderType = folderType;
        Intrinsics.checkNotNull((Object)resourceFolderType);
        Document document3 = document2;
        Intrinsics.checkNotNull((Object)document3);
        return new XmlTestContext(driver, project, xml, fullPath, resourceFolderType, document3);
    }

    private static final Project createTestProjectForFiles(File dir, Map<File, String> sourcesMap, List<? extends File> libs, boolean library, boolean android, LanguageLevel javaLanguageLevel, LanguageVersionSettings kotlinLanguageLevel, File sdkHome) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = (Sequence)FilesKt.walkBottomUp((File)dir);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean includeKotlinStdlib = bl;
        LintCliClient client2 = new LintCliClient(sourcesMap, sdkHome, javaLanguageLevel, kotlinLanguageLevel, includeKotlinStdlib, libs, dir, library, android){
            final /* synthetic */ Map<File, String> $sourcesMap;
            final /* synthetic */ File $sdkHome;
            final /* synthetic */ LanguageLevel $javaLanguageLevel;
            final /* synthetic */ LanguageVersionSettings $kotlinLanguageLevel;
            final /* synthetic */ boolean $includeKotlinStdlib;
            final /* synthetic */ List<File> $libs;
            final /* synthetic */ File $dir;
            final /* synthetic */ boolean $library;
            final /* synthetic */ boolean $android;
            {
                this.$sourcesMap = $sourcesMap;
                this.$sdkHome = $sdkHome;
                this.$javaLanguageLevel = $javaLanguageLevel;
                this.$kotlinLanguageLevel = $kotlinLanguageLevel;
                this.$includeKotlinStdlib = $includeKotlinStdlib;
                this.$libs = $libs;
                this.$dir = $dir;
                this.$library = $library;
                this.$android = $android;
                super("test");
            }

            @NotNull
            public CharSequence readFile(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string = this.$sourcesMap.get(file);
                return string != null ? (CharSequence)string : super.readFile(file);
            }

            @Nullable
            public IAndroidTarget getCompileTarget(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                List targets = this.getTargets();
                int n = targets.size() + -1;
                if (0 <= n) {
                    do {
                        int i;
                        IAndroidTarget target;
                        if (!(target = (IAndroidTarget)targets.get(i = n--)).isPlatform()) continue;
                        return target;
                    } while (0 <= n);
                }
                return super.getCompileTarget(project);
            }

            @Nullable
            public File getSdkHome() {
                return this.$sdkHome;
            }

            @NotNull
            public LanguageLevel getJavaLanguageLevel(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (this.$javaLanguageLevel != null) {
                    return this.$javaLanguageLevel;
                }
                return super.getJavaLanguageLevel(project);
            }

            @NotNull
            public LanguageVersionSettings getKotlinLanguageLevel(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (this.$kotlinLanguageLevel != null) {
                    return this.$kotlinLanguageLevel;
                }
                return super.getKotlinLanguageLevel(project);
            }

            @NotNull
            public List<File> getJavaLibraries(@NotNull Project project, boolean includeProvided) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                List kotlinStdlib = this.$includeKotlinStdlib ? KotlinClasspathKt.findKotlinStdlibPath() : CollectionsKt.emptyList();
                return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)super.getJavaLibraries(project, includeProvided), (Iterable)this.$libs), (Iterable)kotlinStdlib);
            }

            @NotNull
            public List<File> getJavaSourceFolders(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return CollectionsKt.plus((Collection)super.getJavaSourceFolders(project), (Object)this.$dir);
            }

            @NotNull
            protected Project createProject(@NotNull File dir, @NotNull File referenceDir) {
                TestLintClient.TestProject p2;
                block1: {
                    String it;
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)referenceDir, (String)"referenceDir");
                    Project clone = super.createProject(dir, referenceDir);
                    p2 = new TestLintClient.TestProject(this, dir, referenceDir, this.$library, this.$android){
                        final /* synthetic */ boolean $library;
                        final /* synthetic */ boolean $android;
                        {
                            this.$library = $library;
                            this.$android = $android;
                            super((LintClient)$receiver, $dir, $referenceDir, null, null);
                        }

                        public boolean isLibrary() {
                            return this.$library;
                        }

                        public boolean isAndroidProject() {
                            return this.$android;
                        }
                    };
                    String string = clone.getBuildTargetHash();
                    if (string != null) {
                        it = string;
                        boolean bl = false;
                        p2.setBuildTargetHash(it);
                    }
                    com.intellij.openapi.project.Project project = clone.getIdeaProject();
                    if (project == null) break block1;
                    it = project;
                    boolean bl = false;
                    p2.setIdeaProject((com.intellij.openapi.project.Project)it);
                }
                return p2;
            }
        };
        Project project = client2.getProject(dir, dir);
        client2.initializeProjects(null, (Collection)CollectionsKt.listOf((Object)project));
        return project;
    }

    static /* synthetic */ Project createTestProjectForFiles$default(File file, Map map, List list2, boolean bl, boolean bl2, LanguageLevel languageLevel, LanguageVersionSettings languageVersionSettings, File file2, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            languageLevel = null;
        }
        if ((n & 0x40) != 0) {
            languageVersionSettings = null;
        }
        if ((n & 0x80) != 0) {
            file2 = null;
        }
        return LintTestUtils.createTestProjectForFiles(file, map, list2, bl, bl2, languageLevel, languageVersionSettings, file2);
    }

    @NotNull
    public static final Pair<JavaContext, Disposable> parseFirst(@Nullable LanguageLevel javaLanguageLevel, @Nullable LanguageVersionSettings kotlinLanguageLevel, boolean library, boolean android, @NotNull TemporaryFolder temporaryFolder, @Nullable File sdkHome, TestFile ... testFiles) {
        JavaContext javaContext;
        Object v3;
        Disposable disposable2;
        List contexts2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)temporaryFolder, (String)"temporaryFolder");
            Intrinsics.checkNotNullParameter((Object)testFiles, (String)"testFiles");
            Pair<List<JavaContext>, Disposable> pair = LintTestUtils.parse(javaLanguageLevel, kotlinLanguageLevel, library, sdkHome, android, temporaryFolder, Arrays.copyOf(testFiles, testFiles.length));
            contexts2 = (List)pair.component1();
            disposable2 = (Disposable)pair.component2();
            Iterable $this$firstOrNull$iv = contexts2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JavaContext it = (JavaContext)element$iv;
                boolean bl = false;
                String string = it.file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String string2 = LintTestUtils.portablePath(string);
                String string3 = testFiles[0].targetRelativePath;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetRelativePath");
                if (!StringsKt.endsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        if ((javaContext = (JavaContext)v3) == null) {
            javaContext = (JavaContext)CollectionsKt.first((List)contexts2);
        }
        JavaContext first = javaContext;
        return new Pair((Object)first, (Object)disposable2);
    }

    public static /* synthetic */ Pair parseFirst$default(LanguageLevel languageLevel, LanguageVersionSettings languageVersionSettings, boolean bl, boolean bl2, TemporaryFolder temporaryFolder, File file, TestFile[] testFileArray, int n, Object object) {
        if ((n & 1) != 0) {
            languageLevel = null;
        }
        if ((n & 2) != 0) {
            languageVersionSettings = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            file = null;
        }
        if ((n & 0x40) != 0) {
            boolean $i$f$emptyArray = false;
            testFileArray = new TestFile[]{};
        }
        return LintTestUtils.parseFirst(languageLevel, languageVersionSettings, bl, bl2, temporaryFolder, file, testFileArray);
    }

    @NotNull
    public static final Pair<List<JavaContext>, Disposable> parse(@Nullable LanguageLevel javaLanguageLevel, @Nullable LanguageVersionSettings kotlinLanguageLevel, boolean library, @Nullable File sdkHome, boolean android, @NotNull TemporaryFolder temporaryFolder, TestFile ... testFiles) {
        Intrinsics.checkNotNullParameter((Object)temporaryFolder, (String)"temporaryFolder");
        Intrinsics.checkNotNullParameter((Object)testFiles, (String)"testFiles");
        File dir = temporaryFolder.newFolder();
        List<File> list2 = new TestLintTask().files(Arrays.copyOf(testFiles, testFiles.length)).createProjects(dir);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"createProjects(...)");
        List<File> projects = list2;
        File file = projects.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(...)");
        return LintTestUtils.parse$default(file, javaLanguageLevel, kotlinLanguageLevel, library, sdkHome, android, null, null, 192, null);
    }

    public static /* synthetic */ Pair parse$default(LanguageLevel languageLevel, LanguageVersionSettings languageVersionSettings, boolean bl, File file, boolean bl2, TemporaryFolder temporaryFolder, TestFile[] testFileArray, int n, Object object) {
        if ((n & 1) != 0) {
            languageLevel = null;
        }
        if ((n & 2) != 0) {
            languageVersionSettings = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            file = null;
        }
        if ((n & 0x10) != 0) {
            bl2 = file != null;
        }
        return LintTestUtils.parse(languageLevel, languageVersionSettings, bl, file, bl2, temporaryFolder, testFileArray);
    }

    @NotNull
    public static final Pair<List<JavaContext>, Disposable> parse(@NotNull File dir, @Nullable LanguageLevel javaLanguageLevel, @Nullable LanguageVersionSettings kotlinLanguageLevel, boolean library, @Nullable File sdkHome, boolean android, @NotNull Map<File, String> sourceOverride, @NotNull List<? extends File> extraLibs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(sourceOverride, (String)"sourceOverride");
        Intrinsics.checkNotNullParameter(extraLibs, (String)"extraLibs");
        Project project = LintTestUtils.createTestProjectForFiles(dir, sourceOverride, extraLibs, library, android, javaLanguageLevel, kotlinLanguageLevel, sdkHome);
        LintClient lintClient = project.getClient();
        Intrinsics.checkNotNull((Object)lintClient, (String)"null cannot be cast to non-null type com.android.tools.lint.LintCliClient");
        LintCliClient client2 = (LintCliClient)lintClient;
        LintRequest request = new LintRequest((LintClient)client2, CollectionsKt.toList((Iterable)sourceOverride.keySet()));
        LintDriver driver = new LintDriver((IssueRegistry)new TestIssueRegistry(), (LintClient)new LintCliClient("test"), request);
        EnumSet<Enum> enumSet = EnumSet.of((Enum)Scope.ALL_JAVA_FILES);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        driver.setScope(enumSet);
        UastParser uastParser = client2.getUastParser(project);
        TestCase.assertNotNull((Object)uastParser);
        List contexts2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)FilesKt.walk$default((File)dir, null, (int)1, null)), (Function1)((Function1)new Function1<File, JavaContext>(driver, project, sourceOverride, uastParser){
            final /* synthetic */ LintDriver $driver;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map<File, String> $sourceOverride;
            final /* synthetic */ UastParser $uastParser;
            {
                this.$driver = $driver;
                this.$project = $project;
                this.$sourceOverride = $sourceOverride;
                this.$uastParser = $uastParser;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final JavaContext invoke(@NotNull File file) {
                void var2_2;
                String string;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                String string2 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                if (!StringsKt.endsWith$default((String)string2, (String)".kt", (boolean)false, (int)2, null)) {
                    String string3 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    if (!StringsKt.endsWith$default((String)string3, (String)".java", (boolean)false, (int)2, null)) return null;
                }
                if ((string = this.$sourceOverride.get(file)) == null) {
                    string = FilesKt.readText$default((File)file, null, (int)1, null);
                }
                JavaContext context = new JavaTestContext(this.$driver, this.$project, string, file);
                context.setUastParser(this.$uastParser);
                JavaContext javaContext = var2_2;
                return javaContext;
            }
        })));
        UastParser.prepare$default((UastParser)uastParser, (List)contexts2, null, null, (int)6, null);
        Iterable $this$forEach$iv = contexts2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            JavaContext context = (JavaContext)element$iv;
            boolean bl2 = false;
            UFile uFile = uastParser.parse(context);
            context.setUastFile(uFile);
            boolean bl3 = bl = uFile != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            UFile uFile2 = uFile;
            Intrinsics.checkNotNull((Object)uFile2);
            context.setJavaFile(uFile2.getSourcePsi());
        }
        Disposable disposable2 = new Disposable(client2, project){
            final /* synthetic */ LintCliClient $client;
            final /* synthetic */ Project $project;
            {
                this.$client = $client;
                this.$project = $project;
            }

            public final void dispose() {
                this.$client.disposeProjects((Collection)CollectionsKt.listOf((Object)this.$project));
            }
        };
        return new Pair((Object)contexts2, (Object)disposable2);
    }

    public static /* synthetic */ Pair parse$default(File file, LanguageLevel languageLevel, LanguageVersionSettings languageVersionSettings, boolean bl, File file2, boolean bl2, Map map, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            languageLevel = null;
        }
        if ((n & 4) != 0) {
            languageVersionSettings = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            file2 = null;
        }
        if ((n & 0x20) != 0) {
            boolean bl3 = bl2 = file2 != null;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x80) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return LintTestUtils.parse(file, languageLevel, languageVersionSettings, bl, file2, bl2, map, list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void use(@NotNull List<? extends TestFile> $this$use, @Nullable TemporaryFolder temporaryFolder, @Nullable File sdkHome, @NotNull Function1<? super JavaContext, Unit> block2) {
        Path path;
        TestFile[] $this$use_u24lambda_u245;
        Intrinsics.checkNotNullParameter((Object)$this$use, (String)"<this>");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        Path dir = null;
        TemporaryFolder temporaryFolder2 = temporaryFolder;
        if (temporaryFolder2 == null) {
            TemporaryFolder temporaryFolder3;
            $this$use_u24lambda_u245 = $this$use;
            boolean bl = false;
            Path path2 = dir = Files.createTempDirectory("lint-test", new FileAttribute[0]);
            TemporaryFolder $this$use_u24lambda_u245_u24lambda_u244 = temporaryFolder3 = new TemporaryFolder(path2 != null ? path2.toFile() : null);
            boolean bl2 = false;
            $this$use_u24lambda_u245_u24lambda_u244.create();
            temporaryFolder2 = temporaryFolder3;
        }
        TemporaryFolder folder = temporaryFolder2;
        Collection $this$toTypedArray$iv = (Collection)$this$use;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$use_u24lambda_u245 = thisCollection$iv.toArray(new TestFile[0]);
        Pair<JavaContext, Disposable> pair = LintTestUtils.parseFirst(null, null, false, sdkHome != null, folder, sdkHome, Arrays.copyOf($this$use_u24lambda_u245, $this$use_u24lambda_u245.length));
        JavaContext context = (JavaContext)pair.component1();
        Disposable disposable2 = (Disposable)pair.component2();
        try {
            block2.invoke((Object)context);
            path = dir;
        }
        catch (Throwable throwable) {
            Comparable<Path> comparable = dir;
            if (comparable != null && (comparable = comparable.toFile()) != null && (comparable = FilesKt.walkBottomUp((File)comparable)) != null) {
                Sequence $this$forEach$iv = (Sequence)comparable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    it.delete();
                }
            }
            Disposer.dispose((Disposable)disposable2);
            throw throwable;
        }
        Comparable<Path> comparable = path;
        if (path != null && (comparable = comparable.toFile()) != null && (comparable = FilesKt.walkBottomUp((File)comparable)) != null) {
            Sequence $this$forEach$iv = (Sequence)comparable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                it.delete();
            }
        }
        Disposer.dispose((Disposable)disposable2);
    }

    public static /* synthetic */ void use$default(List list2, TemporaryFolder temporaryFolder, File file, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            temporaryFolder = null;
        }
        if ((n & 2) != 0) {
            file = null;
        }
        LintTestUtils.use(list2, temporaryFolder, file, (Function1<? super JavaContext, Unit>)function1);
    }

    @JvmOverloads
    @NotNull
    public static final String dos2unix(@NotNull String $this$dos2unix, boolean indiscriminate) {
        boolean bl;
        int n;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$dos2unix, (String)"<this>");
            CharSequence $this$none$iv = $this$dos2unix;
            boolean $i$f$none = false;
            for (n = 0; n < $this$none$iv.length(); ++n) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(n);
                boolean bl2 = false;
                if (!(it == '\r' || it == '\\' || it == ';')) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (bl) {
            return $this$dos2unix;
        }
        if (indiscriminate) {
            return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$dos2unix, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (char)'\\', (char)'/', (boolean)false, (int)4, null), (char)';', (char)':', (boolean)false, (int)4, null);
        }
        StringBuilder sb = new StringBuilder();
        n = $this$dos2unix.length();
        for (int i = 0; i < n; ++i) {
            char c = $this$dos2unix.charAt(i);
            if (c == '\r') continue;
            if (c == '\\') {
                sb.append('/');
                continue;
            }
            if (c == ';') {
                if (LintTestUtils.isLikelyPathSeparator($this$dos2unix, i)) {
                    sb.append(':');
                    continue;
                }
                sb.append(';');
                continue;
            }
            sb.append(c);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String dos2unix$default(String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return LintTestUtils.dos2unix(string, bl);
    }

    @NotNull
    public static final String platformPath(@NotNull String $this$platformPath) {
        Intrinsics.checkNotNullParameter((Object)$this$platformPath, (String)"<this>");
        return StringsKt.replace$default((String)$this$platformPath, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String portablePath(@NotNull String $this$portablePath) {
        Intrinsics.checkNotNullParameter((Object)$this$portablePath, (String)"<this>");
        return StringsKt.replace$default((String)$this$portablePath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    private static final boolean isLikelyPathSeparator(String s, int index) {
        char next;
        if (index == 0) {
            return false;
        }
        if (CharsKt.isWhitespace((char)s.charAt(index - 1))) {
            return false;
        }
        if (index < s.length() - 1 && (CharsKt.isWhitespace((char)(next = s.charAt(index + 1))) || next == '\"' || next == 'b' && StringsKt.regionMatches$default((String)s, (int)(index + 1), (String)"base64", (int)0, (int)6, (boolean)false, (int)16, null))) {
            return false;
        }
        int j = index - 1;
        int n = Math.max(0, index - 6);
        if (n <= j) {
            while (true) {
                char c;
                if ((c = s.charAt(j)) == '&') {
                    return false;
                }
                if (!Character.isLetterOrDigit(c) && c != '#' || j == n) break;
                --j;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final void runOnSources(@NotNull File dir, @NotNull Function0<? extends TestLintTask> lintFactory, @NotNull String expected, @NotNull Function1<? super File, Boolean> accept, @NotNull Function1<? super File, Boolean> ignore, int bucketSize, boolean absolutePaths, @NotNull List<? extends TestMode> testModes, boolean verbose, @Nullable String expectFixDiffs2, @Nullable Function2<? super Incident, ? super List<? extends LintFix>, ? extends LintFix> applyFixes2) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(lintFactory, (String)"lintFactory");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter(accept, (String)"accept");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        Intrinsics.checkNotNullParameter(testModes, (String)"testModes");
        if (applyFixes2 != null && !absolutePaths) {
            throw new IllegalStateException("applyFixes = true requires absolutePaths = true".toString());
        }
        HashSet<CallSite> seen = new HashSet<CallSite>();
        File root = dir.getCanonicalFile();
        Intrinsics.checkNotNull((Object)root);
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)root)), (Function1)((Function1)new Function1<File, Boolean>(ignore, accept){
            final /* synthetic */ Function1<File, Boolean> $ignore;
            final /* synthetic */ Function1<File, Boolean> $accept;
            {
                this.$ignore = $ignore;
                this.$accept = $accept;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$ignore.invoke((Object)it) == false && (Boolean)this.$accept.invoke((Object)it) != false;
            }
        }));
        boolean $i$f$sortedBy = false;
        List sourceFiles2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
            }
        }));
        StringBuilder sb = new StringBuilder();
        StringBuilder fixSb = new StringBuilder();
        int buckets = sourceFiles2.size() / bucketSize;
        int i = 0;
        if (i <= buckets) {
            while (true) {
                TestLintResult result;
                block19: {
                    void $this$mapNotNullTo$iv$iv;
                    int from = i * bucketSize;
                    int to = Math.min(sourceFiles2.size(), (i + 1) * bucketSize);
                    Iterable $this$mapNotNull$iv = sourceFiles2.subList(from, to);
                    boolean $i$f$mapNotNull2 = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        TestFile testFile;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        File it = (File)element$iv$iv;
                        boolean bl2 = false;
                        String source2 = FilesKt.readText$default((File)it, null, (int)1, null);
                        String path = it.getPath();
                        boolean keep = true;
                        Intrinsics.checkNotNull((Object)path);
                        if (StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null)) {
                            try {
                                String key;
                                String string = path.substring(StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null));
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                ClassName className = new ClassName(source2, string);
                                if (className.getClassName() != null && !seen.add((CallSite)((Object)(key = className.getPackageName() + className.getClassName())))) {
                                    keep = false;
                                }
                            }
                            catch (Throwable e) {
                                keep = false;
                            }
                        }
                        if (keep) {
                            Object object;
                            if (absolutePaths) {
                                object = "src/" + path;
                            } else {
                                String string = root.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                String string2 = StringsKt.removePrefix((String)path, (CharSequence)string);
                                String string3 = File.separator;
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
                                String path2 = LintTestUtils.portablePath(StringsKt.removePrefix((String)string2, (CharSequence)string3));
                                boolean bl3 = false;
                                object = !StringsKt.startsWith$default((String)path2, (String)"src/", (boolean)false, (int)2, null) ? "src/" + path2 : path2;
                            }
                            String srcPath = object;
                            testFile = StringsKt.endsWith$default((String)srcPath, (String)".kt", (boolean)false, (int)2, null) ? TestFiles.kotlin(srcPath, source2) : (StringsKt.endsWith$default((String)srcPath, (String)".java", (boolean)false, (int)2, null) ? TestFiles.java(srcPath, source2) : (StringsKt.endsWith$default((String)srcPath, (String)".xml", (boolean)false, (int)2, null) ? TestFiles.xml(srcPath, source2) : null));
                        } else {
                            testFile = null;
                        }
                        if (testFile == null) continue;
                        TestFile it$iv$iv = testFile;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List files2 = (List)destination$iv$iv;
                    if (files2.isEmpty()) break;
                    result = null;
                    try {
                        if (verbose) {
                            int n = files2.size();
                            String string = ((TestFile)files2.get((int)0)).targetRelativePath;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
                            String string4 = StringsKt.removePrefix((String)string, (CharSequence)"src/");
                            String string5 = ((TestFile)files2.get((int)(files2.size() - 1))).targetRelativePath;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"targetRelativePath");
                            String $i$f$mapNotNull2 = "Analyzing " + n + " files, first file is " + string4 + ", last is " + StringsKt.removePrefix((String)string5, (CharSequence)"src/");
                            System.out.println((Object)$i$f$mapNotNull2);
                        }
                        Collection $this$toTypedArray$iv = files2;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Object[] $i$f$mapNotNull2 = thisCollection$iv.toArray(new TestFile[0]);
                        TestLintTask testLintTask = ((TestLintTask)lintFactory.invoke()).files(Arrays.copyOf($i$f$mapNotNull2, $i$f$mapNotNull2.length));
                        $this$toTypedArray$iv = testModes;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        $i$f$mapNotNull2 = thisCollection$iv.toArray(new TestMode[0]);
                        result = testLintTask.testModes((TestMode[])Arrays.copyOf($i$f$mapNotNull2, $i$f$mapNotNull2.length)).allowCompilationErrors().allowAbsolutePathsInMessages(absolutePaths).run();
                        TestLintResult.expect$default(result, "", null, new TestResultTransformer(absolutePaths, root, sb, verbose){
                            final /* synthetic */ boolean $absolutePaths;
                            final /* synthetic */ File $root;
                            final /* synthetic */ StringBuilder $sb;
                            final /* synthetic */ boolean $verbose;
                            {
                                this.$absolutePaths = $absolutePaths;
                                this.$root = $root;
                                this.$sb = $sb;
                                this.$verbose = $verbose;
                            }

                            @NotNull
                            public final String transform(@NotNull String report) {
                                Intrinsics.checkNotNullParameter((Object)report, (String)"report");
                                if (!Intrinsics.areEqual((Object)report, (Object)"No warnings.")) {
                                    String string;
                                    if (this.$absolutePaths) {
                                        string = StringsKt.replace$default((String)StringsKt.removePrefix((String)report, (CharSequence)"src"), (String)"\nsrc", (String)"\n", (boolean)false, (int)4, null);
                                    } else {
                                        String string2 = this.$root.getPath();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                                        String string3 = StringsKt.replace$default((String)report, (String)string2, (String)"", (boolean)false, (int)4, null);
                                        String string4 = this.$root.getPath();
                                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                                        string = StringsKt.replace$default((String)string3, (String)LintTestUtils.portablePath(string4), (String)"", (boolean)false, (int)4, null);
                                    }
                                    String cleaned = string;
                                    this.$sb.append(cleaned).append("\n");
                                    if (this.$verbose) {
                                        System.out.println((Object)("Partial:\n" + cleaned + "\n"));
                                    }
                                }
                                return "";
                            }
                        }, null, 10, null);
                        if (expectFixDiffs2 != null) {
                            result.verifyFixes(TestMode.DEFAULT).expectFixDiffs(expected, new TestResultTransformer(absolutePaths, root, fixSb, verbose){
                                final /* synthetic */ boolean $absolutePaths;
                                final /* synthetic */ File $root;
                                final /* synthetic */ StringBuilder $fixSb;
                                final /* synthetic */ boolean $verbose;
                                {
                                    this.$absolutePaths = $absolutePaths;
                                    this.$root = $root;
                                    this.$fixSb = $fixSb;
                                    this.$verbose = $verbose;
                                }

                                @NotNull
                                public final String transform(@NotNull String report) {
                                    String string;
                                    Intrinsics.checkNotNullParameter((Object)report, (String)"report");
                                    if (this.$absolutePaths) {
                                        string = StringsKt.replace$default((String)StringsKt.removePrefix((String)report, (CharSequence)"src"), (String)"\nsrc", (String)"\n", (boolean)false, (int)4, null);
                                    } else {
                                        String string2 = this.$root.getPath();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                                        String string3 = StringsKt.replace$default((String)report, (String)string2, (String)"", (boolean)false, (int)4, null);
                                        String string4 = this.$root.getPath();
                                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                                        string = StringsKt.replace$default((String)string3, (String)LintTestUtils.portablePath(string4), (String)"", (boolean)false, (int)4, null);
                                    }
                                    String cleaned = string;
                                    this.$fixSb.append(cleaned).append("\n");
                                    if (this.$verbose) {
                                        System.out.println((Object)("Partial:\n" + cleaned + "\n"));
                                    }
                                    return "";
                                }
                            });
                        }
                    }
                    catch (Throwable ignore2) {
                        if (verbose) {
                            ignore2.printStackTrace();
                        }
                        TestLintResult testLintResult = result;
                        if (testLintResult == null) break block19;
                        testLintResult.cleanup();
                    }
                }
                if (applyFixes2 != null && result != null) {
                    result.applyFixes(applyFixes2, (Function3<? super Project, ? super File, ? super byte[], Unit>)((Function3)runOnSources.5.INSTANCE));
                }
                if (i == buckets) break;
                ++i;
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String actual = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Assert.assertEquals((Object)((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)expected))).toString(), (Object)actual);
        if (expectFixDiffs2 != null) {
            String string6 = ((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)expectFixDiffs2))).toString();
            String string7 = fixSb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
            Assert.assertEquals((Object)string6, (Object)((Object)StringsKt.trim((CharSequence)string7)).toString());
        }
    }

    public static /* synthetic */ void runOnSources$default(File file, Function0 function0, String string, Function1 function1, Function1 function12, int n, boolean bl, List list2, boolean bl2, String string2, Function2 function2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = "";
        }
        if ((n2 & 8) != 0) {
            function1 = runOnSources.1.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            function12 = runOnSources.2.INSTANCE;
        }
        if ((n2 & 0x20) != 0) {
            n = 500;
        }
        if ((n2 & 0x40) != 0) {
            boolean bl3 = bl = SdkConstants.currentPlatform() != 2;
        }
        if ((n2 & 0x80) != 0) {
            list2 = CollectionsKt.listOf((Object)TestMode.DEFAULT);
        }
        if ((n2 & 0x100) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x200) != 0) {
            string2 = null;
        }
        if ((n2 & 0x400) != 0) {
            function2 = null;
        }
        LintTestUtils.runOnSources(file, (Function0<? extends TestLintTask>)function0, string, (Function1<? super File, Boolean>)function1, (Function1<? super File, Boolean>)function12, n, bl, list2, bl2, string2, (Function2<? super Incident, ? super List<? extends LintFix>, ? extends LintFix>)function2);
    }

    @JvmOverloads
    @NotNull
    public static final String dos2unix(@NotNull String $this$dos2unix) {
        Intrinsics.checkNotNullParameter((Object)$this$dos2unix, (String)"<this>");
        return LintTestUtils.dos2unix$default($this$dos2unix, false, 1, null);
    }
}

