/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.FullyQualifyNamesTestMode;
import com.android.tools.lint.checks.infrastructure.ImportAliasTestMode;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J:\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ImportAliasTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "isRelevantFile", "", "file", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "messagesMatch", "original", "modified", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "lint-tests"})
public final class ImportAliasTestMode
extends UastSourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n        In Kotlin, types can be renamed\n        via import aliases. This means that detectors should look at the\n        resolved types, not the local identifier names.\n\n        This test mode introduces import aliases for all types accessed\n        from Kotlin source files and makes sure the test results are\n        unaffected.\n\n        In the unlikely event that your lint check is actually doing something\n        specific to import aliasing, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));

    public ImportAliasTestMode() {
        super("Import aliases", "TestMode.IMPORT_ALIAS", "import-alias");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    protected boolean isRelevantFile(@NotNull TestFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.targetRelativePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
        return StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        if (!Lint.isKotlin((Language)root.getLang())) {
            return new ArrayList();
        }
        Map editMap = new LinkedHashMap();
        Set imported = new LinkedHashSet();
        LinkedHashMap<String, String> aliasNames = new LinkedHashMap<String, String>();
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new FullyQualifyNamesTestMode.TypeVisitor(context, source2, imported, aliasNames, editMap){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ String $source;
            final /* synthetic */ Set<String> $imported;
            final /* synthetic */ LinkedHashMap<String, String> $aliasNames;
            final /* synthetic */ Map<Integer, Edit> $editMap;
            {
                this.$context = $context;
                this.$source = $source;
                this.$imported = $imported;
                this.$aliasNames = $aliasNames;
                this.$editMap = $editMap;
                super($context, $source);
            }

            public boolean visitImportStatement(@NotNull UImportStatement node) {
                KtImportDirective ktImportDirective;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                KtImportDirective ktImportDirective2 = ktImportDirective = psiElement instanceof KtImportDirective ? (KtImportDirective)psiElement : null;
                if (ktImportDirective != null && !node.isOnDemand() && ktImportDirective.getAliasName() == null) {
                    String qualifiedName;
                    String text;
                    PsiElement resolved = node.resolve();
                    UElement reference = node.getImportReference();
                    UElement uElement = reference;
                    String string = uElement != null && (uElement = uElement.getSourcePsi()) != null ? uElement.getText() : (text = null);
                    if (text != null && resolved != null && resolved instanceof PsiClass && (qualifiedName = ((PsiClass)resolved).getQualifiedName()) != null) {
                        this.$imported.add(qualifiedName);
                    }
                }
                return super.visitImportStatement(node);
            }

            private final String getImportAlias(String qualified) {
                Object object;
                if (qualified != null && this.$imported.contains(qualified)) {
                    object = this.$aliasNames.get(qualified);
                    if (object == null) {
                        int n = this.$aliasNames.size() + 1;
                        String string = qualified.substring(StringsKt.lastIndexOf$default((CharSequence)qualified, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        Object object2 = string;
                        Locale locale = Locale.US;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                        String string2 = ((String)object2).toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                        object2 = "IMPORT_ALIAS_" + n + "_" + string2;
                        LinkedHashMap<String, String> linkedHashMap = this.$aliasNames;
                        Object it = object2;
                        boolean bl = false;
                        ((Map)linkedHashMap).put(qualified, it);
                        object = object2;
                    }
                } else {
                    object = null;
                }
                return object;
            }

            public void checkTypeReference(@NotNull UElement node, @Nullable PsiClass cls, int offset, @NotNull PsiType type) {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                    Object object = node.getSourcePsi();
                    if (object == null || (object = object.getText()) == null || (object = StringsKt.substringBefore$default((String)object, (char)'<', null, (int)2, null)) == null) {
                        return;
                    }
                    Object typeText = object;
                    if (StringsKt.isBlank((CharSequence)((CharSequence)typeText))) {
                        return;
                    }
                    PsiElement psiElement = node.getSourcePsi();
                    Object object2 = psiElement != null ? psiElement.getTextRange() : null;
                    if (object2 == null) {
                        return;
                    }
                    TextRange range = object2;
                    if (type instanceof PsiArrayType && !(type instanceof PsiEllipsisType) && cls != null) {
                        String string = this.getImportAlias(cls.getQualifiedName());
                        if (string != null) {
                            String string2 = string;
                            Map<Integer, Edit> map = this.$editMap;
                            String aliasName = string2;
                            boolean bl = false;
                            Integer n = offset;
                            map.put(n, UastSourceTransformationTestMode.EditVisitor.replace$default(this, range.getStartOffset(), range.getEndOffset(), "Array<" + aliasName + ">", false, 8, null));
                        }
                        return;
                    }
                    if (!(type instanceof PsiClassType)) break block6;
                    PsiClass psiClass = cls;
                    String qualified = psiClass != null ? psiClass.getQualifiedName() : null;
                    String string = this.getImportAlias(qualified);
                    if (string != null) {
                        String string3 = string;
                        Map<Integer, Edit> map = this.$editMap;
                        String aliasName = string3;
                        boolean bl = false;
                        Integer n = offset;
                        map.put(n, UastSourceTransformationTestMode.EditVisitor.replace$default(this, range.getStartOffset(), Math.min(range.getEndOffset(), range.getStartOffset() + ((String)typeText).length()), (String)(StringsKt.endsWith$default((String)typeText, (String)"?", (boolean)false, (int)2, null) ? aliasName + "?" : (StringsKt.endsWith$default((String)typeText, (String)"!!", (boolean)false, (int)2, null) ? aliasName + "!!" : aliasName)), false, 8, null));
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public void afterVisitFile(@NotNull UFile node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!((Map)this.$aliasNames).isEmpty()) {
                    void $this$mapTo$iv$iv;
                    Object object;
                    int n;
                    UImportStatement uImportStatement = (UImportStatement)CollectionsKt.lastOrNull((List)node.getImports());
                    if (uImportStatement != null && (uImportStatement = UastUtils.getTextRange((UElement)((UElement)uImportStatement))) != null) {
                        n = uImportStatement.getEndOffset();
                    } else {
                        UClass uClass = (UClass)CollectionsKt.firstOrNull((List)node.getClasses());
                        if (uClass != null && (uClass = uClass.getTextRange()) != null) {
                            n = uClass.getStartOffset();
                        } else {
                            transform.1 var8_2 = this;
                            object = this.$source;
                            transform.1 $this$afterVisitFile_u24lambda_u243 = var8_2;
                            boolean bl = false;
                            int index = StringsKt.indexOf$default((CharSequence)((CharSequence)object), (String)node.getPackageName(), (int)0, (boolean)false, (int)6, null);
                            int end = index + node.getPackageName().length();
                            n = StringsKt.indexOf$default((CharSequence)((CharSequence)object), (char)'\n', (int)end, (boolean)false, (int)4, null) + 1;
                        }
                    }
                    int start = n;
                    Map $this$map$iv = this.$aliasNames;
                    boolean $i$f$map = false;
                    Map map = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                    boolean $i$f$mapTo = false;
                    object = $this$mapTo$iv$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry item$iv$iv;
                        Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String type = (String)entry.getKey();
                        String name = (String)entry.getValue();
                        collection.add("import " + type + " as " + name);
                    }
                    String aliases = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    Integer n2 = start;
                    this.$editMap.put(n2, UastSourceTransformationTestMode.EditVisitor.insert$default(this, start, "\n" + aliases, false, 4, null));
                }
                super.afterVisitFile(node);
            }

            public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiClass cls = this.$context.getEvaluator().getTypeClass(node.getType());
                if (cls instanceof PsiTypeParameter) {
                    return true;
                }
                return super.visitClassLiteralExpression(node);
            }
        }));
        return CollectionsKt.toMutableList(editMap.values());
    }

    @Override
    public boolean messagesMatch(@NotNull String original, @NotNull String modified) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        if (Intrinsics.areEqual((Object)original, (Object)modified)) {
            return true;
        }
        int index = StringsKt.indexOf$default((CharSequence)modified, (String)"IMPORT_ALIAS_", (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return false;
        }
        return StringsKt.regionMatches$default((String)original, (int)0, (String)modified, (int)0, (int)index, (boolean)false, (int)16, null);
    }
}

