/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J:\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00180\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/infrastructure/IfToWhenTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "getIndent", "source", "offset", "", "isRelevantFile", "", "file", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "lint-tests"})
public final class IfToWhenTestMode
extends UastSourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n        You can often rewrite a series of\n        if-then-else expressions into a single when statement (or in some\n        cases, a switch statement in Java). These have a different structure\n        in the AST. This test mode will convert some if-then-else statements\n        into when or switch blocks to make sure that the detector is properly\n        handling both forms, e.g. handling both `UIfExpression` and\n        `USwitchExpression`.\n\n        In the unlikely event that your lint check is actually doing something\n        specific to if/else expressions, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));

    public IfToWhenTestMode() {
        super("Converting if/else to when/switch", "TestMode.IF_TO_WHEN", "if_to_when");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    protected boolean isRelevantFile(@NotNull TestFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.targetRelativePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
        return StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        if (!Lint.isKotlin((Language)root.getLang())) {
            return new ArrayList();
        }
        LinkedHashSet<PsiElement> seen = new LinkedHashSet<PsiElement>();
        List edits = new ArrayList();
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new UastSourceTransformationTestMode.EditVisitor(seen, this, source2, edits){
            final /* synthetic */ LinkedHashSet<PsiElement> $seen;
            final /* synthetic */ IfToWhenTestMode this$0;
            final /* synthetic */ String $source;
            final /* synthetic */ List<Edit> $edits;
            {
                this.$seen = $seen;
                this.this$0 = $receiver;
                this.$source = $source;
                this.$edits = $edits;
            }

            public boolean visitIfExpression(@NotNull UIfExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement $this$getParentOfType_u24default$iv = (UElement)node;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                if (UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv) == null) {
                    this.rewriteIfElse(node);
                }
                return super.visitIfExpression(node);
            }

            private final void rewriteIfElse(UIfExpression ifExpression) {
                UExpression next;
                PsiElement psiElement = ifExpression.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement sourcePsi = psiElement;
                if (!this.$seen.add(sourcePsi)) {
                    return;
                }
                List cases = new ArrayList<E>();
                UIfExpression curr = ifExpression;
                while (true) {
                    cases.add(new Pair((Object)curr.getCondition(), (Object)curr.getThenExpression()));
                    next = curr.getElseExpression();
                    if (!(next instanceof UIfExpression)) break;
                    curr = (UIfExpression)next;
                }
                if (next != null) {
                    cases.add(new Pair(null, (Object)next));
                }
                int startOffset = PsiUtilsKt.getStartOffset((PsiElement)sourcePsi);
                int endOffset = PsiUtilsKt.getEndOffset((PsiElement)sourcePsi);
                StringBuilder sb = new StringBuilder();
                String indent = IfToWhenTestMode.access$getIndent(this.this$0, this.$source, startOffset);
                sb.append("when {\n");
                for (Pair pair : cases) {
                    UExpression condition = (UExpression)pair.component1();
                    UExpression body = (UExpression)pair.component2();
                    sb.append(indent);
                    if (condition == null) {
                        sb.append("else -> ");
                    } else {
                        PsiElement psiElement2 = condition.getSourcePsi();
                        sb.append(psiElement2 != null ? psiElement2.getText() : null).append(" -> ");
                    }
                    if (body != null) {
                        PsiElement psiElement3 = body.getSourcePsi();
                        sb.append(psiElement3 != null ? psiElement3.getText() : null);
                    }
                    sb.append("\n");
                }
                if (StringsKt.endsWith$default((CharSequence)sb, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    sb.setLength(sb.length() - 1);
                }
                sb.append("\n" + indent + "}");
                Intrinsics.checkNotNullExpressionValue((Object)this.$source.substring(startOffset, endOffset), (String)"substring(...)");
                UastSourceTransformationTestMode.EditVisitor editVisitor = this;
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.$edits.add(UastSourceTransformationTestMode.EditVisitor.replace$default(editVisitor, startOffset, endOffset, string, false, 8, null));
            }
        }));
        return edits;
    }

    private final String getIndent(String source2, int offset) {
        char c;
        StringBuilder sb = new StringBuilder();
        for (int curr = offset - 1; curr >= 0 && (c = source2.charAt(curr)) != '\n'; --curr) {
            if (CharsKt.isWhitespace((char)c)) {
                sb.append(c);
                continue;
            }
            StringsKt.clear((StringBuilder)sb);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static final /* synthetic */ String access$getIndent(IfToWhenTestMode $this, String source2, int offset) {
        return $this.getIndent(source2, offset);
    }
}

