/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/infrastructure/Edit;", "", "startOffset", "", "endOffset", "with", "", "biasRight", "", "ordinal", "(IILjava/lang/String;ZI)V", "getEndOffset", "()I", "getStartOffset", "getWith", "()Ljava/lang/String;", "compareTo", "other", "toString", "Companion", "lint-tests"})
public final class Edit
implements Comparable<Edit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private final String with;
    private final boolean biasRight;
    private final int ordinal;
    private static int nextOrdinal;

    public Edit(int startOffset, int endOffset, @NotNull String with, boolean biasRight, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.with = with;
        this.biasRight = biasRight;
        this.ordinal = ordinal;
    }

    public /* synthetic */ Edit(int n, int n2, String string, boolean bl, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            bl = false;
        }
        if ((n4 & 0x10) != 0) {
            int n5 = nextOrdinal;
            nextOrdinal = n5 + 1;
            n3 = n5;
        }
        this(n, n2, string, bl, n3);
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    @NotNull
    public final String getWith() {
        return this.with;
    }

    @Override
    public int compareTo(@NotNull Edit other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int offsetDelta = other.startOffset - this.startOffset;
        if (offsetDelta != 0) {
            return offsetDelta;
        }
        int biasDelta = (other.biasRight ? 1 : 0) - (this.biasRight ? 1 : 0);
        if (biasDelta != 0) {
            return biasDelta;
        }
        int ordinalDelta = this.ordinal - other.ordinal;
        return this.biasRight ? -ordinalDelta : ordinalDelta;
    }

    @NotNull
    public String toString() {
        return "Edit(" + this.startOffset + "," + this.endOffset + ",\"" + this.with + "\"," + this.ordinal + (this.biasRight ? "" : ",left") + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\u00020\f*\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/infrastructure/Edit$Companion;", "", "()V", "nextOrdinal", "", "performEdits", "", "source", "edits", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "conflicts", "", "other", "otherEdits", "lint-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String performEdits(@NotNull String source2, @NotNull List<Edit> edits) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            Intrinsics.checkNotNullParameter(edits, (String)"edits");
            Object s = source2;
            for (Edit edit : CollectionsKt.sorted((Iterable)edits)) {
                String string = ((String)s).substring(0, edit.getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = edit.getWith();
                String string3 = ((String)s).substring(edit.getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                s = string + string2 + string3;
            }
            return s;
        }

        private final boolean conflicts(Edit $this$conflicts, Edit other) {
            if (other.getStartOffset() > $this$conflicts.getEndOffset()) {
                return false;
            }
            return other.getEndOffset() >= $this$conflicts.getStartOffset();
        }

        public final boolean conflicts(@NotNull List<Edit> $this$conflicts, @NotNull List<Edit> otherEdits) {
            Intrinsics.checkNotNullParameter($this$conflicts, (String)"<this>");
            Intrinsics.checkNotNullParameter(otherEdits, (String)"otherEdits");
            for (Edit edit : $this$conflicts) {
                for (Edit other : otherEdits) {
                    if (!this.conflicts(edit, other)) continue;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

