/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.TestLintTask;
import com.android.tools.lint.checks.infrastructure.TestMode;
import com.android.tools.lint.detector.api.Issue;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J,\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016Rb\u0010\u0003\u001aV\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b0\u0004j*\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/infrastructure/DuplicateProjectFinder;", "", "()V", "checksums", "Ljava/util/HashMap;", "Lcom/android/tools/lint/checks/infrastructure/TestMode;", "", "", "Lkotlin/collections/HashMap;", "hashFiles", "", "hasher", "Lcom/google/common/hash/Hasher;", "root", "Ljava/io/File;", "relative", "recordTestProject", "name", "task", "Lcom/android/tools/lint/checks/infrastructure/TestLintTask;", "mode", "projects", "", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nDuplicateProjectFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateProjectFinder.kt\ncom/android/tools/lint/checks/infrastructure/DuplicateProjectFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,89:1\n1045#2:90\n1045#2:91\n1#3:92\n6442#4:93\n*S KotlinDebug\n*F\n+ 1 DuplicateProjectFinder.kt\ncom/android/tools/lint/checks/infrastructure/DuplicateProjectFinder\n*L\n52#1:90\n59#1:91\n75#1:93\n*E\n"})
public final class DuplicateProjectFinder {
    @NotNull
    private final HashMap<TestMode, HashMap<Long, String>> checksums = new HashMap();

    public final void recordTestProject(@NotNull String name, @NotNull TestLintTask task, @NotNull TestMode mode, @NotNull List<? extends File> projects) {
        HashMap<Long, String> modeChecksums;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        HashFunction hashFunction = Hashing.farmHashFingerprint64();
        Hasher hasher = hashFunction.newHasher();
        Iterable $this$sortedBy$iv = projects;
        boolean $i$f$sortedBy = false;
        for (File root : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            Intrinsics.checkNotNull((Object)hasher);
            String string = root.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.hashFiles(hasher, root, string);
        }
        hasher.putString((CharSequence)mode.getDescription(), Charsets.UTF_8);
        List<Issue> list2 = task.getCheckedIssues();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getCheckedIssues(...)");
        $this$sortedBy$iv = list2;
        $i$f$sortedBy = false;
        for (Issue issue : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Issue it = (Issue)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (Issue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        })) {
            hasher.putString((CharSequence)issue.getId(), Charsets.UTF_8);
        }
        HashCode hashCode = hasher.hash();
        long checksum = hashCode.asLong();
        HashMap<Long, String> hashMap = this.checksums.get(mode);
        if (hashMap == null) {
            HashMap hashMap2;
            HashMap it = hashMap2 = new HashMap();
            boolean bl = false;
            ((Map)this.checksums).put(mode, it);
            hashMap = hashMap2;
        }
        if ((modeChecksums = hashMap).get(checksum) != null) {
            System.out.println((Object)("** Duplicate projects: " + name + " and " + modeChecksums.get(checksum) + " in mode " + mode));
        }
        Long l = checksum;
        ((Map)modeChecksums).put(l, name);
    }

    private final void hashFiles(Hasher hasher, File root, String relative) {
        Object[] listFiles;
        Object[] objectArray = root.listFiles();
        if (objectArray == null) {
            return;
        }
        Object[] $this$sortedBy$iv = listFiles = objectArray;
        boolean $i$f$sortedBy = false;
        for (File file : ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        })) {
            boolean bl;
            if (file.isDirectory()) {
                Intrinsics.checkNotNull((Object)file);
                this.hashFiles(hasher, file, relative + "/" + file.getName());
                continue;
            }
            if (!file.isFile()) continue;
            Hasher newHasher = hasher.putString((CharSequence)file.getName(), Charsets.UTF_8);
            boolean bl2 = bl = hasher == newHasher;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Intrinsics.checkNotNull((Object)file);
            String contents = FilesKt.readText$default((File)file, null, (int)1, null);
            hasher.putString((CharSequence)contents, Charsets.UTF_8);
        }
    }
}

