/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.SdkConstants;
import com.android.tools.lint.checks.infrastructure.BytecodeTestFile;
import com.android.tools.lint.checks.infrastructure.CompiledSourceFile;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.TestFiles;
import com.google.common.base.Joiner;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eJ\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000eH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0018H\u0016J$\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u0004H\u0002J\b\u0010%\u001a\u00020\u0018H\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010$\u001a\u00020\u0004H\u0002J \u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u00180(j\b\u0012\u0004\u0012\u00020\u0018`)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J(\u0010+\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u000e0\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0016J\u001e\u0010-\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eJ\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0016J \u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0006\u00105\u001a\u00020\u0016R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00067"}, d2={"Lcom/android/tools/lint/checks/infrastructure/CompiledSourceFile;", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "Lcom/android/tools/lint/checks/infrastructure/BytecodeTestFile;", "into", "", "type", "Lcom/android/tools/lint/checks/infrastructure/BytecodeTestFile$Type;", "source", "checksum", "", "encodedFiles", "", "(Ljava/lang/String;Lcom/android/tools/lint/checks/infrastructure/BytecodeTestFile$Type;Lcom/android/tools/lint/checks/infrastructure/TestFile;Ljava/lang/Long;[Ljava/lang/String;)V", "bytecodeFiles", "", "Ljava/lang/Long;", "[Ljava/lang/String;", "getSource", "()Lcom/android/tools/lint/checks/infrastructure/TestFile;", "getType", "()Lcom/android/tools/lint/checks/infrastructure/BytecodeTestFile$Type;", "compile", "", "projectDir", "Ljava/io/File;", "externalJars", "computeCheckSum", "", "binaries", "", "createBytecodeFiles", "createFile", "targetDir", "describeTestFiles", "Lkotlin/Pair;", "classesDir", "target", "findAndroidJar", "findCompilers", "findJars", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "findOnPath", "findSourceFiles", "getBytecodeFiles", "getClassPath", "extraJars", "getGeneratedPaths", "getPackagedFiles", "getSources", "isClassForSource", "file", "bytes", "isMissingClasses", "Companion", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nCompiledSourceFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledSourceFile.kt\ncom/android/tools/lint/checks/infrastructure/CompiledSourceFile\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,599:1\n37#2,2:600\n1549#3:602\n1620#3,3:603\n1855#3,2:606\n1855#3,2:608\n1855#3,2:610\n1045#3:612\n1549#3:613\n1620#3,3:614\n766#3:617\n857#3,2:618\n1549#3:620\n1620#3,3:621\n1045#3:625\n1549#3:626\n1620#3,3:627\n1#4:624\n*S KotlinDebug\n*F\n+ 1 CompiledSourceFile.kt\ncom/android/tools/lint/checks/infrastructure/CompiledSourceFile\n*L\n95#1:600,2\n128#1:602\n128#1:603,3\n170#1:606,2\n171#1:608,2\n185#1:610,2\n368#1:612\n369#1:613\n369#1:614,3\n370#1:617\n370#1:618,2\n372#1:620\n372#1:621,3\n465#1:625\n466#1:626\n466#1:627,3\n*E\n"})
public final class CompiledSourceFile
extends TestFile
implements BytecodeTestFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BytecodeTestFile.Type type;
    @NotNull
    private final TestFile source;
    @Nullable
    private final Long checksum;
    @NotNull
    private final String[] encodedFiles;
    @Nullable
    private List<? extends TestFile> bytecodeFiles;

    public CompiledSourceFile(@NotNull String into, @NotNull BytecodeTestFile.Type type, @NotNull TestFile source2, @Nullable Long checksum, @NotNull String[] encodedFiles) {
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)encodedFiles, (String)"encodedFiles");
        this.type = type;
        this.source = source2;
        this.checksum = checksum;
        this.encodedFiles = encodedFiles;
        this.to(TestFile.isComponent(into) ? TestFile.componentToJar(into) : into);
    }

    @Override
    @NotNull
    public BytecodeTestFile.Type getType() {
        return this.type;
    }

    @NotNull
    public final TestFile getSource() {
        return this.source;
    }

    @NotNull
    public final List<TestFile> getPackagedFiles() {
        ArrayList<TestFile> files2 = new ArrayList<TestFile>((Collection)this.getBytecodeFiles());
        if (this.getType() == BytecodeTestFile.Type.RESOURCE) {
            files2.add(this.source);
        }
        return files2;
    }

    private final int computeCheckSum(String source2, List<byte[]> binaries) {
        HashFunction hashFunction = Hashing.sha256();
        Hasher hasher = hashFunction.newHasher();
        hasher.putString((CharSequence)source2, Charsets.UTF_8);
        for (byte[] bytes2 : binaries) {
            hasher.putBytes(bytes2);
        }
        HashCode hashCode = hasher.hash();
        return hashCode.asInt();
    }

    @Override
    @NotNull
    public File createFile(@NotNull File targetDir) throws IOException {
        File file;
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        if (this.getType() == BytecodeTestFile.Type.SOURCE_AND_BYTECODE) {
            String path = this.source.targetRelativePath;
            Intrinsics.checkNotNull((Object)path);
            if (StringsKt.endsWith$default((String)path, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)".kt", (boolean)false, (int)2, null)) {
                this.source.createFile(targetDir);
            }
        }
        List<TestFile> files2 = this.getPackagedFiles();
        Collection $this$toTypedArray$iv = files2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TestFile[] array = thisCollection$iv.toArray(new TestFile[0]);
        String string = this.targetRelativePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            File file2 = new TestFile.JarTestFile(this.targetRelativePath).files(Arrays.copyOf(array, array.length)).createFile(targetDir);
            Intrinsics.checkNotNull((Object)file2);
            file = file2;
        } else {
            for (TestFile testFile : array) {
                testFile.createFile(targetDir);
            }
            file = new File(this.targetRelativePath);
        }
        return file;
    }

    public final boolean isMissingClasses() {
        if (this.getType() == BytecodeTestFile.Type.RESOURCE) {
            return false;
        }
        return this.encodedFiles.length == 0 || this.encodedFiles.length == 1 && ((CharSequence)this.encodedFiles[0]).length() == 0;
    }

    @Override
    @NotNull
    public List<TestFile> getSources() {
        return CollectionsKt.listOf((Object)this.source);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getGeneratedPaths() {
        List list2;
        String string = this.targetRelativePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            list2 = CollectionsKt.listOf((Object)this.targetRelativePath);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getBytecodeFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TestFile testFile = (TestFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.targetRelativePath);
            }
            list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        return list2;
    }

    public final boolean compile(@NotNull File projectDir, @NotNull List<String> externalJars) {
        File it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        ArrayList<Object> args;
        Pair<List<File>, List<File>> pair;
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(externalJars, (String)"externalJars");
        if (!this.isMissingClasses()) {
            return false;
        }
        String string = this.source.targetRelativePath;
        if (string == null) {
            return false;
        }
        String target = string;
        Pair<String, String> pair2 = this.findCompilers(target);
        String kotlinc = (String)pair2.component1();
        String javac = (String)pair2.component2();
        String classpath2 = this.getClassPath(projectDir, externalJars);
        try {
            pair = Files.createTempDirectory("classes", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create temporary folder for classes".toString());
        }
        Pair<List<File>, List<File>> classesDir = pair;
        pair = this.findSourceFiles(projectDir);
        List javaFiles = (List)pair.component1();
        List kotlinFiles = (List)pair.component2();
        if (javaFiles.isEmpty() && kotlinFiles.isEmpty()) {
            return false;
        }
        if (!((Collection)kotlinFiles).isEmpty()) {
            args = new ArrayList<Object>();
            args.add(kotlinc);
            args.add("-classpath");
            args.add(classpath2);
            args.add("-d");
            args.add(classesDir.getPath());
            $this$forEach$iv = kotlinFiles;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                boolean bl = false;
                args.add(it.getPath());
            }
            $this$forEach$iv = javaFiles;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                boolean bl = false;
                args.add(it.getPath());
            }
            Companion.executeProcess$lint_tests((List<String>)args);
        }
        if (!((Collection)javaFiles).isEmpty()) {
            args = new ArrayList();
            args.add(javac);
            args.add("-classpath");
            args.add(classesDir.getPath() + File.pathSeparator + classpath2);
            args.add("-d");
            args.add(classesDir.getPath());
            $this$forEach$iv = javaFiles;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (File)element$iv;
                boolean bl = false;
                args.add(it.getPath());
            }
            Companion.executeProcess$lint_tests((List<String>)args);
        }
        Intrinsics.checkNotNull(classesDir);
        Pair<String, String> pair3 = this.describeTestFiles((File)classesDir, target);
        String kotlinTestFile = (String)pair3.component1();
        String javaTestFile = (String)pair3.component2();
        Assert.fail((String)("Update the test source declaration for " + this.source.targetRelativePath + " with this list of encodings:\n\n" + kotlinTestFile + "\n\n" + javaTestFile));
        return true;
    }

    private final Pair<List<File>, List<File>> findSourceFiles(File projectDir) {
        FilenameFilter javaFilter2 = findSourceFiles.javaFilter.1.INSTANCE;
        FilenameFilter kotlinFilter2 = findSourceFiles.kotlinFilter.1.INSTANCE;
        File src = new File(projectDir, "src");
        List javaFiles = CompiledSourceFile.Companion.findFiles(src, javaFilter2);
        List kotlinFiles = CompiledSourceFile.Companion.findFiles(src, kotlinFilter2);
        return new Pair((Object)javaFiles, (Object)kotlinFiles);
    }

    private final String getClassPath(File projectDir, List<String> extraJars) {
        ArrayList<File> jars = this.findJars(projectDir);
        String string = Joiner.on((String)File.pathSeparator).join((Iterable)CollectionsKt.plus((Collection)jars, (Iterable)extraJars));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    private final ArrayList<File> findJars(File projectDir) {
        File androidJar = this.findAndroidJar();
        FilenameFilter jarFilter2 = findJars.jarFilter.1.INSTANCE;
        ArrayList<File> jars = new ArrayList<File>();
        jars.add(androidJar);
        jars.addAll(CompiledSourceFile.Companion.findFiles(new File(projectDir, "libs"), jarFilter2));
        jars.addAll(CompiledSourceFile.Companion.findFiles(new File(projectDir, "bin/classes"), jarFilter2));
        return jars;
    }

    private final File findAndroidJar() {
        File[] fileArray;
        String string;
        String string2 = System.getenv("ANDROID_SDK_ROOT");
        if (string2 == null) {
            string2 = System.getenv("ANDROID_HOME");
        }
        if ((string = string2) == null) {
            throw new IllegalStateException("Couldn't find an Android SDK environment to compile with; set $ANDROID_SDK_ROOT".toString());
        }
        String sdkHome = string;
        if (!new File(sdkHome).isDirectory()) {
            Assert.fail((String)(sdkHome + " is not a directory"));
        }
        if ((fileArray = new File(sdkHome, "platforms").listFiles(findAndroidJar.platforms.1.INSTANCE)) == null) {
            throw new IllegalStateException("Couldn't find platforms".toString());
        }
        File[] platforms2 = fileArray;
        Arrays.sort(platforms2, findAndroidJar.1.INSTANCE);
        File platform = platforms2[platforms2.length - 1];
        File androidJar = new File(platform, "android.jar");
        Assert.assertTrue((boolean)androidJar.isFile());
        return androidJar;
    }

    private final String findOnPath(String target) {
        Object object;
        block4: {
            block3: {
                object = System.getenv("PATH");
                if (object == null) break block3;
                CharSequence charSequence = (CharSequence)object;
                String[] stringArray = new String[1];
                Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
                object = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                if (object != null) break block4;
            }
            return null;
        }
        Object path = object;
        Iterator iterator = path.iterator();
        while (iterator.hasNext()) {
            String binDir = (String)iterator.next();
            File file = new File(binDir + File.separator + target);
            if (!file.isFile()) continue;
            return file.getPath();
        }
        return null;
    }

    private final Pair<String, String> findCompilers(String target) {
        Object object;
        String string;
        boolean isWindows = SdkConstants.currentPlatform() == 2;
        String string2 = System.getenv("LINT_TEST_KOTLINC");
        if (string2 == null && (string2 = this.findOnPath("kotlinc" + (isWindows ? ".bat" : ""))) == null) {
            throw new IllegalStateException(("Couldn't find kotlinc to update test file " + target + " with. Point to it with $LINT_TEST_KOTLINC").toString());
        }
        String kotlinc = string2;
        if (!new File(kotlinc).isFile()) {
            Assert.fail((String)(kotlinc + " is not a file"));
        }
        if (!new File(kotlinc).canExecute()) {
            Assert.fail((String)(kotlinc + " is not executable"));
        }
        if ((string = System.getenv("LINT_TEST_JAVAC")) == null) {
            CompiledSourceFile $this$findCompilers_u24lambda_u244 = this;
            boolean bl = false;
            String javaHome = System.getenv("JAVA_HOME");
            if (javaHome == null) {
                throw new IllegalStateException(("Couldn't find javac to update test file " + target + " with. Point to it with $LINT_TEST_JAVAC").toString());
            }
            String it = javaHome + "/bin/javac";
            boolean bl2 = false;
            object = isWindows && !StringsKt.endsWith$default((String)it, (String)".bat", (boolean)false, (int)2, null) ? it + ".bat" : it;
        } else {
            object = string;
        }
        String javac = object;
        return new Pair((Object)kotlinc, (Object)javac);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, String> describeTestFiles(File classesDir, String target) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Pair it;
        Object object;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Iterable $this$sortedBy$iv;
        Object line22;
        StringBuilder kotlin = new StringBuilder("Kotlin:\n");
        StringBuilder java = new StringBuilder("Java:\n");
        int indent = 4;
        StringBuilder declaration = new StringBuilder();
        CompiledSourceFile.describeTestFiles$indent(declaration, indent);
        declaration.append(this.getType() == BytecodeTestFile.Type.SOURCE_AND_BYTECODE ? "compiled" : "bytecode");
        declaration.append("(\n");
        CompiledSourceFile.describeTestFiles$indent(declaration, ++indent);
        declaration.append('\"').append(this.targetRelativePath).append("\",\n");
        CompiledSourceFile.describeTestFiles$indent(declaration, indent);
        String string = this.source.targetRelativePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
        if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) {
            declaration.append("java");
        } else {
            declaration.append("kotlin");
        }
        declaration.append("(");
        ++indent;
        kotlin.append(declaration.toString());
        java.append(declaration.toString());
        String string2 = this.source.contents;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contents");
        String[] stringArray = new String[]{"\n"};
        List lines2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)string2, (char)'$', (char)'\uff04', (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        StringBuilder stringBuilder = CompiledSourceFile.describeTestFiles$indent(kotlin, indent).append("\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        CompiledSourceFile.describeTestFiles$indent(stringBuilder, indent).append("\"\"\"\n");
        StringBuilder stringBuilder2 = CompiledSourceFile.describeTestFiles$indent(java, indent).append("\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        CompiledSourceFile.describeTestFiles$indent(stringBuilder2, indent).append("\"\"\n");
        for (Object line22 : lines2) {
            if (!StringsKt.isBlank((CharSequence)((CharSequence)line22))) {
                CompiledSourceFile.describeTestFiles$indent(kotlin, indent);
                CompiledSourceFile.describeTestFiles$indent(java, indent);
            }
            kotlin.append((String)line22).append('\n');
            java.append("+ \"");
            java.append(StringsKt.replace$default((String)StringsKt.replace$default((String)line22, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null));
            java.append("\\n\"\n");
        }
        CompiledSourceFile.describeTestFiles$indent(kotlin, indent).append("\"\"\"\n");
        CompiledSourceFile.describeTestFiles$indent(kotlin, --indent).append(").indented(),\n");
        CompiledSourceFile.describeTestFiles$indent(java, indent).append(").indented(),\n");
        line22 = CompiledSourceFile.Companion.findFiles(classesDir, new FilenameFilter(target){
            final /* synthetic */ String $target;
            {
                this.$target = $target;
            }

            public final boolean accept(@NotNull File file, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.$target, (String)".kt", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name, (String)".kotlin_module", (boolean)false, (int)2, null);
            }
        });
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                it = (File)b;
                Comparable comparable = (Comparable)((Object)StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
                bl = false;
                String string2 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)StringsKt.replace$default((String)string2, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null))));
            }
        });
        boolean $i$f$map = false;
        void var11_13 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            File file = (File)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new Pair((Object)it, (Object)FilesKt.readBytes((File)it)));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$filter22 = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!this.isClassForSource((File)it.getFirst(), (byte[])it.getSecond(), target)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List binaryFiles2 = (List)destination$iv$iv;
        String string3 = this.source.contents;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"contents");
        Iterable $i$f$filter22 = binaryFiles2;
        String string4 = string3;
        object = this;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((byte[])it2.getSecond());
        }
        collection = (List)destination$iv$iv2;
        int checksum = super.computeCheckSum(string4, CollectionsKt.toList((Iterable)collection));
        String checksumString = "0x" + Integer.toHexString(checksum);
        CompiledSourceFile.describeTestFiles$indent(kotlin, indent).append(checksumString).append(",\n");
        CompiledSourceFile.describeTestFiles$indent(java, indent).append(checksumString).append(",\n");
        boolean first = true;
        for (Pair pair : binaryFiles2) {
            String path;
            String string5;
            File binaryFile = (File)pair.component1();
            byte[] bytes2 = (byte[])pair.component2();
            if (first) {
                first = false;
            } else {
                java.append(",\n");
                kotlin.append(",\n");
            }
            Intrinsics.checkNotNullExpressionValue((Object)binaryFile.getPath(), (String)"getPath(...)");
            int n = classesDir.getPath().length() + 1;
            Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n), (String)"substring(...)");
            CompiledSourceFile.describeTestFiles$indent(java, indent).append("\"").append(path).append(":\" +\n");
            java.append(TestFiles.toBase64gzipJava(bytes2, indent * 4, true, false));
            CompiledSourceFile.describeTestFiles$indent(kotlin, --indent).append("\"\"\"\n");
            CompiledSourceFile.describeTestFiles$indent(kotlin, indent).append(StringsKt.replace$default((String)path, (char)'$', (char)'\uff04', (boolean)false, (int)4, null)).append(":\n");
            kotlin.append(TestFiles.toBase64gzipKotlin(bytes2, indent * 4, true, false));
            CompiledSourceFile.describeTestFiles$indent(kotlin, indent).append("\"\"\"");
            ++indent;
        }
        StringBuilder stringBuilder3 = java.append("\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        CompiledSourceFile.describeTestFiles$indent(stringBuilder3, --indent).append(")\n");
        StringBuilder stringBuilder4 = kotlin.append("\n");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        CompiledSourceFile.describeTestFiles$indent(stringBuilder4, indent).append(")\n");
        String string6 = kotlin.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        String string7 = java.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        return new Pair((Object)string6, (Object)string7);
    }

    private final boolean isClassForSource(File file, byte[] bytes2, String target) {
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
            Object object;
            ClassReader reader = new ClassReader(bytes2);
            ClassNode classNode = new ClassNode(589824);
            reader.accept((ClassVisitor)classNode, 0);
            String className = classNode.name;
            Intrinsics.checkNotNull((Object)className);
            int pkgEnd = StringsKt.lastIndexOf$default((CharSequence)className, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (pkgEnd != -1) {
                String string2 = className.substring(0, pkgEnd);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String pkg = string2;
                object = pkg + "/" + classNode.sourceFile;
            } else {
                object = classNode.sourceFile;
            }
            String sourcePath = object;
            Intrinsics.checkNotNull((Object)sourcePath);
            if (!StringsKt.endsWith$default((String)target, (String)sourcePath, (boolean)false, (int)2, null)) {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public List<TestFile> getBytecodeFiles() {
        List<TestFile> list2 = this.bytecodeFiles;
        if (list2 == null) {
            List<TestFile> list3;
            List<TestFile> it = list3 = this.createBytecodeFiles();
            boolean bl = false;
            this.bytecodeFiles = it;
            list2 = list3;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TestFile> createBytecodeFiles() {
        Object producer2;
        ArrayList<TestFile.BinaryTestFile> classFiles = new ArrayList<TestFile.BinaryTestFile>();
        for (String originalEncoded : this.encodedFiles) {
            String encoded = StringsKt.trimIndent((String)originalEncoded);
            int index = StringsKt.indexOf$default((CharSequence)encoded, (char)':', (int)0, (boolean)false, (int)6, null);
            Assert.assertTrue((String)"Expected encoded binary file to start with a colon separated filename", (index != -1 ? 1 : 0) != 0);
            String string = encoded.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String path = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)string, (char)'\uff04', (char)'$', (boolean)false, (int)4, null))).toString();
            String string2 = encoded.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String bytes2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            producer2 = TestFiles.getByteProducerForBase64gzip(bytes2);
            String string3 = this.targetRelativePath;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"targetRelativePath");
            String target = StringsKt.endsWith$default((String)string3, (String)".jar", (boolean)false, (int)2, null) ? path : this.targetRelativePath + "/" + path;
            TestFile.BinaryTestFile classFile = new TestFile.BinaryTestFile(target, (TestFile.ByteProducer)producer2);
            classFiles.add(classFile);
        }
        if (this.checksum != null) {
            Collection<byte[]> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String originalEncoded;
            String string = this.source.contents;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contents");
            Iterable $this$sortedBy$iv = classFiles;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TestFile it = (TestFile)a;
                    boolean bl = false;
                    it = (TestFile)b;
                    Comparable comparable = (Comparable)((Object)it.targetRelativePath);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)it.targetRelativePath)));
                }
            });
            String string4 = string;
            CompiledSourceFile compiledSourceFile = this;
            boolean $i$f$map = false;
            originalEncoded = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                producer2 = (TestFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.android.tools.lint.checks.infrastructure.TestFile.BinaryTestFile");
                collection.add(((TestFile.BinaryTestFile)it).getBinaryContents());
            }
            collection = (List)destination$iv$iv;
            int actualChecksum = compiledSourceFile.computeCheckSum(string4, CollectionsKt.toList((Iterable)collection));
            if ((int)this.checksum.longValue() != actualChecksum) {
                Assert.fail((String)("The checksum does not match for " + this.source.targetRelativePath + ";\nexpected 0x" + Integer.toHexString((int)this.checksum.longValue()) + " but was 0x" + Integer.toHexString(actualChecksum) + ".\nHas the source file been changed without updating the binaries?\nDon't just update the checksum -- delete the binary file arguments and re-run the test first!"));
            }
        }
        return classFiles;
    }

    private static final StringBuilder describeTestFiles$indent(StringBuilder $this$describeTestFiles_u24indent, int length) {
        for (int i = 0; i < length; ++i) {
            $this$describeTestFiles_u24indent.append("    ");
        }
        return $this$describeTestFiles_u24indent;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u001b\u0010\u0010\u001a\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0000\u00a2\u0006\u0002\b\u0013J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/infrastructure/CompiledSourceFile$Companion;", "", "()V", "addFiles", "", "into", "", "Ljava/io/File;", "root", "filter", "Ljava/io/FilenameFilter;", "createFiles", "targetDir", "compiled", "", "Lcom/android/tools/lint/checks/infrastructure/CompiledSourceFile;", "executeProcess", "args", "", "executeProcess$lint_tests", "findFiles", "lint-tests"})
    @SourceDebugExtension(value={"SMAP\nCompiledSourceFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledSourceFile.kt\ncom/android/tools/lint/checks/infrastructure/CompiledSourceFile$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,599:1\n1#2:600\n37#3,2:601\n37#3,2:603\n*S KotlinDebug\n*F\n+ 1 CompiledSourceFile.kt\ncom/android/tools/lint/checks/infrastructure/CompiledSourceFile$Companion\n*L\n527#1:601,2\n541#1:603,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void createFiles(@NotNull File targetDir, @NotNull List<CompiledSourceFile> compiled) throws IOException {
            Map name;
            Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
            Intrinsics.checkNotNullParameter(compiled, (String)"compiled");
            HashSet<Object> paths = new HashSet<Object>();
            for (CompiledSourceFile testFile : compiled) {
                for (String string : testFile.encodedFiles) {
                    String encodedFile = StringsKt.trimIndent((String)string);
                    int end = StringsKt.indexOf$default((CharSequence)encodedFile, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (end == -1) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)encodedFile.substring(0, end), (String)"substring(...)");
                    if (paths.add(name) || StringsKt.endsWith$default((String)((Object)name), (String)".kotlin_module", (boolean)false, (int)2, null)) continue;
                    Assert.fail((String)("Path " + (String)((Object)name) + " is defined from more than one compiled test file"));
                }
            }
            Map targetMap = new HashMap();
            for (CompiledSourceFile compiledSourceFile : compiled) {
                List list2 = (List)targetMap.get(compiledSourceFile.targetRelativePath);
                if (list2 == null) {
                    ArrayList arrayList = new ArrayList();
                    ArrayList it = arrayList;
                    boolean bl = false;
                    name = targetMap;
                    String string = compiledSourceFile.targetRelativePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
                    name.put(string, it);
                    list2 = arrayList;
                }
                List list3 = list2;
                list3.add(compiledSourceFile);
            }
            for (Map.Entry entry : targetMap.entrySet()) {
                String target = (String)entry.getKey();
                List files2 = (List)entry.getValue();
                if (StringsKt.endsWith$default((String)target, (String)".jar", (boolean)false, (int)2, null) && files2.size() > 1) {
                    ArrayList arrayList = new ArrayList();
                    for (CompiledSourceFile file : files2) {
                        arrayList.addAll(file.getPackagedFiles());
                    }
                    Collection $this$toTypedArray$iv = arrayList;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    TestFile[] array = thisCollection$iv.toArray(new TestFile[0]);
                    new TestFile.JarTestFile(target).files(Arrays.copyOf(array, array.length)).createFile(targetDir);
                    continue;
                }
                for (CompiledSourceFile file : files2) {
                    file.createFile(targetDir);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void executeProcess$lint_tests(@NotNull List<String> args) {
            BufferedReader error;
            BufferedReader input;
            block11: {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                input = null;
                error = null;
                try {
                    String it;
                    String string;
                    Object $this$toTypedArray$iv = args;
                    boolean $i$f$toTypedArray22 = false;
                    Iterator<String> thisCollection$iv = $this$toTypedArray$iv;
                    Process process = Runtime.getRuntime().exec(thisCollection$iv.toArray(new String[0]));
                    InputStream inputStream = process.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    $this$toTypedArray$iv = inputStream;
                    Charset $i$f$toTypedArray22 = Charsets.UTF_8;
                    thisCollection$iv = new InputStreamReader((InputStream)$this$toTypedArray$iv, $i$f$toTypedArray22);
                    int n = 8192;
                    input = thisCollection$iv instanceof BufferedReader ? (BufferedReader)((Object)thisCollection$iv) : new BufferedReader((Reader)((Object)thisCollection$iv), n);
                    InputStream inputStream2 = process.getErrorStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
                    $this$toTypedArray$iv = inputStream2;
                    $i$f$toTypedArray22 = Charsets.UTF_8;
                    thisCollection$iv = new InputStreamReader((InputStream)$this$toTypedArray$iv, $i$f$toTypedArray22);
                    n = 8192;
                    error = thisCollection$iv instanceof BufferedReader ? (BufferedReader)((Object)thisCollection$iv) : new BufferedReader((Reader)((Object)thisCollection$iv), n);
                    int exitVal = process.waitFor();
                    if (exitVal == 0) break block11;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Failed to compile test sources\n");
                    sb.append("Command args:\n");
                    for (String arg : args) {
                        sb.append("  ").append(arg).append("\n");
                    }
                    sb.append("Standard output:\n");
                    String line2 = null;
                    while (true) {
                        it = string = input.readLine();
                        boolean bl = false;
                        line2 = it;
                        if (string == null) break;
                        sb.append(line2).append("\n");
                    }
                    sb.append("Error output:\n");
                    while (true) {
                        it = string = error.readLine();
                        boolean bl = false;
                        line2 = it;
                        if (string == null) break;
                        sb.append(line2).append("\n");
                    }
                    Assert.fail((String)sb.toString());
                }
                catch (Throwable t) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        for (String arg : args) {
                            sb.append("  ").append(arg).append("\n");
                        }
                        t.printStackTrace();
                        Assert.fail((String)("Could not run test compilation:\n" + sb));
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        BufferedReader bufferedReader = input;
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        BufferedReader bufferedReader2 = error;
                        if (bufferedReader2 != null) {
                            bufferedReader2.close();
                        }
                    }
                }
            }
            input.close();
            error.close();
        }

        private final List<File> findFiles(File root, FilenameFilter filter) {
            ArrayList files2 = new ArrayList();
            if (root.isDirectory()) {
                this.addFiles(files2, root, filter);
            }
            return files2;
        }

        private final void addFiles(List<File> into, File root, FilenameFilter filter) {
            if (!root.exists()) {
                return;
            }
            if (root.isDirectory()) {
                File[] fileArray = root.listFiles();
                if (fileArray == null) {
                    return;
                }
                for (File file : fileArray) {
                    Intrinsics.checkNotNull((Object)file);
                    this.addFiles(into, file, filter);
                }
            } else if (filter.accept(root.getParentFile(), root.getName())) {
                into.add(root);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

