/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000b\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"CLASS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "PACKAGE_PATTERN", "getClassName", "", "source", "getPackage", "stripComments", "extension", "stripLineComments", "", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nClassName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassName.kt\ncom/android/tools/lint/checks/infrastructure/ClassNameKt\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,190:1\n107#2:191\n79#2,22:192\n107#2:214\n79#2,22:215\n*S KotlinDebug\n*F\n+ 1 ClassName.kt\ncom/android/tools/lint/checks/infrastructure/ClassNameKt\n*L\n161#1:191\n161#1:192,22\n177#1:214\n177#1:215,22\n*E\n"})
public final class ClassNameKt {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+([\\S&&[^;]]*)");
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\bclass\\b|\\binterface\\b|\\benum class\\b|\\benum\\b|\\bobject\\b|\\brecord\\b)+?\\s*([^\\s:(]+)", 8);

    @NotNull
    public static final String stripComments(@NotNull String source2, @NotNull String extension, boolean stripLineComments) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        StringBuilder sb = new StringBuilder(source2.length());
        int state = 0;
        int INIT = 0;
        int INIT_SLASH = 1;
        int LINE_COMMENT = 2;
        int BLOCK_COMMENT = 3;
        int BLOCK_COMMENT_ASTERISK = 4;
        int BLOCK_COMMENT_SLASH = 5;
        int IN_STRING = 6;
        int IN_STRING_ESCAPE = 7;
        int IN_CHAR = 8;
        int AFTER_CHAR = 9;
        int blockCommentDepth = 0;
        int n = source2.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = source2.charAt(i);
            int n2 = state;
            if (n2 == 0) {
                c = c2;
                if (c == '/') {
                    state = INIT_SLASH;
                    continue;
                }
                if (c == '\"') {
                    state = IN_STRING;
                    sb.append(c2);
                    continue;
                }
                if (c == '\'') {
                    state = IN_CHAR;
                    sb.append(c2);
                    continue;
                }
                sb.append(c2);
                continue;
            }
            if (n2 == INIT_SLASH) {
                if (c2 == '*') {
                    ++blockCommentDepth;
                    state = BLOCK_COMMENT;
                    continue;
                }
                if (c2 == '/' && stripLineComments) {
                    state = LINE_COMMENT;
                    continue;
                }
                state = INIT;
                sb.append('/');
                sb.append(c2);
                continue;
            }
            if (n2 == LINE_COMMENT) {
                if (c2 != '\n') continue;
                state = INIT;
                continue;
            }
            if (n2 == BLOCK_COMMENT) {
                c = c2;
                if (c == '*') {
                    state = BLOCK_COMMENT_ASTERISK;
                    continue;
                }
                if (c != '/') continue;
                state = BLOCK_COMMENT_SLASH;
                continue;
            }
            if (n2 == BLOCK_COMMENT_ASTERISK) {
                c = c2;
                state = c == '/' ? (--blockCommentDepth == 0 ? INIT : BLOCK_COMMENT) : (c == '*' ? BLOCK_COMMENT_ASTERISK : BLOCK_COMMENT);
                continue;
            }
            if (n2 == BLOCK_COMMENT_SLASH) {
                if (c2 == '*' && Intrinsics.areEqual((Object)extension, (Object)".kt")) {
                    ++blockCommentDepth;
                }
                if (c2 == '/') continue;
                state = BLOCK_COMMENT;
                continue;
            }
            if (n2 == IN_STRING) {
                c = c2;
                if (c == '\\') {
                    state = IN_STRING_ESCAPE;
                } else if (c == '\"') {
                    state = INIT;
                }
                sb.append(c2);
                continue;
            }
            if (n2 == IN_STRING_ESCAPE) {
                sb.append(c2);
                state = IN_STRING;
                continue;
            }
            if (n2 == IN_CHAR) {
                if (c2 != '\\') {
                    state = AFTER_CHAR;
                }
                sb.append(c2);
                continue;
            }
            if (n2 != AFTER_CHAR) continue;
            sb.append(c2);
            if (c2 != '\'') continue;
            state = INIT;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String stripComments$default(String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ClassNameKt.stripComments(string, string2, bl);
    }

    @Nullable
    public static final String getPackage(@NotNull String source2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Matcher matcher = PACKAGE_PATTERN.matcher(source2);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            String $this$trim$iv = string2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String getClassName(@NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Matcher matcher = CLASS_PATTERN.matcher(StringsKt.replace$default((String)source2, (char)'\n', (char)' ', (boolean)false, (int)4, null));
        int start = 0;
        while (matcher.find(start)) {
            String cls = matcher.group(2);
            int groupStart = matcher.start(1);
            if (groupStart == 0 || source2.charAt(groupStart - 1) != '.' && source2.charAt(groupStart - 1) != ':') {
                String string;
                String trimmed;
                int typeParameter;
                Intrinsics.checkNotNull((Object)cls);
                String $this$trim$iv = cls;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if ((typeParameter = StringsKt.indexOf$default((CharSequence)(trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (char)'<', (int)0, (boolean)false, (int)6, null)) != -1) {
                    String string2 = trimmed.substring(0, typeParameter);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = trimmed;
                }
                return string;
            }
            start = matcher.end(2);
        }
        return null;
    }
}

