/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks.infrastructure;

import com.android.tools.lint.checks.infrastructure.Edit;
import com.android.tools.lint.checks.infrastructure.TestFile;
import com.android.tools.lint.checks.infrastructure.UastSourceTransformationTestMode;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0014J:\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/infrastructure/ArgumentReorderingTestMode;", "Lcom/android/tools/lint/checks/infrastructure/UastSourceTransformationTestMode;", "()V", "diffExplanation", "", "getDiffExplanation", "()Ljava/lang/String;", "escapeName", "", "name", "isRelevantFile", "file", "Lcom/android/tools/lint/checks/infrastructure/TestFile;", "transform", "", "Lcom/android/tools/lint/checks/infrastructure/Edit;", "source", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "root", "Lorg/jetbrains/uast/UFile;", "clientData", "", "", "lint-tests"})
@SourceDebugExtension(value={"SMAP\nArgumentReorderingTestMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentReorderingTestMode.kt\ncom/android/tools/lint/checks/infrastructure/ArgumentReorderingTestMode\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,175:1\n1083#2,2:176\n*S KotlinDebug\n*F\n+ 1 ArgumentReorderingTestMode.kt\ncom/android/tools/lint/checks/infrastructure/ArgumentReorderingTestMode\n*L\n168#1:176,2\n*E\n"})
public final class ArgumentReorderingTestMode
extends UastSourceTransformationTestMode {
    @NotNull
    private final String diffExplanation = StringsKt.trimIndent((String)("\n        In Kotlin, with named parameters,\n        callers are free to supply the arguments in a different order than\n        the parameter order in the method. Lint has support for looking up\n        the argument mapping; you should not just line the arguments and\n        parameters up one by one in order.\n\n        This test mode will arbitrarily reorder arguments (from Kotlin to\n        Kotlin, where named parameters are available) and make sure that\n        the test results are unaffected.\n\n        In the unlikely event that your lint check is actually doing something\n        argument order specific, you can turn off this test mode using\n        `.skipTestModes(" + this.getFieldName() + ")`.\n        "));

    public ArgumentReorderingTestMode() {
        super("Reordered Named Arguments", "TestMode.REORDER_ARGUMENTS", "reorder-arguments");
    }

    @Override
    @NotNull
    public String getDiffExplanation() {
        return this.diffExplanation;
    }

    @Override
    protected boolean isRelevantFile(@NotNull TestFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.targetRelativePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetRelativePath");
        return StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public List<Edit> transform(@NotNull String source2, @NotNull JavaContext context, @NotNull UFile root, @NotNull Map<String, Object> clientData) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(clientData, (String)"clientData");
        List edits = new ArrayList();
        UastLintUtilsKt.acceptSourceFile((UFile)root, (UastVisitor)((UastVisitor)new UastSourceTransformationTestMode.EditVisitor(context, edits, this){
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ List<Edit> $edits;
            final /* synthetic */ ArgumentReorderingTestMode this$0;
            {
                this.$context = $context;
                this.$edits = $edits;
                this.this$0 = $receiver;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod resolved = node.resolve();
                if (resolved != null && node.getValueArguments().size() > 1) {
                    this.checkCall(node, resolved);
                }
                return super.visitCallExpression(node);
            }

            /*
             * WARNING - void declaration
             */
            private final void checkCall(UCallExpression call, PsiMethod method) {
                block13: {
                    String $i$f$getParentOfType2;
                    if (method instanceof PsiCompiledElement) {
                        return;
                    }
                    if (!(method instanceof KtLightMember)) break block13;
                    Map argumentMapping = this.$context.getEvaluator().computeArgumentMapping(call, method);
                    List arguments = new ArrayList<E>();
                    for (UExpression argument : call.getValueArguments()) {
                        PsiElement psiElement;
                        block15: {
                            block14: {
                                void $this$getParentOfType$iv;
                                PsiElement psi = argument.getSourcePsi();
                                psiElement = psi;
                                if (psiElement == null) break block14;
                                PsiElement psiElement2 = psiElement;
                                boolean strict$iv = false;
                                boolean $i$f$getParentOfType2 = false;
                                psiElement = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv);
                                if (psiElement != null) break block15;
                            }
                            return;
                        }
                        PsiElement ktArgument = psiElement;
                        PsiParameter parameter = (PsiParameter)argumentMapping.get(argument);
                        KtLightElement ktLightElement = parameter instanceof KtLightElement ? (KtLightElement)parameter : null;
                        $i$f$getParentOfType2 = ktLightElement != null ? ktLightElement.getKotlinOrigin() : null;
                        KtParameter ktParameter = $i$f$getParentOfType2 instanceof KtParameter ? (KtParameter)$i$f$getParentOfType2 : null;
                        if (ktParameter == null) {
                            return;
                        }
                        KtParameter ktParameter2 = ktParameter;
                        if (ktParameter2.isVarArg()) {
                            return;
                        }
                        arguments.add(new Triple((Object)argument, (Object)ktArgument, (Object)ktParameter2));
                    }
                    int argumentCount = arguments.size();
                    for (int i = 0; i < argumentCount; ++i) {
                        Object object;
                        int j = (i + 1) % argumentCount;
                        Triple current = (Triple)arguments.get(i);
                        Triple next = (Triple)arguments.get(j);
                        KtValueArgument argument = (KtValueArgument)next.getSecond();
                        $i$f$getParentOfType2 = argument.getText();
                        ArgumentReorderingTestMode argumentReorderingTestMode = this.this$0;
                        String it = $i$f$getParentOfType2;
                        boolean bl = false;
                        if (argument.isNamed()) {
                            object = it;
                        } else {
                            String parameterName = ((KtParameter)next.getThird()).getName();
                            if (parameterName == null) {
                                return;
                            }
                            object = ArgumentReorderingTestMode.access$escapeName(argumentReorderingTestMode, parameterName) ? "`" + parameterName + "` = " + it : parameterName + " = " + it;
                        }
                        String nextText = object;
                        TextRange currentRange = ((KtValueArgument)current.getSecond()).getTextRange();
                        if (i == argumentCount - 2) {
                            for (PsiElement sibling = ((KtValueArgument)current.getSecond()).getNextSibling(); sibling != null && !Intrinsics.areEqual((Object)sibling, (Object)next.getSecond()); sibling = sibling.getNextSibling()) {
                                if (!(sibling instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)sibling).getElementType(), (Object)KtTokens.RPAR)) continue;
                                int offset = ((LeafPsiElement)sibling).getStartOffset();
                                int after = ((KtValueArgument)((Triple)arguments.get(argumentCount - 1)).getSecond()).getTextRange().getEndOffset();
                                this.$edits.add(UastSourceTransformationTestMode.EditVisitor.replace$default(this, offset, offset + 1, ",", false, 8, null));
                                this.$edits.add(UastSourceTransformationTestMode.EditVisitor.insert$default(this, after, ")", false, 4, null));
                                break;
                            }
                        }
                        UastSourceTransformationTestMode.EditVisitor editVisitor = this;
                        int n = currentRange.getStartOffset();
                        int n2 = currentRange.getEndOffset();
                        Intrinsics.checkNotNull((Object)nextText);
                        this.$edits.add(UastSourceTransformationTestMode.EditVisitor.replace$default(editVisitor, n, n2, nextText, false, 8, null));
                    }
                }
            }
        }));
        return edits;
    }

    private final boolean escapeName(String name) {
        boolean bl;
        block2: {
            CharSequence $this$any$iv = name;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                boolean bl3 = !Character.isJavaIdentifierPart(it);
                if (!bl3) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl || !Character.isJavaIdentifierStart(StringsKt.first((CharSequence)name))) {
            return true;
        }
        return Lint.isKotlinHardKeyword((String)name);
    }

    public static final /* synthetic */ boolean access$escapeName(ArgumentReorderingTestMode $this, String name) {
        return $this.escapeName(name);
    }
}

