/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependenciesWriter;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/lint/model/LintModelDependenciesWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "variantName", "", "artifactName", "writer", "Ljava/io/Writer;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/lang/String;Ljava/lang/String;Ljava/io/Writer;)V", "addDependencies", "", "item", "Lcom/android/tools/lint/model/LintModelDependency;", "map", "", "writeDependencies", "dependencies", "Lcom/android/tools/lint/model/LintModelDependencies;", "writeDependency", "library", "indent", "", "writeDependencyGraph", "tag", "graph", "Lcom/android/tools/lint/model/LintModelDependencyGraph;", "lint-model"})
final class LintModelDependenciesWriter
extends LintModelWriter {
    public LintModelDependenciesWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull String variantName, @NotNull String artifactName, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(adapter, new PrintWriter(writer));
    }

    public /* synthetic */ LintModelDependenciesWriter(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, String string, String string2, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            writer = lintModelSerializationAdapter.getWriter(LintModelSerialization.TargetFile.DEPENDENCIES, string, string2);
        }
        this(lintModelSerializationAdapter, string, string2, writer);
    }

    public final void writeDependencies(@NotNull LintModelDependencies dependencies) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        int indent = 0;
        this.indent(indent);
        this.getPrinter().println("<dependencies>");
        this.writeDependencyGraph("compile", dependencies.getCompileDependencies(), indent + 1);
        this.writeDependencyGraph("package", dependencies.getPackageDependencies(), indent + 1);
        this.indent(indent);
        this.getPrinter().println("</dependencies>");
        this.getPrinter().close();
    }

    private final void writeDependencyGraph(String tag, LintModelDependencyGraph graph, int indent) {
        LinkedHashMap graphItems = new LinkedHashMap();
        if (graph.getRoots().isEmpty()) {
            return;
        }
        for (LintModelDependency item : graph.getRoots()) {
            this.addDependencies(item, graphItems);
        }
        this.indent(indent);
        this.getPrinter().print("<");
        this.getPrinter().print(tag);
        String roots2 = CollectionsKt.joinToString$default((Iterable)graph.getRoots(), (CharSequence)",", null, null, (int)0, null, (Function1)writeDependencyGraph.roots.1.INSTANCE, (int)30, null);
        this.printAttribute(this.getPrinter(), "roots", roots2, indent);
        this.getPrinter().println(">");
        for (Map.Entry item : ((Map)graphItems).entrySet()) {
            this.writeDependency((LintModelDependency)item.getValue(), indent + 1);
        }
        this.indent(indent);
        this.getPrinter().print("</");
        this.getPrinter().print(tag);
        this.getPrinter().println(">");
    }

    private final void addDependencies(LintModelDependency item, Map<String, LintModelDependency> map) {
        if (map.containsKey(item.getIdentifier())) {
            return;
        }
        map.put(item.getIdentifier(), item);
        for (LintModelDependency dependency : item.getDependencies()) {
            this.addDependencies(dependency, map);
        }
    }

    private final void writeDependency(LintModelDependency library, int indent) {
        String roots2;
        this.indent(indent);
        this.getPrinter().print("<dependency");
        this.printName(this.getPrinter(), library.getIdentifier(), indent);
        this.printAttribute(this.getPrinter(), "simpleName", library.getArtifactName(), indent);
        String requestedCoordinates = library.getRequestedCoordinates();
        if (requestedCoordinates != null) {
            this.printAttribute(this.getPrinter(), "requested", requestedCoordinates, indent);
        }
        if (((CharSequence)(roots2 = CollectionsKt.joinToString$default((Iterable)library.getDependencies(), (CharSequence)",", null, null, (int)0, null, (Function1)writeDependency.roots.1.INSTANCE, (int)30, null))).length() > 0) {
            this.printAttribute(this.getPrinter(), "dependencies", roots2, indent);
        }
        this.getPrinter().println("/>");
    }
}

