/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.model.DefaultLintModelSourceProvider;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelSourceProvider;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\b\u0010\u001d\u001a\u00020\u0010H\u0004J\b\u0010\u001e\u001a\u00020\u0010H\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020!H\u0004J\u0012\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0010H\u0004J\u0012\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0010H\u0004J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0004J\u001c\u0010'\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00102\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0005H\u0004J \u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u0019\u001a\u00020\u00102\b\b\u0002\u0010*\u001a\u00020\u0010H\u0004J\b\u0010+\u001a\u00020\u0018H\u0004J\u0012\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u0010H\u0004J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020-0\u001c2\u0006\u0010.\u001a\u00020\u0010H\u0004J\b\u00100\u001a\u00020\u0018H\u0004J\f\u00101\u001a\u000202*\u00020\u0010H\u0004J\u000e\u00103\u001a\u0004\u0018\u000104*\u00020\u0010H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u00065"}, d2={"Lcom/android/tools/lint/model/LintModelReader;", "", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "root", "Ljava/io/File;", "reader", "Ljava/io/Reader;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/io/File;Ljava/io/Reader;)V", "getAdapter", "()Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "parser", "Lorg/kxml2/io/KXmlParser;", "getParser", "()Lorg/kxml2/io/KXmlParser;", "path", "", "getPath", "()Ljava/lang/String;", "getRoot", "()Ljava/io/File;", "setRoot", "(Ljava/io/File;)V", "expectTag", "", "name", "finishTag", "getFiles", "", "getLocation", "getName", "getOptionalAttribute", "getOptionalBoolean", "", "attribute", "default", "getOptionalFile", "getOptionalOutputFile", "getRequiredAttribute", "getRequiredFile", "relativeTo", "getStrings", "separator", "missingData", "readSourceProvider", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "tag", "readSourceProviders", "unexpectedTag", "toApiVersion", "Lcom/android/sdklib/AndroidVersion;", "toMavenCoordinate", "Lcom/android/tools/lint/model/LintModelMavenName;", "lint-model"})
abstract class LintModelReader {
    @NotNull
    private final LintModelSerialization.LintModelSerializationAdapter adapter;
    @Nullable
    private File root;
    @NotNull
    private final KXmlParser parser;

    public LintModelReader(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @Nullable File root, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.adapter = adapter;
        this.root = root;
        this.parser = new KXmlParser();
        this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        this.parser.setInput(reader);
    }

    @NotNull
    protected final LintModelSerialization.LintModelSerializationAdapter getAdapter() {
        return this.adapter;
    }

    @Nullable
    protected final File getRoot() {
        return this.root;
    }

    protected final void setRoot(@Nullable File file) {
        this.root = file;
    }

    @NotNull
    protected abstract String getPath();

    @NotNull
    protected final KXmlParser getParser() {
        return this.parser;
    }

    @NotNull
    protected final AndroidVersion toApiVersion(@NotNull String $this$toApiVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toApiVersion, (String)"<this>");
        return new AndroidVersion($this$toApiVersion);
    }

    @Nullable
    protected final LintModelMavenName toMavenCoordinate(@NotNull String $this$toMavenCoordinate) {
        Intrinsics.checkNotNullParameter((Object)$this$toMavenCoordinate, (String)"<this>");
        return LintModelMavenName.Companion.parse($this$toMavenCoordinate);
    }

    @NotNull
    protected final String getLocation() {
        return this.getPath() + ':' + this.parser.getLineNumber();
    }

    protected final void expectTag(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)name, (Object)this.parser.getName())) {
            String string = "Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation() + "; expected `<" + name + ">`";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    protected final void unexpectedTag() {
        String string = "Unexpected tag `<" + this.parser.getName() + ">` at " + this.getLocation();
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    protected final void missingData() {
        String string = Intrinsics.stringPlus((String)"Missing data at ", (Object)this.getLocation());
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    protected final void finishTag(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        block4: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            switch (eventType) {
                case 2: {
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag(name);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    @Nullable
    protected final String getOptionalAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.parser.getAttributeValue(null, name);
    }

    @NotNull
    protected final String getRequiredAttribute(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.parser.getAttributeValue(null, name);
        if (string == null) {
            String string2 = "Expected `" + name + "` attribute in <" + this.parser.getName() + "> tag at " + this.getLocation();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    protected final String getName() {
        return this.getRequiredAttribute("name");
    }

    @Nullable
    protected final File getOptionalFile(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return null;
        }
        String path = string;
        return this.adapter.fromPathString(path, this.root);
    }

    @Nullable
    protected final File getOptionalOutputFile(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return null;
        }
        String path = string;
        File relativeTo = Intrinsics.areEqual((Object)path, (Object)"stderr") || Intrinsics.areEqual((Object)path, (Object)"stdout") ? null : this.root;
        return this.adapter.fromPathString(path, relativeTo);
    }

    @NotNull
    protected final File getRequiredFile(@NotNull String attribute, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String path = this.getRequiredAttribute(attribute);
        return this.adapter.fromPathString(path, relativeTo);
    }

    public static /* synthetic */ File getRequiredFile$default(LintModelReader lintModelReader, String string, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRequiredFile");
        }
        if ((n & 2) != 0) {
            file = lintModelReader.root;
        }
        return lintModelReader.getRequiredFile(string, file);
    }

    protected final boolean getOptionalBoolean(@NotNull String attribute, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String string = this.getOptionalAttribute(attribute);
        if (string == null) {
            return bl;
        }
        String value = string;
        return Intrinsics.areEqual((Object)value, (Object)"true");
    }

    @NotNull
    protected final List<String> getStrings(@NotNull String name, @NotNull String separator) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        String string = this.getOptionalAttribute(name);
        if (string == null) {
            list = null;
        } else {
            String[] stringArray = new String[]{separator};
            list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        List list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    public static /* synthetic */ List getStrings$default(LintModelReader lintModelReader, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStrings");
        }
        if ((n & 2) != 0) {
            string2 = ",";
        }
        return lintModelReader.getStrings(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<File> getFiles(@NotNull String name) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = this.getOptionalAttribute(name);
        if (string == null) {
            list = null;
        } else {
            CharSequence charSequence = string;
            String[] stringArray = new String[1];
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathSeparator");
            stringArray[0] = string2;
            List list2 = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (list2 == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void path;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    File file = new File((String)path);
                    File file2 = this.getRoot() != null && !file.isAbsolute() ? new File(this.getRoot(), (String)path) : file;
                    collection.add(file2);
                }
                list = (List)destination$iv$iv;
            }
        }
        List list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    @NotNull
    protected final LintModelSourceProvider readSourceProvider(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.expectTag(tag);
        File manifestFile = LintModelReader.getRequiredFile$default(this, "manifest", null, 2, null);
        List<File> javaDirectories = this.getFiles("javaDirectories");
        List<File> resDirectories = this.getFiles("resDirectories");
        List<File> assetsDirectories = this.getFiles("assetsDirectories");
        boolean androidTestOnly = this.getOptionalBoolean("androidTest", false);
        boolean unitTestOnly = this.getOptionalBoolean("unitTest", false);
        boolean debugOnly = this.getOptionalBoolean("debugOnly", false);
        this.finishTag(tag);
        return new DefaultLintModelSourceProvider(manifestFile, (Collection<? extends File>)javaDirectories, (Collection<? extends File>)resDirectories, (Collection<? extends File>)assetsDirectories, debugOnly, unitTestOnly, androidTestOnly);
    }

    public static /* synthetic */ LintModelSourceProvider readSourceProvider$default(LintModelReader lintModelReader, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readSourceProvider");
        }
        if ((n & 1) != 0) {
            string = "sourceProvider";
        }
        return lintModelReader.readSourceProvider(string);
    }

    @NotNull
    protected final List<LintModelSourceProvider> readSourceProviders(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.expectTag(tag);
        boolean bl = false;
        List sourceProviders = new ArrayList();
        block4: while (this.parser.next() != 1) {
            int eventType = this.parser.getEventType();
            switch (eventType) {
                case 2: {
                    String string = this.parser.getName();
                    if (Intrinsics.areEqual((Object)string, (Object)"sourceProvider")) {
                        sourceProviders.add(LintModelReader.readSourceProvider$default(this, null, 1, null));
                        continue block4;
                    }
                    this.unexpectedTag();
                    continue block4;
                }
                case 3: {
                    this.expectTag(tag);
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return sourceProviders;
    }
}

