/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "cachedQueryPermissions", "Lcom/android/tools/lint/checks/PackageVisibilityDetector$QueryPermissions;", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableElements", "", "", "getApplicableMethodNames", "", "getQueryPermissions", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "QueryPermissions", "lint-checks"})
public final class PackageVisibilityDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private QueryPermissions cachedQueryPermissions;
    private static final int INITIAL_API = 30;
    @NotNull
    private static final String KEY_REQ_QUERY_ALL = "queryAll";
    @JvmField
    @NotNull
    public static final Issue QUERY_ALL_PACKAGES_PERMISSION;
    @JvmField
    @NotNull
    public static final Issue QUERY_PERMISSIONS_NEEDED;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr permission = attr;
        if (Intrinsics.areEqual((Object)permission.getValue(), (Object)"android.permission.QUERY_ALL_PACKAGES")) {
            Incident incident = new Incident(QUERY_ALL_PACKAGES_PERMISSION, context.getLocation((Node)permission), "A `<queries>` declaration should generally be used instead of QUERY_ALL_PACKAGES; \\\nsee https://g.co/dev/packagevisibility for details");
            context.report(incident, Constraints.targetSdkAtLeast((int)30));
        }
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"getInstalledPackages", "getInstalledApplications", "queryBroadcastReceivers", "queryContentProviders", "queryIntentServices", "queryIntentActivities", "resolveActivity", "resolveActivityInfo"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Incident incident;
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!context.isEnabled(QUERY_PERMISSIONS_NEEDED)) {
            return;
        }
        String methodName = node.getMethodName();
        String string2 = methodName;
        if (string2 == null) throw new IllegalStateException(("Unexpected method name: " + methodName).toString());
        int n = -1;
        switch (string2.hashCode()) {
            case -150905391: {
                if (string2.equals("getInstalledPackages")) {
                    n = 1;
                }
                break;
            }
            case 1700882705: {
                if (string2.equals("queryContentProviders")) {
                    n = 1;
                }
                break;
            }
            case 1600494599: {
                if (string2.equals("getInstalledApplications")) {
                    n = 1;
                }
                break;
            }
            case -1721890933: {
                if (string2.equals("queryBroadcastReceivers")) {
                    n = 1;
                }
                break;
            }
            case -109758974: {
                if (string2.equals("queryIntentServices")) {
                    n = 1;
                }
                break;
            }
            case 1374193809: {
                if (string2.equals("queryIntentActivities")) {
                    n = 1;
                }
                break;
            }
            case -1219166103: {
                if (string2.equals("resolveActivityInfo")) {
                    n = 2;
                }
                break;
            }
            case 630467867: {
                if (string2.equals("resolveActivity")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                string = "android.content.pm.PackageManager";
                break;
            }
            case 2: {
                string = "android.content.Intent";
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected method name: " + methodName).toString());
            }
        }
        String intendedOwner = string;
        if (!JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)intendedOwner, (boolean)false, (int)4, null)) {
            return;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"getInstalledPackages") || Intrinsics.areEqual((Object)methodName, (Object)"getInstalledApplications")) {
            UIdentifier uIdentifier = node.getMethodIdentifier();
            UIdentifier uIdentifier2 = node.getMethodIdentifier();
            incident = new Incident(QUERY_PERMISSIONS_NEEDED, (Object)(uIdentifier != null ? (UElement)uIdentifier : (UElement)node), context.getLocation(uIdentifier2 != null ? (UElement)uIdentifier2 : (UElement)node), "As of Android 11, this method no longer returns information about all apps; \\\nsee https://g.co/dev/packagevisibility for details");
            context.report(incident, this.map().put(KEY_REQ_QUERY_ALL, true));
            return;
        } else {
            UIdentifier uIdentifier = node.getMethodIdentifier();
            UIdentifier uIdentifier3 = node.getMethodIdentifier();
            incident = new Incident(QUERY_PERMISSIONS_NEEDED, (Object)(uIdentifier != null ? (UElement)uIdentifier : (UElement)node), context.getLocation(uIdentifier3 != null ? (UElement)uIdentifier3 : (UElement)node), "Consider adding a `<queries>` declaration to your manifest when calling this \\\nmethod; see https://g.co/dev/packagevisibility for details");
            context.report(incident, this.map().put(KEY_REQ_QUERY_ALL, false));
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() >= 30) {
            Boolean bl = map.getBoolean(KEY_REQ_QUERY_ALL, null);
            if (bl == null) {
                return true;
            }
            boolean requirePermissions = bl;
            QueryPermissions queryPermissions = this.getQueryPermissions(context);
            if (queryPermissions == null) {
                return false;
            }
            QueryPermissions permissions = queryPermissions;
            return !(requirePermissions ? permissions.getCanQueryAllPackages() : permissions.getCanQuerySomePackages());
        }
        return false;
    }

    private final QueryPermissions getQueryPermissions(Context context) {
        QueryPermissions queryPermissions = this.cachedQueryPermissions;
        if (queryPermissions != null) {
            QueryPermissions it = queryPermissions;
            boolean bl = false;
            return it;
        }
        Document document = context.getMainProject().getMergedManifest();
        if (document == null) {
            return null;
        }
        Document manifest = document;
        boolean canQuerySomePackages = false;
        boolean canQueryAllPackages = false;
        Element element = manifest.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
        Object object = DomExtensions.iterator((Element)element);
        while (object.hasNext()) {
            Attr permission;
            Element tag = (Element)object.next();
            String string = tag.getNodeName();
            if (Intrinsics.areEqual((Object)string, (Object)"queries")) {
                canQuerySomePackages = true;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"uses-permission")) continue;
            Attr attr = permission = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (!Intrinsics.areEqual((Object)(attr != null ? attr.getValue() : null), (Object)"android.permission.QUERY_ALL_PACKAGES")) continue;
            canQuerySomePackages = true;
            canQueryAllPackages = true;
        }
        Object it = object = new QueryPermissions(canQuerySomePackages, canQueryAllPackages);
        boolean bl = false;
        this.cachedQueryPermissions = it;
        return object;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.COMPLIANCE;
        Severity severity = Severity.ERROR;
        Implementation implementation = new Implementation(PackageVisibilityDetector.class, Scope.MANIFEST_SCOPE);
        QUERY_ALL_PACKAGES_PERMISSION = Issue.Companion.create$default((Issue.Companion)companion, (String)"QueryAllPackagesPermission", (String)"Using the QUERY_ALL_PACKAGES permission", (String)"\n            If you need to query or interact with other installed apps, you should be using a \\\n            `<queries>` declaration in your manifest. Using the QUERY_ALL_PACKAGES permission in \\\n            order to see all installed apps is rarely necessary, and most apps on Google Play are \\\n            not allowed to have this permission.\n            ", (Implementation)implementation, (String)"https://g.co/dev/packagevisibility", (Category)category, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        implementation = new Implementation(PackageVisibilityDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), enumSetArray);
        QUERY_PERMISSIONS_NEEDED = Issue.Companion.create$default((Issue.Companion)companion, (String)"QueryPermissionsNeeded", (String)"Using APIs affected by query permissions", (String)"\n            Apps that target Android 11 cannot query or interact with other installed apps \\\n            by default. If you need to query or interact with other installed apps, you may need \\\n            to add a `<queries>` declaration in your manifest.\n\n            As a corollary, the methods `PackageManager#getInstalledPackages` and \\\n            `PackageManager#getInstalledApplications` will no longer return information about all \\\n            installed apps. To query specific apps or types of apps, you can use methods like \\\n            `PackageManager#getPackageInfo` or `PackageManager#queryIntentActivities`.\n            ", (Implementation)implementation, (String)"https://g.co/dev/packagevisibility", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector$Companion;", "", "()V", "INITIAL_API", "", "KEY_REQ_QUERY_ALL", "", "QUERY_ALL_PACKAGES_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "QUERY_PERMISSIONS_NEEDED", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/PackageVisibilityDetector$QueryPermissions;", "", "canQuerySomePackages", "", "canQueryAllPackages", "(ZZ)V", "getCanQueryAllPackages", "()Z", "getCanQuerySomePackages", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "lint-checks"})
    private static final class QueryPermissions {
        private final boolean canQuerySomePackages;
        private final boolean canQueryAllPackages;

        public QueryPermissions(boolean canQuerySomePackages, boolean canQueryAllPackages) {
            this.canQuerySomePackages = canQuerySomePackages;
            this.canQueryAllPackages = canQueryAllPackages;
        }

        public final boolean getCanQuerySomePackages() {
            return this.canQuerySomePackages;
        }

        public final boolean getCanQueryAllPackages() {
            return this.canQueryAllPackages;
        }

        public final boolean component1() {
            return this.canQuerySomePackages;
        }

        public final boolean component2() {
            return this.canQueryAllPackages;
        }

        @NotNull
        public final QueryPermissions copy(boolean canQuerySomePackages, boolean canQueryAllPackages) {
            return new QueryPermissions(canQuerySomePackages, canQueryAllPackages);
        }

        public static /* synthetic */ QueryPermissions copy$default(QueryPermissions queryPermissions, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = queryPermissions.canQuerySomePackages;
            }
            if ((n & 2) != 0) {
                bl2 = queryPermissions.canQueryAllPackages;
            }
            return queryPermissions.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "QueryPermissions(canQuerySomePackages=" + this.canQuerySomePackages + ", canQueryAllPackages=" + this.canQueryAllPackages + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.canQuerySomePackages);
            result = result * 31 + Boolean.hashCode(this.canQueryAllPackages);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QueryPermissions)) {
                return false;
            }
            QueryPermissions queryPermissions = (QueryPermissions)other;
            if (this.canQuerySomePackages != queryPermissions.canQuerySomePackages) {
                return false;
            }
            return this.canQueryAllPackages == queryPermissions.canQueryAllPackages;
        }
    }
}

