/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.detector.api.ExtensionSdk;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ApiParser
extends DefaultHandler {
    private static final String NODE_CLASS = "class";
    private static final String NODE_FIELD = "field";
    private static final String NODE_METHOD = "method";
    private static final String NODE_EXTENDS = "extends";
    private static final String NODE_IMPLEMENTS = "implements";
    private static final String NODE_SDK = "sdk";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SINCE = "since";
    private static final String ATTR_SDKS = "sdks";
    private static final String ATTR_DEPRECATED = "deprecated";
    private static final String ATTR_REMOVED = "removed";
    private static final String ATTR_REFERENCE = "reference";
    private final Map<String, ApiClass> mClasses = new HashMap<String, ApiClass>(7000);
    private final Map<String, ApiClassOwner<ApiClass>> mContainers = new HashMap<String, ApiClassOwner<ApiClass>>(1200);
    private final List<ExtensionSdk> mSdks = new ArrayList<ExtensionSdk>();
    private ApiClass mCurrentClass;

    ApiParser() {
    }

    Map<String, ApiClass> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiClassOwner<ApiClass>> getContainers() {
        return this.mContainers;
    }

    public List<ExtensionSdk> getExtensionSdks() {
        return this.mSdks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName == null || localName.isEmpty()) {
            localName = qName;
        }
        try {
            if (NODE_METHOD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                String sdks = this.getSdks(attributes, true);
                int since = this.getSince(attributes);
                int deprecatedIn = this.getDeprecatedIn(attributes);
                int removedIn = this.getRemovedIn(attributes);
                this.mCurrentClass.addMethod(name, sdks, since, deprecatedIn, removedIn);
            } else if (NODE_FIELD.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                String sdks = this.getSdks(attributes, true);
                int since = this.getSince(attributes);
                int deprecatedIn = this.getDeprecatedIn(attributes);
                int removedIn = this.getRemovedIn(attributes);
                if (since == 28 && (name.equals("navigationBarDividerColor") || name.equals("windowLightNavigationBar") && this.mCurrentClass.getName().equals("android/R$attr"))) {
                    since = 27;
                }
                this.mCurrentClass.addField(name, sdks, since, deprecatedIn, removedIn);
            } else if (NODE_IMPLEMENTS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int removedIn = this.getRemovedIn(attributes);
                this.mCurrentClass.addInterface(name, since, removedIn);
            } else if (NODE_EXTENDS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                int since = this.getSince(attributes);
                int removedIn = this.getRemovedIn(attributes);
                this.mCurrentClass.addSuperClass(name, since, removedIn);
            } else if (NODE_CLASS.equals(localName)) {
                String name = attributes.getValue(ATTR_NAME);
                String sdks = this.getSdks(attributes, false);
                int since = this.getAttributeValue(attributes, ATTR_SINCE, 1);
                int deprecatedIn = this.getAttributeValue(attributes, ATTR_DEPRECATED, 0);
                int removedIn = this.getAttributeValue(attributes, ATTR_REMOVED, 0);
                this.mCurrentClass = this.addClass(name, sdks, since, deprecatedIn, removedIn);
            } else if (NODE_SDK.equals(localName)) {
                String id = attributes.getValue("id");
                String name = attributes.getValue(ATTR_NAME);
                String reference = attributes.getValue(ATTR_REFERENCE);
                if (reference != null) {
                    reference = reference.replace('/', '.').replace('$', '.');
                }
                this.mSdks.add(new ExtensionSdk(name, Integer.decode(id).intValue(), reference));
            }
        }
        finally {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    private ApiClass addClass(String name, String sdks, int apiLevel, int deprecatedIn, int removedIn) {
        ApiClass cls = this.mClasses.get(name);
        assert (cls == null);
        cls = new ApiClass(name, sdks, apiLevel, deprecatedIn, removedIn);
        this.mClasses.put(name, cls);
        String containerName = cls.getContainerName();
        int len = containerName.length();
        boolean isClass = len < name.length() && name.charAt(len) == '$';
        ApiClassOwner<ApiClass> container = this.mContainers.get(containerName);
        if (container == null) {
            container = new ApiClassOwner(containerName, isClass);
            this.mContainers.put(containerName, container);
        } else if (container.isClass() != isClass) {
            throw new RuntimeException("\"" + containerName + "\" is both a package and a class");
        }
        container.addClass(cls);
        return cls;
    }

    private int getSince(Attributes attributes) {
        return this.getAttributeValue(attributes, ATTR_SINCE, this.mCurrentClass.getSince());
    }

    private int getDeprecatedIn(Attributes attributes) {
        return this.getAttributeValue(attributes, ATTR_DEPRECATED, this.mCurrentClass.getDeprecatedIn());
    }

    private int getRemovedIn(Attributes attributes) {
        return this.getAttributeValue(attributes, ATTR_REMOVED, this.mCurrentClass.getRemovedIn());
    }

    private String getSdks(Attributes attributes, boolean inherit) {
        String sdks = attributes.getValue(ATTR_SDKS);
        if (sdks == null && inherit) {
            sdks = this.mCurrentClass.getSdks();
        }
        return sdks;
    }

    private int getAttributeValue(Attributes attributes, String attributeName, int defaultValue) {
        String attributeValue = attributes.getValue(attributeName);
        return attributeValue == null ? defaultValue : Integer.parseInt(attributeValue);
    }
}

