/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiElement;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/WearRecentsDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableElements", "", "", "getApplicableReferenceNames", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitReference", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Issues", "lint-checks"})
public final class WearRecentsDetector
extends WearDetector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"activity");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.isWearProject()) {
            return;
        }
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "excludeFromRecents")) {
            if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "noHistory")) {
                context.report(ISSUE, context.getLocation((Node)element), "In addition to `excludeFromRecents`, set `noHistory` flag to avoid showing this activity in recents", this.fix().name("Set noHistory").set("http://schemas.android.com/apk/res/android", "noHistory", "true").build());
            }
            return;
        }
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "taskAffinity")) {
            LintFix[] lintFixArray = new LintFix[2];
            lintFixArray[0] = this.fix().name("Set `taskAffinity`").set("http://schemas.android.com/apk/res/android", "taskAffinity", "").autoFix().build();
            LintFix[] lintFixArray2 = new LintFix[]{this.fix().set("http://schemas.android.com/apk/res/android", "excludeFromRecents", "true").build(), this.fix().set("http://schemas.android.com/apk/res/android", "noHistory", "true").build()};
            lintFixArray[1] = this.fix().name("Exclude from recents").composite(lintFixArray2).autoFix();
            context.report(ISSUE, context.getLocation((Node)element), "Set `taskAffinity` for Wear activities to make them appear correctly in recents", this.fix().alternatives(lintFixArray));
        }
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        Object[] objectArray = new String[]{"FLAG_ACTIVITY_NEW_TASK", "FLAG_ACTIVITY_CLEAR_TOP"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        if (!this.isWearProject()) {
            return;
        }
        Context.report$default((Context)((Context)context), (Issue)ISSUE, (Location)context.getLocation((UElement)reference), (String)"Avoid using `FLAG_ACTIVITY_NEW_TASK` and `FLAG_ACTIVITY_CLEAR_TOP`", null, (int)8, null);
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        IMPLEMENTATION = new Implementation(WearRecentsDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST), enumSetArray);
        enumSetArray = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)enumSetArray, (String)"WearRecents", (String)"Wear OS: Recents and app resume", (String)"\n          In recents, correctly represent your app's activities, consistent with device implementation.\n        ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)true, null, null, null, (int)3664, null).addMoreInfo("https://developer.android.com/training/wearables/apps/launcher");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/WearRecentsDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

