/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.LocationType;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u00012\u00020\u00022\u00020\u0003:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0016J\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/lint/checks/TranslucentViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "defaultTheme", "", "interestingActivities", "", "interestingThemes", "addActivity", "", "name", "addTheme", "theme", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "filterIncident", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableAttributes", "", "getApplicableElements", "getApplicableMethodNames", "", "getThemeName", "themeUrl", "isScreenOrientationFixed", "orientation", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "visitElement", "element", "Lorg/w3c/dom/Element;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "lint-checks"})
public final class TranslucentViewDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @Nullable
    private List<String> interestingActivities;
    @Nullable
    private List<String> interestingThemes;
    @Nullable
    private String defaultTheme;
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("TranslucentOrientation", "Mixing screenOrientation and translucency", "\n            Specifying a fixed screen orientation with a translucent theme isn't supported \\\n            on apps with `targetSdkVersion` O or greater since there can be an another activity \\\n            visible behind your activity with a conflicting request.\n\n            For example, your activity requests landscape and the visible activity behind \\\n            your translucent activity request portrait. In this case the system can only \\\n            honor one of the requests and currently prefers to honor the request from \\\n            non-translucent activities since there is nothing visible behind them.\n\n            Devices running platform version O or greater will throw an exception in your \\\n            app if this state is detected.\n            ", Category.CORRECTNESS, 8, Severity.WARNING, new Implementation(TranslucentViewDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.JAVA_FILE)));

    @NotNull
    public Collection<String> getApplicableAttributes() {
        return CollectionsKt.listOf((Object)"screenOrientation");
    }

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"style");
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    private final boolean isScreenOrientationFixed(String orientation) {
        return StringsKt.endsWith((String)orientation, (String)"portrait", (boolean)true) || StringsKt.endsWith((String)orientation, (String)"landscape", (boolean)true);
    }

    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (!Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)attribute.getNamespaceURI())) {
            return;
        }
        String value = attribute.getValue();
        Intrinsics.checkNotNull((Object)value);
        if (!this.isScreenOrientationFixed(value)) {
            return;
        }
        Element activity = attribute.getOwnerElement();
        if (activity == null || !activity.hasAttributeNS("http://schemas.android.com/apk/res/android", "name")) {
            return;
        }
        String name = Lint.resolveManifestName((Element)activity, (Project)context.getProject());
        String theme = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "theme");
        Intrinsics.checkNotNull((Object)theme);
        if (StringsKt.isBlank((CharSequence)theme)) {
            Element application;
            Node node = activity.getParentNode();
            Element element = application = node instanceof Element ? (Element)node : null;
            this.defaultTheme = this.getThemeName(element != null ? element.getAttributeNS("http://schemas.android.com/apk/res/android", "theme") : null);
            this.addActivity(name);
        } else {
            this.addTheme(this.getThemeName(theme));
        }
    }

    private final void addActivity(String name) {
        List list = this.interestingActivities;
        if (list == null) {
            List newList;
            TranslucentViewDetector $this$addActivity_u24lambda_u240 = this;
            boolean bl = false;
            $this$addActivity_u24lambda_u240.interestingActivities = newList = (List)new ArrayList();
            list = newList;
        }
        List activities = list;
        activities.add((String)name);
    }

    private final void addTheme(String theme) {
        if (theme == null) {
            return;
        }
        List list = this.interestingThemes;
        if (list == null) {
            List newList;
            TranslucentViewDetector $this$addTheme_u24lambda_u241 = this;
            boolean bl = false;
            $this$addTheme_u24lambda_u241.interestingThemes = newList = (List)new ArrayList();
            list = newList;
        }
        List themes = list;
        themes.add((String)theme);
    }

    private final String getThemeName(String themeUrl) {
        ResourceUrl theme;
        if (themeUrl == null) {
            return null;
        }
        ResourceUrl resourceUrl = theme = ResourceUrl.parse((String)themeUrl);
        return (resourceUrl != null ? resourceUrl.type : null) == ResourceType.STYLE && !theme.isFramework() ? theme.name : null;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<String> themes = this.interestingThemes;
        if (themes == null && this.defaultTheme == null) {
            return;
        }
        String themeName = element.getAttribute("name");
        if (Intrinsics.areEqual((Object)themeName, (Object)this.defaultTheme) || themes != null && themes.contains(themeName)) {
            Element curr = XmlUtils.getFirstSubTagByName((Node)element, (String)"item");
            while (curr != null) {
                String attributeName = curr.getAttribute("name");
                if (Intrinsics.areEqual((Object)attributeName, (Object)"android:windowIsFloating") || Intrinsics.areEqual((Object)attributeName, (Object)"windowIsTranslucent")) {
                    Attr attributeNode = curr.getAttributeNode("name");
                    Intrinsics.checkNotNull((Object)attributeNode);
                    Location location = context.getValueLocation(attributeNode);
                    String message2 = "Should not specify screen orientation with translucent or floating theme";
                    Incident incident = new Incident(ISSUE, (Object)curr, location, message2);
                    LintMap lintMap = this.map();
                    Intrinsics.checkNotNull((Object)themeName);
                    context.report(incident, lintMap.put("theme", themeName));
                    break;
                }
                curr = XmlUtils.getNextTagByName((Node)curr, (String)"item");
            }
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() < 26) {
            return false;
        }
        Document document = context.getMainProject().getMergedManifest();
        if (document == null) {
            return false;
        }
        Document mergedManifest = document;
        Element application = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application");
        Element currentActivity = XmlUtils.getFirstSubTag((Node)application);
        Location last = incident.getLocation();
        String theme = map.getString("theme", "");
        while (currentActivity != null) {
            String name;
            Attr attr = currentActivity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "screenOrientation");
            if (attr != null && (Intrinsics.areEqual((Object)(name = this.getThemeName(currentActivity.getAttributeNS("http://schemas.android.com/apk/res/android", "theme"))), (Object)theme) || name == null)) {
                Location secondary = context.getLocation((Object)attr, LocationType.VALUE);
                last.setSecondary(secondary);
                last = secondary;
            }
            currentActivity = XmlUtils.getNextTag((Node)currentActivity);
        }
        return true;
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"setTheme");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        ResourceReference reference;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        List<String> list = this.interestingActivities;
        if (list == null) {
            return;
        }
        List<String> activities = list;
        UClass uClass = (UClass)UastUtils.getParentOfType((UElement)((UElement)node), UClass.class, (boolean)true);
        if (uClass == null) {
            return;
        }
        UClass uClass2 = uClass;
        if (!CollectionsKt.contains((Iterable)activities, (Object)uClass2.getQualifiedName())) {
            return;
        }
        if (!context.getEvaluator().inheritsFrom((PsiClass)uClass2, "android.app.Activity", false)) {
            return;
        }
        List arguments = node.getValueArguments();
        if (arguments.size() != 1) {
            return;
        }
        ResourceReference resourceReference = reference = ResourceReference.Companion.get((UElement)arguments.get(0));
        if ((resourceReference != null ? resourceReference.getType() : null) == ResourceType.STYLE && !Intrinsics.areEqual((Object)reference.getPackage(), (Object)"android")) {
            this.addTheme(reference.getName());
            context.getDriver().requestRepeat((Detector)this, Scope.ALL_RESOURCES_SCOPE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/TranslucentViewDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

