/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/StringEscapeDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkXmlEscapes", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "textNode", "Lorg/w3c/dom/Node;", "element", "Lorg/w3c/dom/Element;", "string", "", "findTextNode", "parent", "getApplicableElements", "", "visitElement", "Issues", "lint-checks"})
public final class StringEscapeDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue STRING_ESCAPING = Issue.Companion.create("StringEscaping", "Invalid string escapes", "\n                Apostrophes (') must always be escaped (with a \\\\\\\\), unless they appear \\\n                in a string which is itself escaped in double quotes (\\\").\n                ", Category.MESSAGES, 9, Severity.ERROR, new Implementation(StringEscapeDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"string", "string-array", "plurals"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = element.getTagName();
            if (string == null) break block13;
            int n = -1;
            switch (string.hashCode()) {
                case -1024600675: {
                    if (string.equals("string-array")) {
                        n = 1;
                    }
                    break;
                }
                case -891985903: {
                    if (string.equals("string")) {
                        n = 2;
                    }
                    break;
                }
                case -475309713: {
                    if (string.equals("plurals")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.findTextNode(context, element);
                    break;
                }
                case 1: {
                    int n2 = element.getChildNodes().getLength();
                    for (int index2 = 0; index2 < n2; ++index2) {
                        Node child = element.getChildNodes().item(index2);
                        if (child.getNodeType() != 1) continue;
                        Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                        this.findTextNode(context, (Element)child);
                    }
                    break;
                }
            }
        }
    }

    private final void findTextNode(XmlContext context, Element parent) {
        int n = parent.getChildNodes().getLength();
        for (int index2 = 0; index2 < n; ++index2) {
            Node child = parent.getChildNodes().item(index2);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            Intrinsics.checkNotNull((Object)child);
            String string = child.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeValue(...)");
            this.checkXmlEscapes(context, child, parent, string);
            return;
        }
    }

    private final void checkXmlEscapes(XmlContext context, Node textNode, Element element, String string) {
        int len;
        int s = 0;
        for (len = string.length(); len > 0 && CharsKt.isWhitespace((char)string.charAt(s)); --len) {
            ++s;
        }
        while (len > 0 && CharsKt.isWhitespace((char)string.charAt(s + len - 1))) {
            --len;
        }
        if (len > 0 && string.charAt(s + len - 1) == '\\' && s + len < string.length()) {
            ++len;
        }
        char quoted = '\u0000';
        int p = s;
        while (p < s + len) {
            char c;
            while (p < s + len && (c = string.charAt(p)) != '\\' && (quoted != '\u0000' || !CharsKt.isWhitespace((char)c) || c == ' ' && !CharsKt.isWhitespace((char)string.charAt(p + 1))) && (c != '\"' || quoted != '\u0000' && quoted != '\"')) {
                if (c == '\'' && (quoted == '\u0000' || quoted == '\'')) {
                    Location location = context.getLocation(textNode, p, len);
                    LintFix fix = this.fix().name("Escape Apostrophe").replace().pattern("[^\\\\]?(')").with("\\'").build();
                    context.report(STRING_ESCAPING, (Node)element, location, "Apostrophe not preceded by \\\\", fix);
                    return;
                }
                ++p;
            }
            if (p >= s + len) continue;
            char cp = string.charAt(p);
            if (cp == '\"' || cp == '\'') {
                quoted = quoted == '\u0000' ? cp : (char)'\u0000';
                ++p;
            } else if (CharsKt.isWhitespace((char)cp)) {
                ++p;
                while (p < s + len && CharsKt.isWhitespace((char)string.charAt(p))) {
                    ++p;
                }
            } else if (cp == '\\' && ++p < s + len) {
                char c2 = string.charAt(p);
                if (!(((((((c2 == 't' ? true : c2 == 'n') ? true : c2 == '#') ? true : c2 == '@') ? true : c2 == '?') ? true : c2 == '\"') ? true : c2 == '\'') ? true : c2 == '\\') && c2 == 'u') {
                    for (int i = 0; i < 4 && p + 1 < len; ++i) {
                        char h;
                        if (Intrinsics.compare((int)(h = string.charAt(++p)), (int)48) >= 0 && Intrinsics.compare((int)h, (int)57) <= 0 || Intrinsics.compare((int)h, (int)97) >= 0 && Intrinsics.compare((int)h, (int)102) <= 0 || Intrinsics.compare((int)h, (int)65) >= 0 && Intrinsics.compare((int)h, (int)70) <= 0) continue;
                        Location location = context.getLocation(textNode, p, p + 1);
                        XmlContext.report$default((XmlContext)context, (Issue)STRING_ESCAPING, (Node)element, (Location)location, (String)"Bad character in \\\\u unicode escape sequence", null, (int)16, null);
                        return;
                    }
                }
                ++p;
            }
            len -= p - s;
            s = p;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/StringEscapeDetector$Issues;", "", "()V", "STRING_ESCAPING", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

